/*
 * The MIT License

   Conograph (powder auto-indexing program)

Copyright (c) <2012> <Ryoko Oishi-Tomiyasu, KEK>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 *
 */
#ifndef LATTICESYMMETRY_HH_
#define LATTICESYMMETRY_HH_


#include "LatticeFigureOfMerit.hh"
#include "lattice_symmetry.hh"

class VCData;


class ReducedLatticeToCheckEquiv
{
private:
	const Double m_resol2;
	
protected:
	// Minkowski reduced.
	// S_super_obtuse = m_S_red.second * m_S_red.first * Transpose(m_S_red.second).
	const SymMat43_Double  m_S_red;
//	const SymMat<VCData> m_S_super_obtuse;

	// Almost obtuse matrix that is equivalent with m_S_super_obtuse.
	vector< SymMat<Double> > m_S_super_obtuse_equiv;
//	vector< set< NRMat<Int4> > > m_trans_mat_S_super_obtuse_equiv;
	
public:
	// trans_mat : (4,3)-matrix s.t. trans_mat.first * S_red * Transpose(trans_mat.first) is obtuse.
	ReducedLatticeToCheckEquiv(const Double& resol2,
									const SymMat43_Double& S_red);
	~ReducedLatticeToCheckEquiv();

	inline const SymMat43_Double& putMinkowskiReducedForm() const { return m_S_red; };

	// Returns true if the argument S_super_obtuse almost equivalent with m_S_super_obtuse.
	// In this case, Inverse(Inv_S_super_obtuse) equals trans_mat * m_S_super_obtuse * Transpose(trans_mat).
	bool equiv(const SymMat<Double>& S_super_obtuse) const;

};



#endif /*LATTICESYMMETRY_HH_*/
