/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.Serializable;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.control.ControlCommand;
import org.apache.axis2.clustering.control.GetConfigurationCommand;
import org.apache.axis2.clustering.control.GetStateCommand;
import org.apache.axis2.clustering.tribes.ControlCommandProcessor;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.group.RpcCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InitializationRequestHandler
implements RpcCallback {
    private static Log log = LogFactory.getLog((Class)InitializationRequestHandler.class);
    private ControlCommandProcessor controlCommandProcessor;

    public InitializationRequestHandler(ControlCommandProcessor controlCommandProcessor) {
        this.controlCommandProcessor = controlCommandProcessor;
    }

    public Serializable replyRequest(Serializable msg, Member member) {
        if (msg instanceof GetStateCommand || msg instanceof GetConfigurationCommand) {
            try {
                log.info((Object)("Received " + msg + " initialization request message from " + TribesUtil.getHost(member)));
                return this.controlCommandProcessor.process((ControlCommand)((Object)msg));
            }
            catch (ClusteringFault e) {
                String errMsg = "Cannot handle initialization request";
                log.error((Object)errMsg, (Throwable)e);
                throw new RemoteProcessException(errMsg, (Throwable)e);
            }
        }
        return null;
    }

    public void leftOver(Serializable msg, Member member) {
    }
}

