/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.corba.receivers;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.corba.deployer.CorbaConstants;
import org.apache.axis2.corba.exceptions.CorbaInvocationException;
import org.apache.axis2.corba.idl.types.IDL;
import org.apache.axis2.corba.receivers.CorbaUtil;
import org.apache.axis2.corba.receivers.Invoker;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.receivers.AbstractInMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA_2_3.ORB;

public class CorbaInOnlyMessageReceiver
extends AbstractInMessageReceiver
implements CorbaConstants {
    private static Log log = LogFactory.getLog((Class)CorbaInOnlyMessageReceiver.class);
    private ORB orb = null;
    private Map invokerCache = new HashMap();

    public void invokeBusinessLogic(MessageContext inMessage) throws AxisFault {
        try {
            this.invoke(inMessage);
            log.info((java.lang.Object)"org.omg.CORBA.TRANSIENT exception thrown.");
        }
        catch (TRANSIENT e) {
            this.invokerCache.clear();
            this.invoke(inMessage);
        }
    }

    private void invoke(MessageContext inMessage) throws AxisFault {
        String methodName = null;
        try {
            AxisOperation op = inMessage.getOperationContext().getAxisOperation();
            AxisService service = inMessage.getAxisService();
            OMElement methodElement = inMessage.getEnvelope().getBody().getFirstElement();
            AxisMessage inAxisMessage = op.getMessage("In");
            methodName = op.getName().getLocalPart();
            Invoker invoker = (Invoker)this.invokerCache.get(methodName);
            if (invoker == null) {
                if (this.orb == null) {
                    Parameter orbParam = service.getParameter("orb");
                    this.orb = orbParam != null ? (ORB)orbParam.getValue() : CorbaUtil.getORB(service);
                }
                Object obj = CorbaUtil.resolveObject(service, this.orb);
                Parameter idlParameter = service.getParameter("idl");
                if (idlParameter == null) {
                    throw new CorbaInvocationException("No IDL found");
                }
                IDL idl = (IDL)idlParameter.getValue();
                invoker = CorbaUtil.getInvoker(service, obj, idl, methodName);
                this.invokerCache.put(methodName, invoker);
            }
            if (inAxisMessage != null) {
                if (inAxisMessage.getElementQName() != null) {
                    QName elementQName = inAxisMessage.getElementQName();
                    String messageNameSpace = elementQName.getNamespaceURI();
                    OMNamespace namespace = methodElement.getNamespace();
                    if (messageNameSpace != null) {
                        if (namespace == null || !messageNameSpace.equals(namespace.getNamespaceURI())) {
                            throw new AxisFault("namespace mismatch require " + messageNameSpace + " found " + methodElement.getNamespace().getNamespaceURI());
                        }
                    } else if (namespace != null) {
                        throw new AxisFault("namespace mismatch. Axis Oepration expects non-namespace qualified element. But received a namespace qualified element");
                    }
                    java.lang.Object[] objectArray = CorbaUtil.extractParameters(methodElement, invoker.getParameterMembers());
                    invoker.setParameters(objectArray);
                }
                invoker.invoke();
            }
        }
        catch (CorbaInvocationException e) {
            String msg;
            Throwable cause = e.getCause();
            if (cause != null) {
                msg = cause.getMessage();
                if (msg == null) {
                    msg = "Exception occurred while trying to invoke service method " + methodName;
                }
                if (cause instanceof AxisFault) {
                    throw (AxisFault)cause;
                }
            } else {
                msg = e.getMessage();
            }
            throw new AxisFault(msg);
        }
    }
}

