/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.account;

import java.util.ArrayList;
import java.util.List;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.cayenne.om.account.AvzMRole;
import com.aimluck.eip.cayenne.om.account.AvzMUserRole;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;

/**
 * 役割の複数削除を行うためのクラスです。 <BR>
 * 
 */
public class AccountRoleMultiDelete extends ALAbstractCheckList {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(AccountRoleMultiDelete.class.getName());

  /**
   * 役割情報一括削除処理
   * 
   * @param action
   *            アクションクラス
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @param values
   *            役割IDリスト
   * @param msgList
   *            エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * @see com.aimluck.eip.common.ALAbstractCheckList#action(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList,
   *      java.util.ArrayList)
   */
  @Override
  protected boolean action(RunData rundata, Context context,
      List<String> values, List<String> msgList) {

    try {
      List<Integer> ids = new ArrayList<Integer>();
      int size = values.size();
      for (int i = 0; i < size; i++) {
        ids.add(Integer.valueOf(values.get(i)));
      }

      SelectQuery<AvzMRole> query = Database.query(AvzMRole.class);
      Expression exp1 =
        ExpressionFactory.inDbExp(AvzMRole.ROLE_ID_PK_COLUMN, ids);
      query.setQualifier(exp1);

      ResultList<AvzMRole> entities = query.getResultList();
      if (entities == null || entities.size() == 0) {
        return false;
      }

      for (AvzMRole o : entities) {
        List<AvzMUserRole> list = o.getAvzMUserRoleArray();
        if (list != null && list.size() != 0) {
          Database.deleteAll(list);
        }
        Database.delete(o);
      }
      Database.commit();

      // singletonオブジェクトのリフレッシュ
      ALEipManager.getInstance().reloadRole();

    } catch (Exception ex) {
      String msg = "役割情報の一括削除に失敗しました。";
      logger.error(msg, ex);
      msgList.add(msg);
      Database.rollback();
      return false;
    }
    return true;
  }

  // /**
  // * アクセス権限チェック用メソッド。<br />
  // * アクセス権限を返します。
  // *
  // * @return
  // */
  // @Override
  // protected int getDefineAclType() {
  // return ALAccessControlConstants.VALUE_ACL_DELETE;
  // }
  //
  // /**
  // * アクセス権限チェック用メソッド。<br />
  // * アクセス権限の機能名を返します。
  // *
  // * @return
  // */
  // @Override
  // public String getAclPortletFeature() {
  // return null;
  // }
}
