/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipo.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Parameter;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.psml.PsmlParameter;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.schedule.util.OneDayScheduleUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 1日スケジュールの閲覧メンバーを保存し、テンプレートより画面を再描画するクラスです。 <br />
 * 
 */
public class ScheduleOneDayMemberChangeScreen extends ALVelocityScreen {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ScheduleOneDayMemberChangeScreen.class.getName());

  /*
   * @see com.aimluck.eip.modules.screens.ALVelocityScreen#doOutput(RunData
   * rundata, Context context)
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {

    try {

      // ポートレット取得
      VelocityPortlet portlet = ALEipUtils.getPortlet(rundata, context);

      // 遷移元情報を初期化
      ALEipUtils.setTemp(rundata, context, "FROM_PORTLET", "Normal");

      // 画面の閲覧メンバーでpsmlを更新
      String memberUserIdList[] = null;
      String mId = rundata.getParameters().getString("m_id");
      if (mId != null) {
        memberUserIdList = mId.split(",");
      }
      // 誰も選択されなかった場合、ログインユーザーをかえす
      if (memberUserIdList.length == 0) {
        mId = Integer.toString(ALEipUtils.getUserId(rundata));
        memberUserIdList = new String[] { mId };
      }

      // ///////////////////////////////
      // psmlへ設定
      // ///////////////////////////////
      final String KEY_UIDS = "p6a-uids";

      // ポートレット一覧を取得
      Profile profile = ((JetspeedRunData) rundata).getProfile();
      Portlets portlets = profile.getDocument().getPortlets();
      if (portlets == null) {
        return;
      }
      Portlets[] portletsArray = portlets.getPortletsArray();
      if (portletsArray == null) {
        return;
      }

      // ポートレット一覧でループ
      for (Portlets element : portletsArray) {
        Entry[] entries = element.getEntriesArray();
        if (entries == null || entries.length <= 0) {
          continue;
        }

        // ポートレットのエンティティ一覧でループ
        for (Entry entry : entries) {
          if (rundata.getParameters().getString("js_peid", null).equals(entry.getId())) {

            // ////////////////////////////////////////////
            // 該当パラメータがあれば上書き、なければ新規追加する
            // ////////////////////////////////////////////
            Parameter param = null;
            // 選択閲覧メンバー一覧
            param = entry.getParameter(KEY_UIDS);
            if (null != param) {
              param.setValue(mId);
            } else {
              PsmlParameter newParam = new PsmlParameter();
              newParam.setName(KEY_UIDS);
              newParam.setValue(mId);
              entry.addParameter(newParam);
            }
            break;
          }
        }
      }
      profile.store();

      // 画面の基本項目設定
      OneDayScheduleUtils.initBaseField(rundata, context, memberUserIdList);

      // Velocity テンプレートを読み込む
      String template = portlet.getPortletConfig().getInitParameter("template");
      setTemplate(rundata, context, "portlets/html/ja/" + template + ".vm");

    } catch (Exception ex) {
      logger.error("閲覧メンバーの保存に失敗しました。ログインユーザー:" + ALEipUtils.getALEipUser(rundata).getName(), ex);
      ALEipUtils.redirectDBError(rundata);
    }
  }
}
