/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.schedule.ScheduleSelectPrintFormData;

/**
 * 印刷対象者選択画面を処理するクラスです。 <br />
 * 
 */
public class ScheduleSelectPrintFormScreen extends ALVelocityScreen {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ScheduleSelectPrintFormScreen.class.getName());

  /**
   * 印刷対象者選択画面 表示処理
   * 
   * @param rundata
   *          JetSpeedランデータ
   * @param context
   *          JetSpeedコンテキスト
   * @throws Exception
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {

    try {

      String printMode = rundata.getParameters().getString("printMode");
      if (printMode != null && !"".equals(printMode)) {
        context.put("print_mode", printMode);
      }
      // 起動元親画面のポートレットID
      String parentPortId = rundata.getParameters().getString("parentPortId");
      if (parentPortId != null && !"".equals(parentPortId)) {
        context.put("parent_port_id", parentPortId);
      }
      // add start 要件No.5 スケジュール印刷（日単位）
      // 印刷対象日
      String viewStart = rundata.getParameters().getString("view_start");
      if (viewStart != null && !"".equals(viewStart)) {
        context.put("view_start", viewStart);
      }
      // add end

      ScheduleSelectPrintFormData formData = new ScheduleSelectPrintFormData();
      formData.initField();
      formData.doViewForm(this, rundata, context);

      // 画面描画
      String layout_template = "portlets/html/ja/ajax-schedule-select-print.vm";
      setTemplate(rundata, context, layout_template);

    } catch (Exception ex) {
      logger.error("[ScheduleSelectPrintFormScreen] Exception.", ex);
    }

  }

}
