if(!dojo._hasResource["aipo.flash.upload.handlers"]){
dojo._hasResource["aipo.flash.upload.handlers"] = true;
/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

dojo.provide("aipo.flash.upload.handlers");

/* Demo Note:  This demo uses a FileProgress class that handles the UI for displaying the file name and percent complete.
The FileProgress class is not part of SWFUpload.
*/
/* **********************
   Event Handlers
   These are my custom event handlers to make my
   web application behave the way I went when SWFUpload
   completes different tasks.  These aren't part of the SWFUpload
   package.  They are part of my application.  Without these none
   of the actions SWFUpload makes will show up in my application.
   ********************** */
/**
 * アップロード開始
 * @param file アップロードファイル
 */
aipo.flash.upload.fileQueued = function(file) {
    try {
        var messageDiv = dojo.byId('messageDivUpload');
        // メッセージ初期化
        messageDiv.innerHTML = "";
    } catch (ex) {
    }
}

/**
 * ファイルキューエラー
 * @param file アップロードファイル
 * @param errorCode フラッシュからのエラーコード
 * @param message 最大アップロードファイル数
 */
aipo.flash.upload.fileQueueError = function(file, errorCode, message) {
    try {
        // ステータス設定
        var attachment_status = dojo.byId('attachment_status');
        attachment_status.value = "QUEUE_ERROR";

        if (errorCode === SWFUpload.QUEUE_ERROR.QUEUE_LIMIT_EXCEEDED) {
            // 同時アップロード可能数を超えた場合（設定により起こり得ない）
            return;
        }
        var uploadErrMsg = dojo.byId('messageDivUpload');
        uploadErrMsg.style.display = "";

        var errMessageList = dojo.byId('errMessageList');
        var mes = "";

        switch (errorCode) {
        case SWFUpload.QUEUE_ERROR.FILE_EXCEEDS_SIZE_LIMIT:
            mes  = "7MB以上のファイルは追加できません。";
            errMessageList.options[errMessageList.options.length] = new Option(mes, file.name);
            break;
        case SWFUpload.QUEUE_ERROR.ZERO_BYTE_FILE:
            // 0byteファイルのエラー表示の為、ここでクリアする。
            errMessageList.options.length = 0;
            mes  = "サイズが 0KB のファイルを追加することはできません。";
            errMessageList.options[errMessageList.options.length] = new Option(mes, file.name);
            // 0byteファイルが1つだけアップされた場合は、完了処理まで処理されない為、エラーメッセージへ表示する。
            // 尚、0byteファイルが複数存在した場合は、後勝ちで表示する。
            uploadErrMsg.innerHTML = "<span class='caution'>" + "サイズが 0KB のファイルを追加することはできません。ファイル名：[" + file.name + "]</span>";
            break;
        case SWFUpload.QUEUE_ERROR.INVALID_FILETYPE:
            mes  = "ファイルの種類に誤りがあります。";
            errMessageList.options[errMessageList.options.length] = new Option(mes, file.name);
            break;
        default:
            if (file !== null) {
                mes  = "ファイルアップロードにてエラーが発生しました。";
                errMessageList.options[errMessageList.options.length] = new Option(mes, file.name);
            }else{
                mes  = "ファイルアップロードにてエラーが発生しました。";
                errMessageList.options[errMessageList.options.length] = new Option(mes, file.name);
            }
            break;
        }
    } catch (ex) {
    }
}

/**
 * ファイル選択ダイアログクローズ（アップロード開始）
 * @param numFilesSelected アップロードファイル選択数
 * @param numFilesQueued アップロードファイルキュー
 */
aipo.flash.upload.fileDialogComplete = function(numFilesSelected, numFilesQueued) {
    try {
        var attachment_status = dojo.byId('attachment_status');
        // ファイルは選択されているが、サーバまで到達しないエラー（0byteエラー）のみの場合は、
        // 次回の為に、エラーリストをクリアする。
        if ( attachment_status.value == "QUEUE_ERROR" && numFilesSelected > 0 && numFilesQueued == 0 ) {
            var errMessageList = dojo.byId('errMessageList');
            errMessageList.options.length = 0;
        }
        this.startUpload();
    } catch (ex)  {
    }
}

/**
 * アップロード開始
 * @param file アップロードファイル
 */
aipo.flash.upload.uploadStart = function(file) {
    try {
        /* I don't want to do any file validation or anything,  I'll just update the UI and
        return true to indicate that the upload should start.
        It's important to update the UI here because in Linux no uploadProgress events are called. The best
        we can do is say we are uploading.
         */
    }
    catch (ex) {
    }

    return true;
}

/**
 * アップロードプログレス表示
 * @param file アップロードファイル
 * @param bytesLoaded ロードサイズ
 * @param bytesTotal ファイルサイズ
 */
aipo.flash.upload.uploadProgress = function(file, bytesLoaded, bytesTotal) {
}

/**
 * アップロード成功（１ファイル毎）
 * @param file アップロードファイル
 * @param serverData ファイルＩＤ、ファイル名、ディレクトリ名
 */
aipo.flash.upload.uploadSuccess = function(file, serverData) {
}

/**
 * アップロードエラー
 * @param file アップロードファイル
 * @param errorCode エラーコード
 * @param message メッセージ
 */
aipo.flash.upload.uploadError = function(file, errorCode, message) {
    try {
        var errMessageList = dojo.byId('errMessageList');
        var mes = "";

        switch (errorCode) {
        case SWFUpload.UPLOAD_ERROR.HTTP_ERROR:
            mes  = "HTTPエラーが発生しました。" + message;
            errMessageList.options[errMessageList.options.length] = new Option(mes, file.name);
            break;
        case SWFUpload.UPLOAD_ERROR.UPLOAD_FAILED:
            mes  = "アップロードに失敗しました。";
            errMessageList.options[errMessageList.options.length] = new Option(mes, file.name);
            break;
        case SWFUpload.UPLOAD_ERROR.IO_ERROR:
            mes  = "サーバーIOエラーが発生しました。";
            errMessageList.options[errMessageList.options.length] = new Option(mes, file.name);
            break;
        case SWFUpload.UPLOAD_ERROR.SECURITY_ERROR:
            mes  = "セキュリティエラーが発生しました。";
            errMessageList.options[errMessageList.options.length] = new Option(mes, file.name);
            break;
        case SWFUpload.UPLOAD_ERROR.UPLOAD_LIMIT_EXCEEDED:
            mes  = "アップロードサイズの上限に達しました。";
            errMessageList.options[errMessageList.options.length] = new Option(mes, file.name);
            break;
        case SWFUpload.UPLOAD_ERROR.FILE_VALIDATION_FAILED:
            mes  = "バリデートエラーが発生しました。";
            errMessageList.options[errMessageList.options.length] = new Option(mes, file.name);
            break;
        case SWFUpload.UPLOAD_ERROR.FILE_CANCELLED:
            // If there aren't any files left (they were all cancelled) disable the cancel button
/*
            if (this.getStats().files_queued === 0) {
                document.getElementById(this.customSettings.cancelButtonId).disabled = true;
            }
*/
            mes  = "アップロードをキャンセルしました。";
            errMessageList.options[errMessageList.options.length] = new Option(mes, file.name);
            break;
        case SWFUpload.UPLOAD_ERROR.UPLOAD_STOPPED:
            break;
        default:
            mes  = "ファイルアップロードにてエラーが発生しました。エラーコード：" + errorCode;
            errMessageList.options[errMessageList.options.length] = new Option(mes, file.name);
            break;
        }
    } catch (ex) {
    }
}

/**
 * アップロード完了（１ファイル毎）
 * @param file アップロードファイル
 */
aipo.flash.upload.uploadComplete = function(file) {
}

/**
 * アップロード完了（全ファイル）
 * @param numFilesUploaded アップロードファイル数
 */
// This event comes from the Queue Plugin
aipo.flash.upload.queueComplete = function(numFilesUploaded) {
}

}
