package aipo.webservice.mail;

/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

import java.util.List;

import aipo.webservice.soap.axis2.bean.ReceiveMailViewBean;

import com.aimluck.eip.mail.ALMailReceiverContext;
import com.aimluck.eip.mail.db.ALDbPop3MailReceiver;

/**
 * リマインダー用の、データベースを利用したPOP3サーバーのメール受信機能
 * 
 */
public class ReminderDbPop3MailReceiver extends ALDbPop3MailReceiver implements
    ReminderPop3MailReceiver {

  /**
   * コンストラクタ
   * <p>
   * メール受信コンテキストを割り当て、初期化する。<br>
   * 
   * @param rcontext
   *          メール受信コンテキスト
   */
  public ReminderDbPop3MailReceiver(ALMailReceiverContext rcontext) {
    super(rcontext);
  }

  /**
   * 新着メール一覧取得
   * <p>
   * メールサーバーにある新着受信メール情報の一覧を取得する。メールの受信自体は行わない。<br>
   * 
   * @see aipo.webservice.mail.ReminderPop3MailReceiver#
   *      getNewReceiveMailListFromMailServer()
   * @throws Exception
   *           全例外
   */
  @Override
  public List<ReceiveMailViewBean> getNewReceiveMailListFromMailServer()
      throws Exception {
    // 本カスタマイズにおいてDBからのメール取得は考慮しない。
    return null;
  }

}
