package aipo.webservice.util;

/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

import java.util.Calendar;
import java.util.Comparator;

import aipo.webservice.soap.axis2.bean.ReceiveMailViewBean;

/**
 * <HR>
 * 受信メール情報一覧昇順ソートクラス
 * <p>
 * 
 * 受信メール情報一覧の受信時刻昇順による順序付け
 * <P>
 * <HR>
 * <P>
 * 
 */
public class ReceiveMailViewBeanComparatorByTimeAsc implements
    Comparator<ReceiveMailViewBean> {

  /** 作業用カレンダー */
  private final Calendar cal = Calendar.getInstance();

  /**
   * 受信時刻比較。
   * <p>
   * 
   * 受信時刻を比較する。<br>
   * 
   * @param o1
   *          受信メールBeanクラスのインスタンス
   * @param o2
   *          受信メールBeanクラスのインスタンス
   * @see java.util.Comparator#compare(T, T)
   * @return int 数値(0:同一、時間(分)の差)
   */
  public int compare(ReceiveMailViewBean o1, ReceiveMailViewBean o2) {
    // 受信時刻を取得
    String s1 = o1.getReceiveDate() + " " + o1.getReceiveTime();
    cal.setTime(WsUtils.getDateFromYMDHHMI(s1));
    int hour1 = cal.get(Calendar.HOUR_OF_DAY);
    int minute1 = cal.get(Calendar.MINUTE);

    String s2 = o2.getReceiveDate() + " " + o2.getReceiveTime();
    cal.setTime(WsUtils.getDateFromYMDHHMI(s2));
    int hour2 = cal.get(Calendar.HOUR_OF_DAY);
    int minute2 = cal.get(Calendar.MINUTE);

    // 受信時刻で比較
    if (hour1 != hour2) {
      return hour1 - hour2;
    } else if (minute1 != minute2) {
      return minute1 - minute2;
    }

    return 0;
  }

}
