/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.mail.util;

import java.util.ArrayList;
import java.util.List;

/**
 * ユーザーの情報（メールアドレス）を保持するクラスです。 <br />
 * 
 */
public class ALEipUserAddr {

  private Integer userid = null;

  private String pc_mailaddr = null;

  private String cell_mailaddr = null;

  // add start
  /** ログイン名 */
  private String login_name = null;

  /** 姓 */
  private String last_name = null;

  /** 名 */
  private String first_name = null;

  /** 表示名 */
  private String display_name = null;

  // add end

  public ALEipUserAddr() {

  }

  public void setUserId(Integer userid) {
    this.userid = Integer.valueOf(userid.intValue());
  }

  public Integer getUserId() {
    return userid;
  }

  public void setPcMailAddr(String pc_mailaddr) {
    if (pc_mailaddr == null) {
      return;
    }
    this.pc_mailaddr = pc_mailaddr;
  }

  public String getPcMailAddr() {
    return pc_mailaddr;
  }

  public void setCellMailAddr(String cell_mailaddr) {
    if (cell_mailaddr == null) {
      return;
    }
    this.cell_mailaddr = cell_mailaddr;
  }

  public String getCellMailAddr() {
    return cell_mailaddr;
  }

  public String[] getAddrs() {
    List<String> list = new ArrayList<String>();

    if (pc_mailaddr != null && !"".equals(pc_mailaddr)) {
      list.add(pc_mailaddr);
    }

    if (cell_mailaddr != null && !"".equals(cell_mailaddr)) {
      list.add(cell_mailaddr);
    }

    int size = list.size();
    if (size == 0) {
      return null;
    }

    String[] addrs = new String[size];
    for (int i = 0; i < size; i++) {
      addrs[i] = list.get(i);
    }
    return addrs;
  }

  // add start
  /**
   * ログイン名を設定します。
   * 
   * @param value
   *            ログイン名
   */
  public void setLoginName(String value) {
    login_name = value;
  }

  public String getLoginName() {
    return login_name;
  }

  /**
   * 姓を設定します。
   * 
   * @param value
   *            姓
   */
  public void setLastName(String value) {
    last_name = value;
  }

  /**
   * 姓を返します。
   * 
   * @return 姓
   */
  public String getLastName() {
    return last_name;
  }

  /**
   * 名を設定します。
   * 
   * @param value
   *            名
   */
  public void setFirstName(String value) {
    first_name = value;
  }

  /**
   * 名を返します。
   * 
   * @return 名
   */
  public String getFirstName() {
    return first_name;
  }

  /**
   * 姓名を返します。
   * 
   * @return 姓名
   */
  public String getAliasName() {
    return last_name + " " + first_name;
  }

  /**
   * 表示名を設定します。
   * 
   * @param value
   *            表示名
   */
  public void setDisplayName(String value) {
    if (value != null) {
      display_name = value.trim();
    }
  }

  /**
   * 表示名を返します。
   * 
   * @return 表示名
   */
  public String getDisplayName() {
    return display_name;
  }

  /**
   * 表示名付きのメールアドレスを返します。
   * 
   * @return 表示名付きのメールアドレス "表示名<aaa@aaaa.com>"
   */
  public String getPcMailAddrWithName() {
    return display_name + "<" + pc_mailaddr + ">";
  }

  // add end
}
