/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipo.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.actions.schedule;

import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.schedule.ScheduleConst;
import com.aimluck.eip.schedule.util.OneDayScheduleUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 1日スケジュールの初期表示処理
 */
public class OneDayScheduleAction extends ALBaseAction {

  /**
   * logger
   */
  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(OneDayScheduleAction.class.getName());

  /** 最大化表示フラグ */
  private boolean isMaximizedContext = false;

  /*
   * @see
   * com.aimluck.eip.modules.actions.common.ALBaseAction#buildNormalContext(
   * VelocityPortlet portlet, Context context, RunData rundata)
   */
  @Override
  protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) {

    // セッション情報をクリアする
    clearSession(rundata, context);

    try {

      // 初期閲覧メンバーのユーザーIDリストを取得する
      String[] memberUserIdList = null;

      // 月スケジュールユーザーIDを取得
      String monthlyUserId = rundata.getParameters().getString("monthlyUserId");
      if (monthlyUserId == null || "".equals(monthlyUserId)) {
        try {
          // 月スケジュールユーザーIDが無い場合は、psmlに保持した閲覧メンバーから生成する
          String selectedUser = portlet.getPortletConfig().getInitParameter("p6a-uids");
          if (selectedUser == null || "".equals(selectedUser)) {
            // 閲覧メンバーが無い場合は、ログインユーザーを設定する
            memberUserIdList = new String[] { Integer.toString(ALEipUtils.getUserId(rundata)) };
          } else {
            String[] selectedUsers = selectedUser.split(",");
            if (selectedUsers.length == 0) {
              // 閲覧メンバーが0件の場合、ログインユーザーを設定する
              memberUserIdList = new String[] { Integer.toString(ALEipUtils.getUserId(rundata)) };
            } else {
              // 閲覧メンバーが存在する場合は、閲覧メンバーを設定する
              memberUserIdList = selectedUsers;
            }
          }
          // 遷移元情報「通常遷移」をセッションに保持する
          ALEipUtils.setTemp(rundata, context, "FROM_PORTLET", "Normal");
        } catch (Exception e) {
          logger.error("１日スケジュール画面初期表示にて、ユーザー情報の取得に失敗しました。ログインユーザー:" + ALEipUtils.getALEipUser(rundata).getName(), e);
        }
      } else {
        // 月スケジュールユーザーIDが存在する場合「月間スケジュールから直接遷移」とする
        // 月スケジュールユーザーIDを閲覧メンバーに設定する
        memberUserIdList = new String[] { monthlyUserId };
        // 月スケジュールのタブIDを取得する
        Portlets portlets = ((JetspeedRunData) rundata).getProfile().getDocument().getPortlets();
        for (Portlets p : portlets.getPortletsArray()) {
          if (ScheduleConst.PORTLET_NAME_MONTHLY_SCHEDULE.equals(p.getTitle())) {
            context.put("monthlySchedulePaneId", p.getId());
            break;
          }
        }
        // 遷移元情報をセッションに保持する
        ALEipUtils.setTemp(rundata, context, "FROM_PORTLET", "FromMonthly");
      }

      // 表示基準日を取得
      String pTargetDate = rundata.getParameters().getString("targetDate");
      if (pTargetDate != null && !"".equals(pTargetDate)) {
        context.put("targetDate", pTargetDate);
      }

      // 画面の基本項目設定
      OneDayScheduleUtils.initBaseField(rundata, context, memberUserIdList);

      // Velocity テンプレートを読み込む
      String template = "";
      if (isMaximizedContext) {
        // 最大表示時
        this.putData(rundata, context);
        template = portlet.getPortletConfig().getInitParameter("maxTemplate");
      } else {
        // 通常表示時
        template = portlet.getPortletConfig().getInitParameter("template");
      }
      setTemplate(rundata, template);

    } catch (Exception ex) {
      logger.error("１日スケジュールの表示に失敗しました。ログインユーザー:" + ALEipUtils.getALEipUser(rundata).getName(), ex);
      ALEipUtils.redirectDBError(rundata);
    }

  }

  /*
   * @see
   * com.aimluck.eip.modules.actions.common.ALBaseAction#buildMaximizedContext
   * (VelocityPortlet portlet, Context context, RunData rundata)
   */
  @Override
  protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
    isMaximizedContext = true;
    buildNormalContext(portlet, context, rundata);
  }

  /**
   * スケジュールを一覧表示します。
   * 
   * @param rundata
   *          実行データ
   * @param context
   *          Velocityコンテキスト
   */
  public void doSchedule_list(RunData rundata, Context context) {
    isMaximizedContext = true;

  }

  /**
   * セッション情報を初期化する
   * 
   * @param rundata
   *          実行データ
   * @param context
   *          Velocityコンテキスト
   */
  private void clearSession(RunData rundata, Context context) {
    ALEipUtils.removeTemp(rundata, context, "entityid");
  }
}
