/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.schedule;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import com.aimluck.eip.common.ALData;

/**
 * 月間スケジュールコンテナを取得します。
 * 
 */
public class ScheduleMonthContainer implements ALData {

  /** <code>weekList</code> 週間スケジュールリスト */
  private List<ScheduleWeekContainer> weekList;

  // add start 要件No.6 スケジュール画面（月単位）
  /** <code>dayOfWeekList</code> 曜日表示文字列リスト */
  private List<String> dayOfWeekList;

  // add end

  /**
   * 初期設定。
   */
  public void initField() {
    weekList = new ArrayList<ScheduleWeekContainer>();

    // add start 要件No.6 スケジュール画面（月単位）
    dayOfWeekList = new ArrayList<String>(7);
    // add end
  }

  /**
   * 表示する月を設定します。
   * 
   * @param cal
   */
  public void setViewMonth(Calendar cal, Calendar vcal) {
    for (int i = 1; i <= 6; i++) {
      if ((i == 5 || i == 6) && (cal.get(Calendar.MONTH) != vcal.get(Calendar.MONTH))) {
        break;
      }
      // 日付を7日ずつずらす
      ScheduleWeekContainer con = new ScheduleWeekContainer();
      con.initField();
      con.setViewStartDate(cal);
      weekList.add(con);
      // cal.add(Calendar.DATE, 7);

      // add start 要件No.6 スケジュール画面（月単位）
      if (i == 1) {
        List<ScheduleDayContainer> dayCon = con.getDayList();
        for (ScheduleDayContainer dc : dayCon) {
          String s = dc.getDate().getDayOfWeek().substring(1, 2);
          dayOfWeekList.add(s);
        }
      }
      // add end
    }
  }

  /**
   * スケジュールを追加します。
   * 
   * @param rd
   */
  public boolean addResultData(ScheduleResultData rd) {
    int size = weekList.size();
    for (int i = 0; i < size; i++) {
      ScheduleWeekContainer con = weekList.get(i);
      if (con.addResultData(rd)) {
        return true;
      }
    }
    return false;
  }

  /**
   * 週間スケジュールリストを取得します。
   * 
   * @return
   */
  public List<ScheduleWeekContainer> getWeekList() {
    return weekList;
  }

  // add start 要件No.6 スケジュール画面（月単位）
  /**
   * 曜日文字列リストを取得します。
   * 
   * @return 曜日文字列リスト
   */
  public List<String> getDayOfWeekList() {
    return dayOfWeekList;
  }
  // add end

}
