/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

dojo.provide("aipo.webmail");

/**
 * メール作成画面表示時処理
 *
 * @param portlet_id ポートレットID
 */
aipo.webmail.onLoadMailDialog = function(portlet_id){

    var obj = dojo.byId("to");
    if(obj){
       obj.focus();
    }

}

/**
 * 署名・代理人設定画面表示時処理
 *
 * @param portlet_id ポートレットID
 */
aipo.webmail.onLoadMailAccountDialog = function(portlet_id){

  // change start
  //var obj = dojo.byId("account_name");
  //if(obj){
  //   obj.focus();
  //}
  var obj = dojo.byId("signature");
  if(obj){
     obj.focus();
  }
  // change end

  //add by motegi start
  //代理送信設定グループ送信
  var gspicker = dijit.byId("groupsendnormalselect");
  if(gspicker){
    var select = dojo.byId('init_groupsendlist');
    var i;
    var s_o = select.options;
    if (s_o.length == 1 && s_o[0].value == "") return;

    for(i = 0 ; i < s_o.length; i ++ ) {
      gspicker.addOptionSync(s_o[i].value,s_o[i].text,true);
    }
  }

  //代理受信設定メンバー
  var pmpicker = dijit.byId("memberreceivenormalselect");
  if(pmpicker){
    var select = dojo.byId('init_receive_memberlist');
    var i;
    var s_o = select.options;
    if (s_o.length == 1 && s_o[0].value == "") return;
    for(i = 0 ; i < s_o.length; i ++ ) {
      pmpicker.addOptionSync(s_o[i].value,s_o[i].text,true);
    }
  }

  //代理送信設定メンバー
  var smpicker = dijit.byId("membersendnormalselect");
  if(smpicker){
    var select = dojo.byId('init_send_memberlist');
    var i;
    var s_o = select.options;
    if (s_o.length == 1 && s_o[0].value == "") return;
    for(i = 0 ; i < s_o.length; i ++ ) {
      smpicker.addOptionSync(s_o[i].value,s_o[i].text,true);
    }
  }
  //add end

}

/**
 * フォルダ作成編集画面表示時処理
 *
 * @param portlet_id ポートレットID
 */
aipo.webmail.onLoadMailFolderDialog = function(portlet_id){

  var obj = dojo.byId("folder_name");
  if(obj){
     obj.focus();
  }
}

/**
 * フィルター作成編集画面表示時処理
 *
 * @param portlet_id ポートレットID
 */
aipo.webmail.onLoadMailFilterDialog = function(portlet_id){

  var obj = dojo.byId("filter_name");
  if(obj){
     obj.focus();
  }
}

/**
 * 結果メッセージ表示処理（移動/未読/一括処理キャンセル/一括ダウンロード/退避メール再読込コールバック処理）
 * 正常終了時、Aipo標準のポートレット読み込みを実行
 *
 * @param msg Aipoからのメッセージ（正常ならNULL）
 */
aipo.webmail.onReceiveMessage = function(msg){
    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(arrDialog){
            arrDialog.hide();
        }
        aipo.portletReload('webmail');
    }
    if (dojo.byId('messageDiv')) {
        dojo.byId('messageDiv').innerHTML = msg;
    }
}

/**
 * ポップアップクローズ処理処理
 */
aipo.webmail.hideDialog = function() {
    var arrDialog = dijit.byId("modalDialog");
    if(arrDialog){
       arrDialog.hide();
    }
    aipo.portletReload('webmail');
};


/**
 * フォルダ削除
 * @param button 押下したボタン
 * @param url 処理実行URL
 * @param indicator_id インジケーターID
 * @param portlet_id ポートレットID
 * @param receive コールバック変数
 */
aipo.webmail.ajaxDeleteSubmit = function(button, url, indicator_id, portlet_id, receive) {
    if(confirm('この'+button.form._name.value+'を削除してよろしいですか？なお、フォルダに含まれるメールはすべて削除されます。\nまた、このフォルダを振り分け先として指定してあるフィルタは、振り分け先がデフォルト（フォルダリストの一番上のフォルダ）に変更されます。')) {
        aimluck.io.disableForm(button.form, true);
        aimluck.io.setHiddenValue(button);
        button.form.action = url;
        aimluck.io.submit(button.form, indicator_id, portlet_id, receive);
    }
}

/** タイマーID */
var mailReceviingTimerId;

/**
 * メインプロセスタイマー設定
 */
aipo.webmail.onProcessingTimer = function(){

  if(mailReceviingTimerId){
    clearTimeout(mailReceviingTimerId);
  }
  // change start
  //mailReceviingTimerId = setTimeout("aipo.webmail.reloadMail()",10000);
  // メール受信後の再表示間隔を5秒に短縮
  mailReceviingTimerId = setTimeout("aipo.webmail.reloadMail()",5000);
  // change end
}

/**
 * メール一覧読み込み（同期）※未読数等の更新
 * @param portletId ポートレットID
 */
aipo.webmail.reloadMailList = function(portletId){
  if( typeof ptConfig[portletId].reloadUrl != "undefined") {
    ptConfig[portletId].reloadUrl += '&updateunread=1';
  }
  aipo.reloadPage(portletId);
}

// add start

/**
 * 読み込みメッセージ表示
 */
aipo.webmail.viewLoadMessage = function(){
    var obj = dojo.byId('attentionMessage');
    if( obj ) {
      obj.innerHTML = "メールサーバーへ問い合わせを行います。";
    }
}

/**
 * 検索中フラグ
 * 検索中：1、検索終了：0
 */
var mailSearchFlag = 0;

/**
 * 描画終了処理
 */
aipo.webmail.finishWebMailDrawing = function() {
    // 運用課題No.84
    // 検索終了時、検索ボタンを押下可にする
    if(mailSearchFlag == 1){
        var mailSearchButton = document.getElementsByName("mailSearch").item(0);
        mailSearchButton.disabled = false;
        var searchCondition = dojo.byId("searchCondition");
        searchCondition.style.display = "none";
        searchCondition.innerHTML = "";
        mailSearchFlag = 0;
    }
    // メール受信処理中の場合、メール受信タイマーを設定する
    var screenUrl = dojo.byId("receiving");
    if(screenUrl){
        aipo.webmail.onProcessingTimer();
    }
}

/**
 * Webメールポートレット用viewPage
 * 初期描画フラグを設定しつつページ非同期読込を実施する。
 * @param url 読み込み先ページURL
 * @param portletId 読み込み先ポートレットID
 * @param params 読み込み先ページ用リクエストパラメータ
 */
aipo.webmail.viewPage = function(url, portletId, params) {

    var portlet = dijit.byId('portlet_' + portletId);
    if(! portlet){
      portlet = new aimluck.widget.Contentpane({},'portlet_' + portletId);
    }

    if(portlet){
      ptConfig[portletId].reloadUrl= url;

      // 読み込み終了後に描画終了処理を実行する
      portlet.onLoad = aipo.webmail.finishWebMailDrawing;

      if(params){
        for(i = 0 ; i < params.length; i++ ) {
         portlet.setParam(params[i][0], params[i][1]);
        }
      }

      portlet.viewPage(url);
    }
};
//add end

/**
 * メール一覧読み込み（非同期）
 * メインプロセスタイマー設定を実行する。
 * @param portletId ポートレットID
 */
aipo.webmail.reloadMail = function(){
  var screenUrl = dojo.byId("receiving");
  if(screenUrl){
    var tmp_reload_url = screenUrl.value;

    var page_start = dojo.byId("page_start");

    if(page_start){
      tmp_reload_url += '&start=' + page_start.value;
    }
    tmp_reload_url += '&updateunread=1';

    var receivingPid = dojo.byId("receivingPid");
    // change start
    // aipo.viewPage(tmp_reload_url, receivingPid.value);
    aipo.webmail.viewPage(tmp_reload_url, receivingPid.value);
    // aipo.webmail.onProcessingTimer();
    // change end
  }
}

/**
 * ヘルプ表示
 * @param url ヘルプURL
 */
aipo.webmail.open_help = function(url){
    wx = 400;
    wy = 232;
    x = (screen.width  - wx) / 2;
    y = (screen.height - wy) / 2;

    help_subwin = window.open(url, "help_window","left="+x+",top="+y+",width="+wx+",height="+wy+",resizable=no");
    help_subwin.opener = self;
    help_subwin.focus();
}

/**
 * メールヘッダーの表示切替
 * @param button 押下したボタン
 */
aipo.webmail.switchHeader = function(button) {
    if(button.form.is_header_tiny.value == 'TRUE' || button.form.is_header_tiny.value == 'true') {
        //簡易表示の際に「詳細表示」ボタンを押した→詳細部分をonにして簡易部分をoffにする 。詳細表示になったのでis_header_tinyがfalse
        button.value = '簡易表示';
        aipo.webmail.switchHeaderDetail(button.form);
    } else {
        //詳細表示の際に「簡易表示」ボタンを押した→簡易部分をonにして詳細部分をoffにする
        button.value = '詳細表示';
        aipo.webmail.switchHeaderTiny(button.form);
    }
}

/**
 * メールヘッダー簡易表示
 * @param form 対象フォーム
 */
aipo.webmail.switchHeaderTiny = function(form) {
    dojo.byId('WebMailHeaderFieldTiny').style.display = "";
    dojo.byId('WebMailHeaderFieldDetail').style.display = "none";
    form.is_header_tiny.value = 'TRUE';
}

/**
 * メールヘッダー詳細表示
 * @param form 対象フォーム
 */
aipo.webmail.switchHeaderDetail = function(form) {
    dojo.byId('WebMailHeaderFieldTiny').style.display = "none";
    dojo.byId('WebMailHeaderFieldDetail').style.display = "";
    form.is_header_tiny.value = 'FALSE';
}

/**
 * （現在未使用）
 */
aipo.webmail.doDeleteAccount = function(url,p_id) {
    if(confirm("このメールアカウントを削除してもよろしいですか？\n保存されているメールはすべて削除されます。")) {
        aipo.viewPage(url,p_id);
    }
}

/**
 * （現在未使用）
 */
aipo.webmail.doDeleteFilter = function(url,p_id) {
    if(confirm("このフィルタを削除してもよろしいですか？")) {
        aipo.viewPage(url,p_id);
    }
}

/**
 * （現在未使用）
 */
aipo.webmail.AccountChange = function(form,url,p_id){
    var exec_url = url;
    var r = form.account_type;
    for (i=0;i < r.length;i++){
        if(r[i].checked){
            var check_id = r[i].value;
        }
    }
    exec_url += '&account_type=' + check_id;
    aipo.viewPage(exec_url, p_id);
}

/**
 * 結果メッセージ表示処理（メールアカウント管理更新コールバック）
 *
 * @param msg 結果メッセージ（正常ならNULL）
 */
aipo.webmail.onReceiveMessageAdmin = function(msg){
    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(arrDialog){
            arrDialog.hide();
        }
        aipo.portletReload('webmailadmin');
    }
    if (dojo.byId('messageDiv')) {
        dojo.byId('messageDiv').innerHTML = msg;
    }
}

/**
 * 結果メッセージ表示処理（メールアカウント管理削除コールバック）
 *
 * @param msg 結果メッセージ（正常ならNULL）
 */
aipo.webmail.onDeleteAdminAccount = function(msg){
    if(!msg) {
        aipo.portletReload('webmailadmin');
    }
    if (dojo.byId('messageDiv')) {
        dojo.byId('messageDiv').innerHTML = msg;
    }
}

/**
 * 結果メッセージ表示処理（メールアカウント管理閉じるコールバック）
 */
aipo.webmail.hideDialogAdmin = function() {
    var arrDialog = dijit.byId("modalDialog");
    if(arrDialog){
       arrDialog.hide();
    }
    aipo.portletReload('webmailadmin');
};

/**
 * （現在未使用）
 */
aipo.webmail.switchDelAtPop3 = function(check) {
  if(check.value == 0) {
    dojo.byId('del_at_pop3_flg_on_field').style.display = "";
  } else {
    dojo.byId('del_at_pop3_flg_on_field').style.display = "none";
  }
}

/**
 * メールアカウント管理認証方式変更
 *
 * @param check 対象ラジオボタン
 */
aipo.webmail.switchAuthSendAdmin = function(check) {
  if(check.value == 2) {
    dojo.byId('smtp_auth_field').style.display = "";
    dojo.byId('pop_auth_field').style.display  = "none";
  } else if(check.value == 1) {
    dojo.byId('smtp_auth_field').style.display = "none";
    dojo.byId('pop_auth_field').style.display  = "";
  } else {
    dojo.byId('smtp_auth_field').style.display = "none";
    dojo.byId('pop_auth_field').style.display  = "none";
  }
}

/**
 * （現在未使用）
 */
aipo.webmail.switchAuthSend = function(check) {
  if(check.value == 2) {
    dojo.byId('smtp_auth_field').style.display = "";
  } else {
    dojo.byId('smtp_auth_field').style.display = "none";
  }
}

/**
 * メール送信アドレス帳ダイアログ表示
 *
 * @param url 実行処理URL
 * @param portlet_id プロジェクトID
 * @param callback コールバック変数
 */
aipo.webmail.showAddressbookDialog = function(url, portlet_id, callback) {
    var arrDialog = dijit.byId("addressbookDialog");

    if(! arrDialog){
       arrDialog = new aipo.webmail.widget.AddressbookDialog({widgetId:'addressbookDialog', _portlet_id: portlet_id, _callback:callback}, "addressbookDialog");
    }else{
       arrDialog.setCallback(portlet_id, callback);
    }

    if(arrDialog){
      // add start 要件No.11 メール作成／詳細（ファイル添付）
      dojo.byId('uploadButton').style.display = "none";
      // add end
      arrDialog.setHref(url);
      arrDialog.show();
    }
}

/**
 * メールアドレス帳表示時にメール作成画面の内容を反映する
 *
 * @param portlet_id ポートレットID
 */
aipo.webmail.onLoadAddressbookDialog = function(portlet_id){
    var url_userlist = dojo.byId('urlUserlist'+portlet_id).value;
    //aipo.webmail.changeInternalGroup(url_userlist, 'LoginUser');
    aipo.webmail.changeInternalGroup(url_userlist, dojo.byId('group').value);


    var url_addrlist = dojo.byId('urlAddrlist'+portlet_id).value;
    //aipo.webmail.changeExternalGroup(url_addrlist, '');
    aipo.webmail.changeExternalGroup(url_addrlist, '0');

    /*
    aimluck.io.removeAllOptions(dojo.byId('detail_to_recipients'));
    aimluck.io.removeAllOptions(dojo.byId('detail_cc_recipients'));
    aimluck.io.removeAllOptions(dojo.byId('detail_bcc_recipients'));
    */

    //remove by motegi start
    //aipo.webmail.getDataSub(dojo.byId('detail_to_recipients'), dojo.byId('to').value);
    //aipo.webmail.getDataSub(dojo.byId('detail_cc_recipients'), dojo.byId('cc').value);
    //aipo.webmail.getDataSub(dojo.byId('detail_bcc_recipients'), dojo.byId('bcc').value);
    //remove by motegi end

    // add start

    //個人アドレス設定
    /* remove 運用障害9 2012.4.25
    aipo.webmail.getDataSubNormalAddress(dojo.byId('detail_to_recipients'), dojo.byId('toExt').value);
    aipo.webmail.getDataSubNormalAddress(dojo.byId('detail_to_extaddress'), dojo.byId('toExt').value);
    aipo.webmail.getDataSubNormalAddress(dojo.byId('detail_cc_recipients'), dojo.byId('ccExt').value);
    aipo.webmail.getDataSubNormalAddress(dojo.byId('detail_cc_extaddress'), dojo.byId('ccExt').value);
    aipo.webmail.getDataSubNormalAddress(dojo.byId('detail_bcc_recipients'), dojo.byId('bccExt').value);
    aipo.webmail.getDataSubNormalAddress(dojo.byId('detail_bcc_extaddress'), dojo.byId('bccExt').value);
    */

    //社内アドレス設定
    /* remove 運用障害9 2012.4.25
    aipo.webmail.getDataSubNormalAddress(dojo.byId('detail_to_recipients'), dojo.byId('toCorp').value);
    aipo.webmail.getDataSubNormalAddress(dojo.byId('detail_to_corpaddress'), dojo.byId('toCorp').value);
    aipo.webmail.getDataSubNormalAddress(dojo.byId('detail_cc_recipients'), dojo.byId('ccCorp').value);
    aipo.webmail.getDataSubNormalAddress(dojo.byId('detail_cc_corpaddress'), dojo.byId('ccCorp').value);
    aipo.webmail.getDataSubNormalAddress(dojo.byId('detail_bcc_recipients'), dojo.byId('bccCorp').value);
    aipo.webmail.getDataSubNormalAddress(dojo.byId('detail_bcc_corpaddress'), dojo.byId('bccCorp').value);
    */

    //グループ送信設定
    /* remove 運用障害9 2012.4.25
    aipo.webmail.getDataSubGroupSend(dojo.byId('detail_to_recipients'), dojo.byId('toGroupsend').value);
    aipo.webmail.getDataSub(dojo.byId('detail_to_groupsends'), dojo.byId('toGroupsend').value);
    aipo.webmail.getDataSubGroupSend(dojo.byId('detail_cc_recipients'), dojo.byId('ccGroupsend').value);
    aipo.webmail.getDataSub(dojo.byId('detail_cc_groupsends'), dojo.byId('ccGroupsend').value);
    aipo.webmail.getDataSubGroupSend(dojo.byId('detail_bcc_recipients'), dojo.byId('bccGroupsend').value);
    aipo.webmail.getDataSub(dojo.byId('detail_bcc_groupsends'), dojo.byId('bccGroupsend').value);
    */
    // add start 運用障害9 2012.4.25
    aipo.webmail.getDataSubNormalAddress(dojo.byId('detail_to_recipients'), dojo.byId('toGroupsend').value);
    aipo.webmail.getDataSubNormalAddress(dojo.byId('detail_to_groupsends'), dojo.byId('toGroupsend').value);
    aipo.webmail.getDataSubNormalAddress(dojo.byId('detail_cc_recipients'), dojo.byId('ccGroupsend').value);
    aipo.webmail.getDataSubNormalAddress(dojo.byId('detail_cc_groupsends'), dojo.byId('ccGroupsend').value);
    aipo.webmail.getDataSubNormalAddress(dojo.byId('detail_bcc_recipients'), dojo.byId('bccGroupsend').value);
    aipo.webmail.getDataSubNormalAddress(dojo.byId('detail_bcc_groupsends'), dojo.byId('bccGroupsend').value);


    // add end
}

/* remove 運用障害9 2012.4.25
aipo.webmail.getDataSub = function(select, recipients){
    if(recipients == null || recipients.length == 0) return;

    var recipient_list = recipients.split('\r\n');
    for(i = 0 ; i < recipient_list.length; i++ ) {
        add_option(select, aipo.webmail.trim(recipient_list[i]), aipo.webmail.trim(recipient_list[i]), false);
    }
}
*/

// add start
/* remove 運用障害9 2012.4.25
aipo.webmail.getDataSubGroupSend = function(select, recipients){
    if(recipients == null || recipients.length == 0) return;

    var recipient_list = recipients.split('\r\n');
    for(i = 0 ; i < recipient_list.length; i++ ) {
        //alert(recipient_list[i]);
        //add_option(select, aipo.webmail.trim(recipient_list[i]), aipo.webmail.trim(recipient_list[i].split(" ")[1]), false);
        add_option(select, aipo.webmail.trim(recipient_list[i]), aipo.webmail.trim(recipient_list[i].split(" ")[2]), false);
    }
}
*/

/**
 * 選択メールアドレス反映
 *
 * @param select 反映先
 * @param recipients 反映元
 */
aipo.webmail.getDataSubNormalAddress = function(select, recipients){
    if(recipients == null || recipients.length == 0) return;

    var recipient_list = recipients.split('\r\n');
    for(i = 0 ; i < recipient_list.length; i++ ) {
        //alert(aipo.webmail.trimAddress(recipient_list[i].split(" ")[2]))
        //add_option(select, aipo.webmail.trim(recipient_list[i]), aipo.webmail.trimAddress(recipient_list[i].split(" ")[2]), false);
        add_option(select, aipo.webmail.trim(recipient_list[i]), aipo.webmail.trimAddress(recipient_list[i]), false);
    }
}
// add end

/**
 * メールアドレス帳の内容をメール作成画面に反映する
 */
aipo.webmail.insertData = function(){
    // add start
    //TO
    var to_list = dojo.byId('detail_to_recipients').options;
    var to_groupsend_list = dojo.byId('detail_to_groupsends').options;
    /* remove 運用障害9 2012.4.25
    var to_corpaddress_list = dojo.byId('detail_to_corpaddress').options;
    var to_extaddress_list = dojo.byId('detail_to_extaddress').options;
    */

    var to_grounpsends = aipo.webmail.makeGroupsends(to_list, to_groupsend_list);
    // remove start 運用障害9 2012.4.25
    //var to = aipo.webmail.makeRecipients(to_list, to_grounpsends);
    //var to_grounpsend_names = aipo.webmail.makeGroupsendNames(to_grounpsends);
    // remove end
    var to_grounpsend_names = aipo.webmail.makeNormalAddressNames(to_grounpsends);

    /* remove 運用障害9 2012.4.25
    var to_corpaddresses = aipo.webmail.makeGroupsends(to_list, to_corpaddress_list);
    var to_corpaddress_names = aipo.webmail.makeNormalAddressNames(to_corpaddresses);
   */

    /* remove 運用障害9 2012.4.25
    var to_extaddresses = aipo.webmail.makeGroupsends(to_list, to_extaddress_list);
    var to_extaddress_names = aipo.webmail.makeNormalAddressNames(to_extaddresses);
    */

    //CC
    var cc_list = dojo.byId('detail_cc_recipients').options;
    var cc_groupsend_list = dojo.byId('detail_cc_groupsends').options;
    /* remove 運用障害9 2012.4.25
    var cc_corpaddress_list = dojo.byId('detail_cc_corpaddress').options;
    var cc_extaddress_list = dojo.byId('detail_cc_extaddress').options;
    */

    var cc_grounpsends = aipo.webmail.makeGroupsends(cc_list, cc_groupsend_list);
    // remove start 運用障害9 2012.4.25
    //var cc = aipo.webmail.makeRecipients(cc_list, cc_grounpsends);
    //var cc_grounpsend_names = aipo.webmail.makeGroupsendNames(cc_grounpsends);
    // remove end
    var cc_grounpsend_names = aipo.webmail.makeNormalAddressNames(cc_grounpsends);

    /* remove 運用障害9 2012.4.25
    var cc_corpaddresses = aipo.webmail.makeGroupsends(cc_list, cc_corpaddress_list);
    var cc_corpaddress_names = aipo.webmail.makeNormalAddressNames(cc_corpaddresses);

    var cc_extaddresses = aipo.webmail.makeGroupsends(cc_list, cc_extaddress_list);
    var cc_extaddress_names = aipo.webmail.makeNormalAddressNames(cc_extaddresses);
    */

    //BCC
    var bcc_list = dojo.byId('detail_bcc_recipients').options;
    var bcc_groupsend_list = dojo.byId('detail_bcc_groupsends').options;
    /* remove 運用障害9 2012.4.25
    var bcc_corpaddress_list = dojo.byId('detail_bcc_corpaddress').options;
    var bcc_extaddress_list = dojo.byId('detail_bcc_extaddress').options;
    */

    var bcc_grounpsends = aipo.webmail.makeGroupsends(bcc_list, bcc_groupsend_list);
    // remove start 運用障害9 2012.4.25
    //var bcc = aipo.webmail.makeRecipients(bcc_list, bcc_grounpsends);
    //var bcc_grounpsend_names = aipo.webmail.makeGroupsendNames(bcc_grounpsends);
    // remove end
    var bcc_grounpsend_names = aipo.webmail.makeNormalAddressNames(bcc_grounpsends);

    /* remove 運用障害9 2012.4.25
    var bcc_corpaddresses = aipo.webmail.makeGroupsends(bcc_list, bcc_corpaddress_list);
    var bcc_corpaddress_names = aipo.webmail.makeNormalAddressNames(bcc_corpaddresses);

    var bcc_extaddresses = aipo.webmail.makeGroupsends(bcc_list, bcc_extaddress_list);
    var bcc_extaddress_names = aipo.webmail.makeNormalAddressNames(bcc_extaddresses);
    */
    // add end

    // change start
    //dojo.byId('to').value = aipo.webmail.getStringLine(dojo.byId('detail_to_recipients').options);
    //dojo.byId('cc').value = aipo.webmail.getStringLine(dojo.byId('detail_cc_recipients').options);
    //dojo.byId('bcc').value = aipo.webmail.getStringLine(dojo.byId('detail_bcc_recipients').options);

    //dojo.byId('to').value = aipo.webmail.getStringLine(to);
    //dojo.byId('toGroupsendName').value = aipo.webmail.joinNames(to_grounpsend_names, to_corpaddress_names, to_extaddress_names);
    // change start 運用障害9 2012.4.25
    //dojo.byId('toGroupsendName').value = aipo.webmail.joinNames(to_extaddress_names, to_corpaddress_names, to_grounpsend_names );
    dojo.byId('toGroupsendName').value = to_grounpsend_names;
    // change end
    dojo.byId('toGroupsend').value = aipo.webmail.getStringLine(to_grounpsends);
    /* remove 運用障害9 2012.4.25
    dojo.byId('toCorp').value = aipo.webmail.getStringLine(to_corpaddresses);
    dojo.byId('toExt').value = aipo.webmail.getStringLine(to_extaddresses);
    */

    //dojo.byId('cc').value = aipo.webmail.getStringLine(cc);
    //dojo.byId('ccGroupsendName').value = cc_grounpsend_names;
    //dojo.byId('ccGroupsendName').value = aipo.webmail.joinNames(cc_grounpsend_names, cc_corpaddress_names, cc_extaddress_names);
    // change start 運用障害9 2012.4.25
    //dojo.byId('ccGroupsendName').value = aipo.webmail.joinNames(cc_extaddress_names, cc_corpaddress_names, cc_grounpsend_names);
    dojo.byId('ccGroupsendName').value = cc_grounpsend_names;
    // change end
    dojo.byId('ccGroupsend').value = aipo.webmail.getStringLine(cc_grounpsends);
    /* remove 運用障害9 2012.4.25
    dojo.byId('ccCorp').value = aipo.webmail.getStringLine(cc_corpaddresses);
    dojo.byId('ccExt').value = aipo.webmail.getStringLine(cc_extaddresses);
    */

    //dojo.byId('bcc').value = aipo.webmail.getStringLine(bcc);
    //dojo.byId('bccGroupsendName').value = bcc_grounpsend_names;
    //dojo.byId('bccGroupsendName').value = aipo.webmail.joinNames(bcc_grounpsend_names, bcc_corpaddress_names, bcc_extaddress_names);
    // change start 運用障害9 2012.4.25
    //dojo.byId('bccGroupsendName').value = aipo.webmail.joinNames(bcc_extaddress_names, bcc_corpaddress_names, bcc_grounpsend_names );
    dojo.byId('bccGroupsendName').value = bcc_grounpsend_names;
    // change end
    dojo.byId('bccGroupsend').value = aipo.webmail.getStringLine(bcc_grounpsends);
    /* remove 運用障害9 2012.4.25
    dojo.byId('bccCorp').value = aipo.webmail.getStringLine(bcc_corpaddresses);
    dojo.byId('bccExt').value = aipo.webmail.getStringLine(bcc_extaddresses);
    */
    // change end

    dijit.byId('addressbookDialog').hide();
    // add start 要件No.11 メール作成／詳細（ファイル添付）
    dojo.byId('uploadButton').style.display = "";
    // add end
}

/* remove 運用障害9 2012.4.25
aipo.webmail.joinNames = function(to, cc, bcc) {

  var rtn = to;

  if( cc != "" ) {
    if( rtn != "" ) {
        rtn = rtn + "," + cc;
      } else {
        rtn = cc;
      }
  }

  if( bcc != "" ) {
    if( rtn != "" ) {
        rtn = rtn + "," + bcc;
      } else {
        rtn = bcc;
      }
  }

  return rtn;
}
*/

// add start
/**
 * メールアドレス帳
 * 宛先、CC、BCCリスト（表示）と送信先リスト（非表示）をマッチさせて、一致するものを返却する
 *
 * @param recipients 送信先（宛先、CC、BCCいずれか）のリスト
 * @param groupsends 宛先、CC、BCCいずれかの送信先リスト（非表示）
 * @return 除去後の送信先リスト（非表示）
 */
aipo.webmail.makeGroupsends = function(recipients, groupsends){

    var newGroupsends = new Array();
    /*
    // グループ送信のリスト（非表示）を1件ずつ、送信先リストに一致するものがあるかを確認する
    for(i = 0 ; i < groupsends.length; i ++ ) {
        contains = false;
        for(j = 0 ; j < recipients.length; j ++ ) {
            if( groupsends[i].value == recipients[j].value ) {
                contains = true;
            }
        }
        // 送信先のリストに一致するものがあれば、グループ送信のリスト（非表示）を返却リストに追加
        if(contains == true) {
            newGroupsends.push(groupsends[i]);
        }
    }
    */

    // 送信先リスト（表示）を1件ずつ、送信先リスト（非表示）に一致するものがあるかを確認する
    for(i = 0 ; i < recipients.length; i ++ ) {
        contains = false;
        for(j = 0 ; j < groupsends.length; j ++ ) {
            if( recipients[i].value == groupsends[j].value ) {
                contains = true;
                break;
            }
        }
        // 送信先のリストに一致するものがあれば、送信先を返却リストに追加
        if(contains == true) {
            newGroupsends.push(recipients[i]);
        }
    }

    return newGroupsends;
}

/**
 * メールアドレス帳
 * 宛先、CC、BCCからグループ送信を除去する
 *
 * @param recipients 送信先（宛先、CC、BCCいずれか）のリスト
 * @param groupsends 宛先、CC、BCCいずれかのグループ送信リスト（非表示）
 * @return 除去後の宛先、CC、BCCいずれかのリスト
 */
aipo.webmail.makeRecipients = function(recipients, groupsends){

    var newRecipients = new Array();
    // 送信先のリストを1件ずつ、グループ送信のリスト（非表示）に一致するものがあるかを確認する
    for(i = 0 ; i < recipients.length; i ++ ) {
        contains = false;
        for(j = 0 ; j < groupsends.length; j ++ ) {
            if( recipients[i].value == groupsends[j].value ) {
                contains = true;
            }
        }
        // グループ送信のリスト（非表示）と一致するものがなければ、送信先を返却するリストに追加
        if(contains == false) {
            newRecipients.push(recipients[i]);
        }
    }
    return newRecipients;
}

/**
 * メールアドレス帳
 * メール作成（編集）画面に返すグループ送信文字列を生成する
 *
 * @param groupsends 宛先、CC、BCCいずれかのグループ送信リスト
 * @return グループ送信文字列
 */
/* remove 運用障害9 2012.4.25
aipo.webmail.makeGroupsendNames = function(groupsends){
    // メール作成に返すグループ送信名を生成
    var groupsend_name = "";
    for(i = 0 ; i < groupsends.length; i ++ ) {
        //tmp_groupsend_name = groupsends[i].value.split(" ");
        tmp_groupsend_name = aipo.webmail.getDisplayName(groupsends[i].value);
        if(i == 0) {
            //groupsend_name = tmp_groupsend_name[1];
            //groupsend_name = tmp_groupsend_name[2];
            groupsend_name = tmp_groupsend_name;
        } else {
            //groupsend_name = groupsend_name + "," + tmp_groupsend_name[1];
            //groupsend_name = groupsend_name + "," + tmp_groupsend_name[2];
            groupsend_name = groupsend_name + "," + tmp_groupsend_name;
        }
    }
    return groupsend_name;
}
*/

/**
 * メール送信先
 *
 * @param groupsends 宛先、CC、BCCいずれかのグループ送信リスト
 * @return グループ送信文字列
 */
aipo.webmail.makeNormalAddressNames = function(groupsends){
    // メール作成に返すグループ送信名を生成
    var groupsend_name = "";
    for( var i = 0 ; i < groupsends.length; i ++ ) {
        tmp_groupsend_name = groupsends[i].innerHTML;
        if(i == 0) {
            groupsend_name = tmp_groupsend_name;
        } else {
            groupsend_name = groupsend_name + "," + tmp_groupsend_name;
        }
    }
    return groupsend_name;
}

/**
 * （現在未使用）
 */
aipo.webmail.getDisplayName = function(name){
  var len = name.length;
  var spaceCnt = 0;
  var rtn = "";
  for( var i=0 ; i < len ; i++ ) {
    if( name.charAt(i) == ' ' ) {
      spaceCnt++;
      if( spaceCnt == 2 ) {
        rtn = name.substring(i+1);
        break;
      }
    }
  }
  rtn = rtn.replace("\n", "");
  rtn = rtn.replace("\r", "");
  return rtn;
}

// add end


/**
 * メールアドレス帳社内/社外切替
 *
 * @param check 対象ラジオボタン
 */
aipo.webmail.switchTypeCompany = function(check){
  if(check.value == '1') {
    dojo.byId('Block_Internal_Group').style.display = "block";
    dojo.byId('Block_External_Group').style.display="none";
    dojo.byId('userDiv').style.display="block";
    dojo.byId('addrDiv').style.display="none";
  } else {
    dojo.byId('Block_Internal_Group').style.display="none";
    dojo.byId('Block_External_Group').style.display="block";
    dojo.byId('userDiv').style.display="none";
    dojo.byId('addrDiv').style.display="block";
  }
}

/**
 * メールアドレス帳
 * 部署2変更時の所属者表示処理
 *
 * @param link 送信先URL
 * @param group 部署2選択値
 */
aipo.webmail.changeInternalGroup = function(link, group) {
    if(group == "ALL") {
        // 選択した部署2が"すべて"の場合、部署1の全所属者を表示
        var post1_group = dojo.byId("currentInternalGroupName").value;
        //aipo.webmail.createSelect("internal_member_from", "userDiv", link + "?mode=post1_group&groupname=" + post1_group + "&inc_luser=true", "displayName", "mailAddress", "", '', 'size="12" multiple="multiple" style="width: 99%"', 'addresslist-indicator');
        aipo.webmail.createSelect("internal_member_from", "userDiv", link + "?mode=post1_group&groupname=" + post1_group + "&inc_luser=true", "aliasName", "mailAddress", "", '', 'size="12" multiple="multiple" style="width: 99%"', 'addresslist-indicator');
    } else {
        // 選択した部署2が"すべて"以外の場合、選択された部署2の全所属者を表示
        //aipo.webmail.createSelect("internal_member_from", "userDiv", link + "?mode=group&groupname=" + group + "&inc_luser=true", "displayName", "mailAddress", "", '', 'size="12" multiple="multiple" style="width: 99%"', 'addresslist-indicator');
        aipo.webmail.createSelect("internal_member_from", "userDiv", link + "?mode=group&groupname=" + group + "&inc_luser=true", "aliasName", "mailAddress", "", '', 'size="12" multiple="multiple" style="width: 99%"', 'addresslist-indicator');
    }
}

/**
 * メールアドレス帳
 * 部署1変更時の表示処理
 *
 * @param link 送信先URL
 * @param group 部署1選択値
 */
aipo.webmail.changeExternalGroup = function(link, group) {
    //aipo.webmail.createSelect("external_member_from", "addrDiv", link + "?mode=group&groupname=" + group + "&inc_luser=true", "fullName", "mailAddress", "", '', 'size="12" multiple="multiple" style="width: 99%"', 'addresslist-indicator');
    aipo.webmail.createSelect("external_member_from", "addrDiv", link + "?mode=group&groupname=" + group + "&inc_luser=true", "fullName", "email", "", '', 'size="12" multiple="multiple" style="width: 99%"', 'addresslist-indicator');
}

aipo.webmail.createSelect = function(selectid, divid, url, keyname, keymail, sel, pre, att, ind) {
    var indicator = dojo.byId(ind);
    if (indicator) {
        dojo.style(indicator, "display" , "");
    }

    //add start
    var prefix = "u";
    if( selectid == "external_member_from" ) {
      prefix = "p";
    }
    //add end

    dojo.xhrGet({
        url: url,
        timeout: 10000,
        encoding: "utf-8",
        handleAs: "json-comment-filtered",
        headers: { X_REQUESTED_WITH: "XMLHttpRequest" },
        load: function (respodatanse, ioArgs){
            var html = "";
            if (typeof att == "undefined") {
                html += '<select name="'+ selectid + '">';
            } else {
                html += '<select name="'+ selectid + '" ' + att + '/>';
            }
            if (typeof pre == "undefined") {
                html += '';
            } else {
                html += pre;
            }
            dojo.forEach(respodatanse, function(p) {
                if(typeof p[keyname] == "undefined" || typeof p[keymail] == "undefined") {
                } else {
                    // add start
                    var addressId;
                    if( prefix == "u" ) {
                      addressId = p["userId"];
                    } else {
                      addressId = p["addressId"];
                    }

                 // change start 2012.3.15 受入障害対応No.326対応
//                    if (p[keyname] == sel) {
//                        html += "<option value='"+p[keyname]+"' selected='selected'>"+ p[keymail]+"</option>";
//                    } else {
//
//                        // change start
//                        //html += "<option value='"+p[keyname]+"&lt;"+ p[keymail]+"&gt;'>"+ p[keyname] +"&lt;"+ p[keymail] + "&gt;</option>";
//                        //html += "<option value='" + prefix + " " + addressId + " " +p[keyname]+"&lt;"+ p[keymail]+"&gt;'>"+ p[keyname] + "</option>";
//                        //html += "<option value='" + prefix + " " + addressId + " " +p[keyname]+"<"+ p[keymail]+">'>"+ p[keyname] + "</option>";
//                        var tmpKeyName = p[keyname];
//                        if( tmpKeyName.indexOf(",", 0)>=0 ) {
//                          tmpKeyName = "\"" + tmpKeyName + "\"";
//                        }
//                        html += "<option value='" + prefix + " " + addressId + " " + p[keyname] + "<"+ p[keymail]+">'>"+ tmpKeyName + "</option>";
//                        // change end
//                    }
                    var tmpKeyName = p[keyname];
                    if( tmpKeyName.indexOf(",", 0)>=0 ) {
                      tmpKeyName = "\"" + tmpKeyName + "\"";
                    }
                    html += "<option value='" + prefix + " " + addressId + " " + p[keyname] + "<"+ p[keymail]+">'>"+ tmpKeyName + "</option>";
                    // change end 2012.3.15 受入障害対応No.326対応
                }
            });
            html += '</select>';
            dojo.byId(divid).innerHTML = html;
            if (indicator) {
                dojo.style(indicator, "display" , "none");
            }
        }
    });
};

/**
 * （現在未使用）
 */
aipo.webmail.sendForm = function(){
    aipo.webmail.selectAll(document.WebMailAddressbook.detail_to_recipients);
    aipo.webmail.selectAll(document.WebMailAddressbook.detail_cc_recipients);
    aipo.webmail.selectAll(document.WebMailAddressbook.detail_bcc_recipients);
    document.WebMailAddressbook.submit();
}

/**
 * 文字配列の1行毎に改行を付与した文字列を返す
 * 部署1変更時の表示処理
 *
 * @param str_list 文字配列
 * @return 改行付き文字列
 */
aipo.webmail.getStringLine = function(str_list){
    var strs = '';
    if(str_list.length > 0){
        var length = str_list.length-1;
    for(i = 0 ; i < length; i ++ ) {
        strs = strs + str_list[i].value+'\n';
    }
    strs = strs + str_list[length].value;
  }
  return strs;
}

/**
 * （現在未使用）
 */
aipo.webmail.selectAll = function(select){
    var t_o = select.options;
    for(i = 0 ; i < t_o.length; i++ ) {
      t_o[i].selected = true;
    }
}

// change start
//aipo.webmail.exAddMember = function(form, select, portletId){
//
//  if(dojo.byId('corpId'+portletId).checked == true){
//    add_member(form.internal_member_from, select);
//  }else{
//    add_member(form.external_member_from, select);
//  }

/**
 * メールアドレス帳
 * 宛先に追加、CCに追加、BCCに追加 ボタン処理
 *
 * @param form 処理中のdocument.form
 * @param select 宛先、CC、BCCのいずれかのリスト
 * @param selectGroup 宛先、CC、BCCのいずれかのグループ送信リスト（非表示）
 * @param portletId ポートレットID
 *
 * ※add_memberメソッドの定義はjavascript\aimluck\aimluck.jsを参照
 */
aipo.webmail.exAddMember = function(form, select, selectCorp, selectExt, selectGroup, portletId){

  // 社内アドレスの場合
  if(dojo.byId('corpId'+portletId).checked == true){
      // 左側で選択されたアドレスまたはグループ送信を宛先、CC、BCCの指定されたリストに追加
    add_member(form.internal_member_from, select);
      if(dojo.byId('currentInternalGroupName').value == "groupsend"){
        // 左側でグループ送信が選択された場合は宛先、CC、BCCの指定されたグループ送信リスト（非表示）に追加
      add_member(form.internal_member_from, selectGroup);
    } else {
      // change start 運用障害9 2012.4.25
      //add_member(form.internal_member_from, selectCorp);
      add_member(form.internal_member_from, selectGroup);
      // change end
    }
  }else{
      // 個人アドレスの場合
    add_member(form.external_member_from, select);
    // change start 運用障害9 2012.4.25
    //add_member(form.external_member_from, selectExt);
    add_member(form.external_member_from, selectGroup);
    // change end
  }
// change end
}

/**
 * （現在未使用）
 */
aipo.webmail.removeAll = function(select){
  if (document.all) {
    var t_o = select.options;
    for(i = 0 ;i < t_o.length; i ++ ) {
      t_o.remove(i);
      i -= 1;
    }
  } else {
    var t_o = select.options;
    for(i = 0 ;i < t_o.length; i ++ ) {
      select.removeChild(t_o[i]);
      i -= 1;
    }
  }
}

/**
 * 左側トリム
 * @param str 対象文字列
 * @return 対象より左側をトリムした文字列
 */
aipo.webmail.ltrim = function(str){
  while(str.charAt(0)==" " || str.charAt(0)=="　"){
    str = str.substring(1,str.length)
  }
  return(str);
}

/**
 * 右側トリム
 * @param str 対象文字列
 * @return 対象より右側をトリムした文字列
 */
aipo.webmail.rtrim = function(str){
  while(str.charAt(str.length-1)==" " || str.charAt(str.length-1)=="　"){
    str = str.substring(0,str.length-1)
  }
  return(str);
}

/**
 * 右側トリム
 * @param str 対象文字列
 * @return 対象をトリムした文字列
 */
aipo.webmail.trim = function(str){
  return aipo.webmail.ltrim(aipo.webmail.rtrim(str));
}

/**
 * 自動振分：順番変更
 */
aipo.webmail.filter_order_submit = function(form) {
  var s_o = form.filter_so.options;
  var tmp = '';

  for(i = 0 ; i < s_o.length; i++ ) {
    s_o[i].selected = false;
  }

  if(s_o.length > 0) {
    for(i = 0 ; i < s_o.length-1; i++ ) {
      tmp = tmp + s_o[i].value + ',';
    }
    tmp = tmp + s_o[s_o.length-1].value;
  }
  form.positions.value = tmp;
}

/**
 * Webメールメインウインドウ
 */
var WebMailOriginalWindowObject = null;

/**
 * 結果メッセージ表示（メール送信/下書き/下書き削除コールバック処理）
 * 正常終了時、「サブウインドウよりメール一覧読み込み」実行
 *
 * @param msg 結果メッセージ（正常ならNULL）
 */
aipo.webmail.onReceiveMessageForWindow = function(msg){
    if(!msg) {
        if( WebMailOriginalWindowObject && !WebMailOriginalWindowObject.closed ) {
          if( WebMailOriginalWindowObject.aipo && WebMailOriginalWindowObject.aipo.webmail ) {
            WebMailOriginalWindowObject.aipo.webmail.reloadMailListForChildWindow();
          }
        }
        window.close();
    }
    if (dojo.byId('messageDiv')) {
        dojo.byId('messageDiv').innerHTML = msg;
    }
}

/**
 * 結果メッセージ表示（メール詳細削除コールバック処理）
 * 正常終了時、「サブウインドウよりメール一覧読み込み」を実行
 *
 * @param msg 結果メッセージ（正常ならNULL）
 */
aipo.webmail.onReceiveMessageForDetailWindow = function(msg){
    if(!msg) {
        if( window.opener && !window.opener.closed ) {
          if( window.opener.aipo && window.opener.aipo.webmail ) {
            window.opener.aipo.webmail.reloadMailListForChildWindow();
          }
        }
        window.close();
    }
    if (dojo.byId('messageDiv')) {
        dojo.byId('messageDiv').innerHTML = msg;
    }
}

/**
 * （現在未使用）
 */
aipo.webmail.hideDialogForWindow = function() {
  window.opener.aipo.portletReload('webmail');
  window.close();
};

//add by motegi start 全文検索
/**
 * 検索実行
 *
 * @param form 検索条件フォーム
 * @param url 検索実行処理URL
 * @param p_id ポートレットID
 */
aipo.webmail.onSubmitSearchButton = function(form,url,p_id){

    // 運用課題No.84
    // 検索中は押下不可にする
    var mailSearchButton = document.getElementsByName("mailSearch").item(0);
    mailSearchButton.disabled = true;
    var searchCondition = dojo.byId("searchCondition");
    searchCondition.style.display = "";
    searchCondition.innerHTML = "メール検索を実行しています。";
    mailSearchFlag = 1;

    var includeSubFolder = "";
    if(form.includesubfolder.checked == true) {
        includeSubFolder = '1';
    }

    var search_params = [["addressword",form.addressword.value],["subjectword",form.subjectword.value],
                        ["sword",form.sword.value],["includesubfolder",includeSubFolder],["mode",form.mode.value]];
    //aipo.viewPage(url, p_id, search_params);
    aipo.webmail.viewPage(url, p_id, search_params);
}

/**
 * 検索条件初期化
 */
aipo.webmail.onClearSearchButton = function(){
     dojo.byId('addressword').value = "";
     dojo.byId('subjectword').value = "";
     dojo.byId('sword').value = "";
     dojo.byId('includesubfolder').checked = false;
}

/**
 * メールアドレス帳
 * 部署1選択時処理
 *
 * @param link 送信先URL
 * @param option_link URL追加文字列
 * @param parent_post_id 部署1選択値
 * @param sel （未使用）
 * @param portlet_id （未使用）
 */
aipo.webmail.changeParentGroup = function(link, option_link, parent_post_id, sel, portlet_id) {

  // グループ送信（グループ指定）が選択された場合
  if(parent_post_id == "groupsend") {
        // 部署2は非活性
        dojo.byId("group").disabled = true;
        // グループ送信リスト取得
        var att = 'size="12" multiple="multiple" style="width: 99%"';
        var pre = '';
        var sel = "";
        var groupname = "name";
        var groupId = "groupId";
        var url = link + "&mode=groupsend";
        var divid = "userDiv";
        var selectid = "internal_member_from"

        dojo.xhrGet({
        url: url,
        timeout: 10000,
        encoding: "utf-8",
        handleAs: "json-comment-filtered",
        headers: { X_REQUESTED_WITH: "XMLHttpRequest" },
        load: function (respodatanse, ioArgs){
            // グループ送信セレクトボックス生成
            var html = "";
            if (typeof att == "undefined") {
                html += '<select name="'+ selectid + '"  ondblclick="aipo.webmail.showGroupSendUserList(this.value);">';
            } else {
                html += '<select name="'+ selectid + '"  ondblclick="aipo.webmail.showGroupSendUserList(this.value);"' + att + '/>';
            }
            dojo.forEach(respodatanse, function(p) {
                if(typeof p[groupId] == "undefined" || typeof p[groupname] == "undefined") {
                } else {
                    // valueは[グループ送信ID]空白[グループ送信名]
                    // 表示はグループ送信名のみ
                    html += "<option value='" + "g" + " " +p[groupId]+" "+p[groupname]+"'>"+ p[groupname] + "</option>";
                }
            });
            html += '</select>';
            dojo.byId(divid).innerHTML = html;
        }
    });

  } else {
  // グループ送信（個人指定）、部署１が選択された場合

    var pre = "";
    // 部署1の場合、部署2は"すべて"を初期選択
    var post2_group = "ALL";
    // グループ送信（個人指定）の場合、部署2は"（選択してください）"
    if(parent_post_id == "groupsend_without_post") {
      pre = '<option value="">（選択してください）<\/option>';
      post2_group = ""
      }
    var onchange_handle = " id=\"group\" onChange=\"aipo.webmail.changeInternalGroup('" + option_link + "', this.options[this.selectedIndex].value)\" style=\"width: 80%;\"";
    // 部署2プルダウン生成
    aimluck.utils.form.createSelect("group", "destpostDiv", link + "&mode=child&parent_group_name=" + parent_post_id, "groupId", "name", sel, pre, onchange_handle);
    // 所属者リスト生成
    aipo.webmail.changeInternalGroup(option_link, post2_group);
  }
}

//add by motegi for 代理送信
/**
 * メール送信代理送信切替
 *
 * @param flg trueの場合「送信元アドレスを選択する」/falseの場合「元に戻す」
 */
aipo.webmail.changeFormForSelectFrom = function(flg){
  if( flg ) {
    //送信元アドレスを選択する
    dojo.byId('defaultFromDiv').style.display = "none";
    dojo.byId('selectFromDiv').style.display = "";
    //dojo.byId('fromAccountId').value = "";
    dojo.byId('fromAccountId').value = dojo.byId('accountList').value;
    dojo.byId('representSend').value = "1";
  } else {
    //元に戻す
    dojo.byId('defaultFromDiv').style.display = "";
    dojo.byId('selectFromDiv').style.display = "none";
    dojo.byId('fromAccountId').value = dojo.byId('fromDefaultAccountId').value;
    dojo.byId('representSend').value = "0";
  }
}

//add by motegi for 代理送信
/**
 * 送信元アドレス選択
 *
 * @param account_id 送信元メールアカウントID
 */
aipo.webmail.setFromAccount = function(account_id){
  dojo.byId('fromAccountId').value = account_id;
}

//add start
/**
 * メールアドレス帳よりグループ送信ユーザー一覧表示
 * 部署1でグループ送信（グループ指定）が選択された場合、グループ送信をダブルクリックすると表示される
 *
 * @param groupSend グループ送信情報
 *                       [グループ送信ID<空白>グループ送信名]形式
 */
aipo.webmail.showGroupSendUserList = function(groupSend){
  // グループ送信IDの取得
  // グループ送信のパラメータは[グループ送信ID<空白>グループ送信名]のため空白で区切った前方を取得
  var groupSendId = groupSend.split(" ")[1];
  // グループ送信ユーザー一覧表示
  var url = dojo.byId('groupSendUserListUrl').innerHTML;
  aipo.common.showDialog(url + '&groupsendid=' + groupSendId + '');
}


/**
 * メール作成（編集）URLの取得
 * メール詳細で編集するボタンを押された場合、チェックボックスによってパラメータを付加する
 *
 * @param url  メール作成（編集）URL
 *
 */
aipo.webmail.getEditMailUrl = function(url, portlet_id){
    // 宛先を引用する
    var quoteTo = dojo.byId("quoteTo").checked;
    // 本文を引用する
    var quoteBody = dojo.byId("quoteBody").checked;
    // 本文に引用符を付ける
    var addQuotationMarks = dojo.byId("addQuotationMarks").checked;

      //location.href = url + "&quoteTo=" + quoteTo + "&quoteBody=" + quoteBody + "&addQuotationMarks=" + addQuotationMarks;
    var target = url + "&quoteTo=" + quoteTo + "&quoteBody=" + quoteBody + "&addQuotationMarks=" + addQuotationMarks;
    aipo.common.showWindow(target, portlet_id);
}

/**
 * メール「完全に削除」処理（1件）
 * aimluck.ioから移植（確認文言を変更するため）
 *
 */
aipo.webmail.ajaxMultiDeleteSubmit = function(button, url, indicator_id, portlet_id, receive) {
  if(confirm('選択したメールを完全に削除すると復元できません。よろしいですか？')) {
    aimluck.io.disableForm(button.form, true);
    aimluck.io.setHiddenValue(button);
    button.form.action = url;
    // 運用課題No.54
    // webメールポートレット用非同期通信処理を実行
    aipo.webmail.submit(button.form,indicator_id,portlet_id,receive);
  }
}

/**
 * メール「完全に削除」処理（全体）
 * aimluck.ioから移植（確認文言を変更するため）
 *
 */
aipo.webmail.ajaxCheckboxDeleteSubmit = function(button, url, indicator_id, portlet_id, receive) {
  aimluck.io.ajaxVerifyCheckbox( button.form, aipo.webmail.ajaxMultiDeleteSubmit, button, url, indicator_id, portlet_id, receive );
}

// 運用課題No.81 start
/**
 * メール「移動する」処理（全体）
 * aimluck.ioから移植（エラーメッセージ出力対応のため）
 *
 */
aipo.webmail.ajaxCheckboxMoveSubmit = function(button, url, indicator_id, portlet_id, receive) {
    //aimluck.io.ajaxVerifyCheckbox( button.form, aipo.webmail.ajaxMultiMoveSubmit, button, url, indicator_id, portlet_id, receive );
    if(dojo.byId("move_folder")){
        var folderList = dojo.byId("move_folder");
        var folderOptions = folderList.options;
        var selectFolderValue = folderOptions.item(folderList.selectedIndex).value;
        if(selectFolderValue == -1){
            alert("移動元と移動先は違うフォルダにしてください。");
            return false;
        }
    }
    aimluck.io.ajaxCheckboxActionSubmit(button, url, indicator_id, portlet_id, receive);
}
//運用課題No.81 end

/**
 * 結果メッセージ表示（一括退避・移動・削除処理コールバック）
 * 正常終了時、メインプロセスタイマー設定を実行
 *
 * @param msg 結果メッセージ（正常ならNULL）
 */
aipo.webmail.onReceiveMessageForPackageProcess = function(msg){
  if(!msg) {
    var arrDialog = dijit.byId("modalDialog");
    if(arrDialog){
      arrDialog.hide();
    }

    var radioList = document.getElementsByName("operation_type");
    var str = "";
    for(var i=0; i<radioList.length; i++){
      if (radioList[i].checked) {
        str = radioList[i].value;
        break;
      }
    }

    if( str == "0" ) {

      //退避の時だけ画面再表示する。
      var url = dojo.byId('processScreenUrl').value;
      var portletId = dojo.byId('portletId').value;
      aipo.common.showDialog(url, portletId);

      /*
      for(var index in ptConfigPackageProcessFormScreen) {
        if(ptConfigPackageProcessFormScreen[index].group == 'process-form') {
          var url = ptConfigPackageProcessFormScreen[index].initUrl
                  + "&entityid=new";
          aipo.common.showDialog(url, index);
          break;
        }
      }
      */
    }

    aipo.portletReload('webmail');
  }
  if (dojo.byId('messageDiv')) {
    dojo.byId('messageDiv').innerHTML = msg;
  }
}

/**
 * サブウインドウよりメール一覧読み込み
 *
 */
aipo.webmail.reloadMailListForChildWindow = function(){
  // 読み込みメッセージ表示
  aipo.webmail.viewLoadMessage();

  if( dojo.byId('receivingPid') ) {
    var portletId = dojo.byId('receivingPid').value;
    if( typeof ptConfig[portletId].reloadUrl != "undefined") {
      ptConfig[portletId].reloadUrl += '&mode=recieve&updateunread=1';
      aipo.webmail.viewPage(ptConfig[portletId].reloadUrl, portletId);
    }else{
      aipo.webmail.viewPage(ptConfig[portletId].initUrl, portletId);
    }
  }
}

/**
 * 対象よりメールアドレスを抜き出して返します
 *
 * @param str 対象文字列
 */
aipo.webmail.trimAddress = function(str){

  var len = str.length;
  var spaceCnt = 0;
  var nameAddress = "";
  for( var i=0 ; i < len ; i++ ) {
    if( str.charAt(i) == ' ' ) {
      spaceCnt++;
      if( spaceCnt == 2 ) {
        nameAddress = str.substring(i+1);
        break;
      }
    }
  }

  if ((n = nameAddress.lastIndexOf("<")) != -1) {
    return nameAddress.substring(0, n);
  }
  return nameAddress;
}

/**
 * 結果メッセージ表示（「完全に削除」コールバック）
 * 正常の場合、メール一覧読み込み（同期）を実行します。※未読数等も更新します
 *
 * @param msg 結果メッセージ（正常ならNULL）
 * @param indicator_id インジケーターID
 * @param portlet_id ポートレットID
 */
aipo.webmail.onListReceiveMessage = function(msg, indicator_id, portlet_id){
    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(arrDialog){
            arrDialog.hide();
        }
        var portletId = dojo.byId('receivingPid').value;
        aipo.webmail.reloadMailList(portletId);
    }
    var obj_indicator = dojo.byId(indicator_id + portlet_id);
    if(obj_indicator){
       dojo.style(obj_indicator, "display" , "");
       obj_indicator.innerHTML = msg;
    }
}

/**
 * Webメールポートレット非同期通信処理
 * 通信障害時、例外処理を実行する。
 * @param form 対象フォーム
 * @param indicator_id インジケーターID
 * @param portlet_id ポートレットID
 * @param callback コールバック処理
 */
aipo.webmail.submit = function(form, indicator_id, portlet_id, callback) {
    aimluck.io.disableForm(form, true);

    var obj_indicator = dojo.byId(indicator_id + portlet_id);
    if(obj_indicator){
       dojo.style(obj_indicator, "display" , "");
    }

    try{
        dojo.xhrPost({
            url: form.action,
            //timeout: 30000,
            timeout: 60000,
            form: form,
            encoding: "utf-8",
            handleAs: "json-comment-filtered",
            headers: { X_REQUESTED_WITH: "XMLHttpRequest" },
            load: function (response, ioArgs){

                var html = "";
                if(dojo.isArray(response) && response.length > 0) {
                    if(response[0] == "PermissionError"){
                        html += "<ul>";
                        html += "<li><span class='caution'>" + response[1] + "</span></li>";
                        html += "</ul>";
                    // add start 要件No.24 メール添付ファイルタイムアウト対応
                    } else if(response[0] == "NoFindFileError"){
                        var idArray = response[1].split(",");
                        dojo.forEach(idArray, function(id) {
                            aipo.webmail.removeOptionById(id);
                        });
                        aipo.webmail.syncAttachmentFile();
                        aipo.webmail.makeFileList();
                        html += "<ul>";
                        html += "<li><span class='caution'>" + response[2] + "</span></li>";
                        html += "</ul>";
                    // add end
                    }else{
                        html += "<ul>";
                        dojo.forEach(response, function(msg) {
                            html += "<li><span class='caution'>" + msg + "</span></li>";
                        });
                        html += "</ul>";
                    }
                }
                callback.call(callback, html, indicator_id, portlet_id);

                if (html != "") {
                    // エラーメッセージあり
                    // メッセージ表示域がある場合（メール送信）は、ボタンを有効（再操作可能）/インジケータ非表示にする。
                    if (dojo.byId('messageDiv')) {
                        aimluck.io.disableForm(form, false);
                        if(obj_indicator){
                            dojo.style(obj_indicator, "display" , "none");
                        }
                    }
                } else {
                    // エラーメッセージ無し
                    // メッセージ表示域がない場合（メール一覧）は、ボタンを有効（再操作可能）/インジケータ非表示にする。
                    if (!dojo.byId('messageDiv')) {
                        aimluck.io.disableForm(form, false);
                        if(obj_indicator){
                            dojo.style(obj_indicator, "display" , "none");
                        }
                    }
                }
            },
            error: function (error) {
              if (dojo.byId('messageDiv')) {
                  if(obj_indicator){
                      dojo.style(obj_indicator, "display" , "none");
                  }
                  dojo.byId('messageDiv').innerHTML = "<span class='caution'>Aipoからの応答が無い、もしくは不正です。[" + error.message + "]</span>";
              } else {
                  obj_indicator.innerHTML = "<span class='caution'>通信異常が発生しました。画面を更新した後に、操作をやり直して下さい。[" + error.message + "]</span>";
              }
            }
        });
    } catch(E) {
    };

    return false;
}
//add end

//add start 追加カスタマイズ
dojo.require("dojo.io.iframe");
/**
 * メール作成添付ファイル追加
 * @param form 対象フォーム
 * @param action_url 実行処理URL
 * @param indicator_id インジケーターID
 * @param portlet_id ポートレットID
 */
aipo.webmail.fileupload = function(form, action_url, indicator_id, portlet_id) {
	aipo.webmail.disableForm(form, true);
	// change start 2012.3.15 受入障害対応No.330対応
    //var obj_indicator = dojo.byId(indicator_id + portlet_id);
    var obj_indicator = dojo.byId("upload_indicator");
    // change end 2012.3.15 受入障害対応No.330対応
    if(obj_indicator){
       dojo.style(obj_indicator, "display" , "");
    }
    // メッセージ初期化
    // change start 2次開発 要件No.24 メール添付ファイルタイムアウト対応
    //dojo.byId('messageDiv').innerHTML = "";
    dojo.byId('messageDivUpload').innerHTML = "&nbsp;";
    dojo.byId('messageDivUpload').style.display = "none";
    // change end
    try{
        dojo.io.iframe.send({
            // action名
            url: action_url,
            form: form,
            encoding: "utf-8",
            handleAs:"html",
            headers: { X_REQUESTED_WITH: "XMLHttpRequest" },
            load: function (response, ioArgs){
            var file_data = response.body.innerHTML;
            // "/*"と"*/"で挟まれた文字列でレスポンスが返ってくるため
            // ""に置換
            file_data = file_data.replace(/\//g,"");
            file_data = file_data.replace(/\*/g,"");
            if(file_data.search(/Complete/i) != -1){
                file_data = file_data.split(":");
            	var folderName = file_data[0];
            	var fileId = file_data[1];
            	var fileName = file_data[2];
            	aipo.fileupload.onAddFileInfo(folderName,fileId,fileName);
            	// add start 要件No.24 メール添付ファイルタイムアウト対応
                //aipo.webmail.onAddFileInfo(fileName);
                aipo.webmail.syncAttachmentFile();
                // add end
            }else{
                file_data = file_data.replace(/\[/g,"");
                file_data = file_data.replace(/\]/g,"");
                // change start 2次開発 要件No.24 メール添付ファイルタイムアウト対応
                //dojo.byId('messageDiv').innerHTML = "<span class='caution'>" + file_data + "</span>";
                dojo.byId('messageDivUpload').innerHTML = "<span class='caution'>" + file_data + "</span>";
                dojo.byId('messageDivUpload').style.display = "";
                // change end
            }
            // change start 2012.3.15 受入障害対応No.330対応
            //obj_indicator = dojo.byId(indicator_id + portlet_id);
            obj_indicator = dojo.byId("upload_indicator");
            // change end 2012.3.15 受入障害対応No.330対応
            if(obj_indicator){
                dojo.style(obj_indicator, "display" , "none");
            }
            aipo.webmail.disableForm(form, false);
          },
            error: function (error) {
                // change start 2次開発 要件No.24 メール添付ファイルタイムアウト対応
                //dojo.byId('messageDiv').innerHTML = "<span class='caution'>Aipoからの応答が無い、もしくは不正です。[" + error.message + "]</span>";
                dojo.byId('messageDivUpload').innerHTML = "<span class='caution'>Aipoからの応答が無い、もしくは不正です。[" + error.message + "]</span>";
                dojo.byId('messageDivUpload').style.display = "";
                if(obj_indicator){
                    dojo.style(obj_indicator, "display" , "none");
                }
                // change end
                aipo.webmail.disableForm(form, false);
            }
        });
    } catch(E) {
    };

    return false;
}

// add start 2次開発 要件No.24 メール添付ファイルタイムアウト対応
/**
 * ファイル名リスト設定
 * @param filename ファイル名
 */
aipo.webmail.onAddFileInfo = function(filename) {
    var select = dojo.byId('attachmentFileNames');
    var value = encodeURIComponent(filename);
    var text = encodeURIComponent(filename);
    aimluck.io.addOption(select, value, text, false);
}

/**
 * ファイル名リストを表示しているリストと同期する。
 */
aipo.webmail.syncAttachmentFile = function() {
  var attachments = dojo.byId('attachments');
  var attachmentFileNames = dojo.byId('attachmentFileNames');

  while (attachmentFileNames.hasChildNodes()) {
      attachmentFileNames.removeChild(attachmentFileNames.lastChild);
  }

  var fileList = attachments.options;
  for(var i = 0 ; i < fileList.length; i ++ ) {
      var value = encodeURIComponent(fileList[i].text);
      var text = fileList[i].value;
      aimluck.io.addOption(attachmentFileNames, value, text, false);
  }
}

/**
 * 添付ファイル削除
 * @param deleteId 削除対象ファイルID
 */
aipo.webmail.removeOptionById = function(deleteId ){

  var select = dojo.byId('attachments');

  if (document.all) {
    var t_o = select.options;
    for(i = 0 ;i < t_o.length; i ++ ) {
      if( t_o[i].value == deleteId ) {
        t_o.remove(i);
        break;
      }
    }
  } else {
    var t_o = select.options;
    for(i = 0 ;i < t_o.length; i ++ ) {
      if( t_o[i].value == deleteId ) {
        select.removeChild(t_o[i]);
        break;
      }
    }
  }
}
// add end

/**
 * ファイル選択・ボタン表示切替
 * @param form 対象フォーム
 * @param bool trueの場合：ファイル選択・ボタン非表示/falseの場合：表示
 */
aipo.webmail.disableForm = function(form, bool) {
  var elements = form.elements;
  for (var i = 0; i < elements.length; i++) {
    if (elements[i].type == 'submit' || elements[i].type == 'button') {
      elements[i].disabled = bool;
    } else if (elements[i].type == 'file') {
      if( bool ) {
        dojo.style(elements[i], "display" , "none");
      } else {
        dojo.style(elements[i], "display" , "");
      }
    }
  }
}
//add end

//add start 2011.11.28
/**
 * 自動定期受信用タイマーID
 */
var mailAutoReceviingTimerId;

/**
 * 自動定期受信処理
 */
aipo.webmail.autoReloadMail = function(){

    // 読み込みメッセージ表示
    aipo.webmail.viewLoadMessage();

    // 初期アクセス用URL
    var receiveUrl = dojo.byId("initReceiveUrl").value;
    var pageStart = dojo.byId("page_start");
    if(pageStart){
        receiveUrl += '&start=' + pageStart.value;
    }
    receiveUrl += '&updateunread=1';
    // ポートレットID
    var portletId = dojo.byId("receivingPid").value;

    // メール受信実行
    aipo.webmail.viewPage(receiveUrl, portletId);
}

/**
 * 自動定期受信用タイマー設定処理
 */
aipo.webmail.setTimeoutReloadMail = function(){
  //if(mailAutoReceviingTimerId){
  //  clearTimeout(mailAutoReceviingTimerId);
  //}
  //mailAutoReceviingTimerId = setTimeout(aipo.webmail.autoReloadMail,600000);

  //add by motegi start
  var obj = dojo.byId('attentionMessage');
  if( obj ) {
    obj.innerHTML = "";
  }

  var portletId = dojo.byId("receivingPid").value;
  var obj2 = dojo.byId('indicator-' + portletId);
  if( obj2 ) {
    obj2.innerHTML = "";
    obj2.className = "";
  }

  if(mailAutoReceviingTimerId){
    clearTimeout(mailAutoReceviingTimerId);
    mailAutoReceviingTimerId = null;
  }

  if(mailReceviingTimerId){
    clearTimeout(mailReceviingTimerId);
    mailReceviingTimerId = null;
  }
  //add end
}

/**
 * 画面初期表示メール読み込み
 */
aipo.webmail.setTimeoutInitReloadMail = function(){
  //画面ロード共に受信処理（１回のみ）を行う。
  //mailAutoReceviingTimerId = setTimeout(aipo.webmail.autoReloadMail,1000);
  aipo.webmail.autoReloadMail();
}

/**
 * メール一覧チェック判定
 * @param form 対象フォーム
 * @return 一覧に一件以上チェックがある場合true、そうでない場合false
 */
aipo.webmail.ajaxVerifyCheckbox = function(form) {
  var cnt=0;
  var i;
  for(i =0; i< form.elements.length;i++){
    if(form.elements[i].checked) cnt++;
  }
  if(cnt == 0){
    alert("\u30c1\u30a7\u30c3\u30af\u30dc\u30c3\u30af\u30b9\u3092\uff11\u3064\u4ee5\u4e0a\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
    return false;
  }
  return true;
}
//add end

// change start 要件No.11 メール作成／詳細（ファイル添付）
///**
// * 添付ファイル削除
// * @param select 添付ファイルリスト
// */
//aipo.webmail.removeOptions = function(select){
//
//	  var newInputField = dojo.byId('uploadContainer');
//	  var oldInputField = document.getElementById('inputField').innerHTML
//	  newInputField.removeChild(dojo.byId('inputField'))
//	  var q = document.createElement('span');
//	  q.id='inputField';
//	  q.innerHTML = oldInputField;
//	  newInputField.appendChild(q);
//
//	  if (document.all) {
//	    var t_o = select.options;
//	      for(i = 0 ;i < t_o.length; i ++ ) {
//	          if( t_o[i].selected ) {
//	          t_o.remove(i);
//	            i -= 1;
//	        }
//	        }
//	  } else {
//	    var t_o = select.options;
//	      for(i = 0 ;i < t_o.length; i ++ ) {
//	          if( t_o[i].selected ) {
//	                select.removeChild(t_o[i]);
//	            i -= 1;
//	            }
//	        }
//	  }
//
//	  if(t_o.length == 0){
//	        add_option(select, '', '\u3000', false)
//	  }
//}
/**
* 添付ファイル削除
* @param chklist 削除対象の添付ファイルチェックボックス
*/
aipo.webmail.removeOptions = function(chklist){

    if ( chklist ) {
        // チェックされたファイルIDに紐付くlistを削除
        if ( chklist.length ) {
            // チェックボックス複数件の場合
            for ( i = 0; i < chklist.length; i++ ){
                if ( chklist[i].checked ) {
                    var old_attachments = dojo.byId('attachments');
                    var old_attachments_o = old_attachments.options;

                    for ( j = 0; j < old_attachments_o.length; j++ ) {
                        //  ファイルＩＤが同じリストを削除
                        if (chklist[i].value == old_attachments_o[j].value) {
                            old_attachments_o[j] = null;
                            break;
                        }
                    }
                }
            }
        } else {
            // チェックボックス1件の場合
            if ( chklist.checked ) {
                var old_attachments = dojo.byId('attachments');
                var old_attachments_o = old_attachments.options;

                for ( k = 0; k < old_attachments_o.length; k++ ) {
                    //  ファイルＩＤが同じリストを削除
                    if (chklist.value == old_attachments_o[k].value) {
                        old_attachments_o[k] = null;
                        break;
                    }
                }
            }
        }
    }
    // 添付ファイル一覧を再作成
    aipo.webmail.makeFileList();
}
// change end

// change start 運用フェーズ課題・障害台帳No.137
/**
 * 一括処理開始時の確認ダイアログ表示（期間を指定しないチェックがONの場合のみ）
 * @return OK:true キャンセル:false
 */
aipo.webmail.confirmAll = function() {
    if( dojo.byId("no_span") && dojo.byId("no_span").checked ) {
        return confirm("期間が指定されていないため、全期間のメールについて処理を行いますが、よろしいですか？");
    }
    return true;
}
// change end

// add start 要件No.12 メール整理ボタン
/**
 * メール整理　移動先ドロップダウン上下同期対応（上部同期）
 *
 */
aipo.webmail.ajaxDropdownUpperSync = function() {
    if(dojo.byId("move_folder") && dojo.byId("move_folder_Upper")){
        var folderList = dojo.byId("move_folder");
        var folderOptions = folderList.options;

        var folderUpperList = dojo.byId("move_folder_Upper");
        var folderUpperOptions = folderUpperList.options;
        var selectFolderUpperValue = folderUpperOptions.item(folderUpperList.selectedIndex).value;

        for(i=0; i<folderOptions.length;i++){
            if(folderOptions[i].value == selectFolderUpperValue){
                folderOptions[i].selected = true;
                break;
            }
        }
    }
}

/**
 * メール整理　移動先ドロップダウン上下同期対応（下部同期）
 *
 */
aipo.webmail.ajaxDropdownLowerSync = function() {
    if(dojo.byId("move_folder") && dojo.byId("move_folder_Upper")){
        var folderList = dojo.byId("move_folder");
        var folderOptions = folderList.options;
        var selectFolderValue = folderOptions.item(folderList.selectedIndex).value;

        var folderUpperList = dojo.byId("move_folder_Upper");
        var folderUpperOptions = folderUpperList.options;


        for(i=0; i<folderUpperOptions.length;i++){
            if(folderUpperOptions[i].value == selectFolderValue){
                folderUpperOptions[i].selected = true;
                break;
            }
        }
    }
}
// add end
// add start 要件No.11 メール作成／詳細（ファイル添付）
/**
 * アップロード開始
 * @param file アップロードファイル
 */
aipo.webmail.fileQueued = function(file) {
    try {
        // メッセージ初期化
        //var message = dojo.byId('messageDiv');
        //message.innerHTML = "";
        // アップロード用メッセージ初期化
        var messageDiv = dojo.byId('messageDivUpload');
        //messageDiv.style.display = "none";
        messageDiv.innerHTML = "";
        // ステータス設定
        var attachment_status = dojo.byId('attachment_status');
        attachment_status.value = "FILE_QUEUED";
        // 各種ボタンを非活性にする
        aipo.webmail.multiDisableForm(true);
        // インジケーター表示
        var obj_indicator = dojo.byId("upload_indicator");
        if(obj_indicator){
           dojo.style(obj_indicator, "display" , "");
        }

    } catch (ex) {
        messageDiv.style.display = "";
        messageDiv.innerHTML = "<span class='caution'>ファイルのアップロードに失敗しました。</span>";
    }
}
/**
 * アップロード成功（１ファイル毎）
 * @param file アップロードファイル
 * @param serverData ファイルＩＤ、ファイル名、ディレクトリ名
 */
aipo.webmail.uploadSuccess = function(file, serverData) {
    try {
        // 設定先要素を取得
        var attachments = dojo.byId("attachments");
        var folderName = dojo.byId("folderName");
        var messageDiv = dojo.byId("messageDivUpload");
        var errMessageList = dojo.byId('errMessageList');
        // サーバー戻り値を1ファイル毎に分解しファイル一覧へ設定
        var serverDataArray = serverData.split("/");
        for ( var i=0; i < serverDataArray.length; i++ ) {
            var file_data = serverDataArray[i];
            var folder = "";
            var fileId = "";
            var fileName = "";
            var errMessage = "";
            // aipo.webmail.fileuploadのload後と同等
            if(file_data.search(/Complete/i) != -1){
                file_data = file_data.split(":");
                folder = file_data[0];
                fileId = file_data[1];
                fileName = file_data[2];
                // aipo.fileupload.onAddFileInfoと同等
                attachments.options[attachments.options.length] = new Option(fileName, fileId);
                folderName.value =  folder;
            } else {
                // サーバ側エラーをエラーリストへ設定
                var err_data = serverDataArray[i];
                err_data = err_data.split(":");
                fileName = err_data[0];
                errMessage = err_data[1];
                errMessageList.options[errMessageList.options.length] = new Option(errMessage, fileName);
            }
        }
    } catch (ex) {
        messageDiv.style.display = "";
        messageDiv.innerHTML = "<span class='caution'>ファイルのアップロードに失敗しました。</span>";
    }
}
/**
 * アップロード完了（全ファイル）
 * @param numFilesUploaded アップロードファイル数
 */
aipo.webmail.queueComplete = function(numFilesUploaded) {

    // 添付ファイル一覧を再作成
    aipo.webmail.makeFileList();

    // add start 要件No.24 メール添付ファイルタイムアウト対応
    aipo.webmail.syncAttachmentFile();
    // add end

    // 各種ボタンを活性にする
    aipo.webmail.multiDisableForm(false);
    // インジケーター非表示
    obj_indicator = dojo.byId("upload_indicator");
    if(obj_indicator){
        dojo.style(obj_indicator, "display" , "none");
    }

    // エラーがあれば表示する
    var uploadErrMsg = dojo.byId('messageDivUpload');
    var errMessageList = dojo.byId('errMessageList');
    var errMessageList_o = errMessageList.options;
    var errHTML = "";

    for ( var i = 0; i < errMessageList_o.length; i++ ) {
        errHTML += "<span class='caution'>" + errMessageList_o[i].text + "ファイル名：[" + errMessageList_o[i].value + "]</span><br>";
    }
    if ( errMessageList_o.length > 0 ) {
        //uploadErrMsg.style.display = "";
        uploadErrMsg.innerHTML = errHTML;
    }
    // エラーリスト初期化
    // 0byteファイルのエラー表示の為、ここでクリアする。
    errMessageList.options.length = 0;
    // ステータス更新
    var attachment_status = dojo.byId('attachment_status');
    attachment_status.value = "QUEUE_COMPLETE";

}
/**
 * 添付ファイル一覧作成
 */
aipo.webmail.makeFileList = function() {

    var flList = dojo.byId("webMailFlUploadList");
    while (flList.hasChildNodes()) {
        flList.removeChild(flList.lastChild);
    }

    var HTML ="";
    flList.innerHTML = "";
    HTML  = "<div style=\"overflow-y:scroll; overflow-x:hidden; height:40px; border:1px solid #C9C9C9\">";
    HTML += "<table border=0px rules=\"none\" cellSpacing=0 cellPadding=0 style=\"width:100%; height:100%;border-collapse:collapse\">";

    var attachments = dojo.byId("attachments");
    var attachments_o = attachments.options;
    var attachments_cnt = attachments_o.length;

    var urlList = dojo.byId("attachmentUrl");
    var folderName = dojo.byId("folderName");
    var file_name = "";

    var i = 0;
    while (i < attachments_o.length){
        HTML += "<tr>";
        // ２列表示
        for ( var j = 0; j < 2; j++ ) {
            if ( attachments_cnt != 0 ) {
                HTML += "<td style=\"font-size: 75%;border-width:0px;padding:0\"><input type=\"checkbox\" name=chklist id=chklist style=\"height:16px; width:16px; padding-right:2px\" value=" + attachments_o[i].value + ">";
                HTML += "<a href=" + urlList.value + "?file_id=" + attachments_o[i].value + "&folder_name=" + folderName.value + ">";
                file_name = aipo.fileupload.fileNameMake(attachments_o[i].text,18,16);
                HTML += file_name;
                HTML += "</a></td>";
                i++;
                attachments_cnt--;
            }
        }
        HTML += "</tr>";
    }
  HTML += "</table></div>";
    flList.innerHTML = HTML;
}
/**
 * 複数ファイル選択・ボタン表示切替
 * @param form 対象フォーム
 * @param bool trueの場合：ファイル選択・ボタン非表示/falseの場合：表示
 */
aipo.webmail.multiDisableForm = function (bool) {

    var portlet_id = dojo.byId('mail_port_id');
    var mail_form = dojo.byId('form' + portlet_id.value);
    var elements = mail_form.elements;

    for (var i = 0; i < elements.length; i++) {
        if (elements[i].type == 'submit' || elements[i].type == 'button') {
            elements[i].disabled = bool;
        }
    }
}
// add end
