﻿//var flap=new Palaflap();
//flap.setSize(200,400).setImage("img[[number]].jpg",['A','B','C'])
//
if(!nandenjin){
	var nandenjin={};
	//オーディオ コンテキスト
	if(AudioContext){
		nandenjin.audioCtx=new AudioContext();
	}else if(webkitAudioContext){
		nandenjin.audioCtx=new webkitAudioContext();
	}
}
var palaflap={};
palaflap.timers=[];
window.addEventListener('load',function(){
	palaflap.timers.forEach(function(func){
		func();
	});
	setTimeout(arguments.callee,1000/60);
});
function Palaflap(){
	var width=0,height=0,margin=0,speed=0.15,shadowAlpha=0.5,dir,index=[],img=[],loaded=0,onload=function(){},onFinish=function(){};
	var status=0,nowFlap=0,nextFlap=1,target=0,audioCtx=nandenjin.audioCtx,audioData;
	var dom=document.createElement('canvas');
	var ctx=dom.getContext('2d');
	var setSize=function(w,h){
		width=w;
		height=h;
		dom.width=width;
		dom.height=height;
		return this;
	};
	var setImage=function(d,i){
		dir=d;
		index=i;
		img=[];
		loaded=0;
		index.forEach(function(e,h){
			var q=dir.replace(/\[\[NUMBER\]\]/g,h);
			img[h]=new Image();
			img[h].onload=function(){
				loaded++;
				if(loaded>=img.length){
					onload();
				}
			};
			img[h].src=q;
		});
		return this;
	};
	var setMargin=function(v){
		margin=v;
		return this;
	};
	var setSound=function(url,onError){
		var loader=new XMLHttpRequest();
		loader.open('GET',url,true);
		loader.responseType='arraybuffer';
		loader.onload=function(){
			audioCtx.decodeAudioData(loader.response,function(data){
				audioData=data;
			},function(){
				console.error('Palaflap.js:'+url+':Decode Error');
			});
		};
		loader.onerror=function(){
			console.error('Palaflap.js:'+url+':Load Error');
		};
		loader.send('');
		return this;
	};
	
	var launch=function(t){
		target=t;
	};
	
	palaflap.timers.push(function(){
		if(!img[nowFlap]||!img[nextFlap]){
			return false;
		}
		if(nowFlap==target&&status===0){
			status=0;
			return false;
		}
		status+=speed;
		if(status>=1){
			status-=1;
			nowFlap=nextFlap;
			nextFlap++;
			if(nextFlap>=img.length){
				nextFlap=0;
			}
			if(nowFlap==target){
				status=0;
			}
			//サウンド
			if(audioData){
				var soundPlayer=audioCtx.createBufferSource();
				soundPlayer.buffer=audioData;
				soundPlayer.connect(audioCtx.destination);
				soundPlayer.start(0);
			}
		}
	});
	
	requestAnimationFrame(function(){
		var alpha=1;
		requestAnimationFrame(arguments.callee);
		
		ctx.globalAlpha=1;
		ctx.fillStyle="#000";
		ctx.fillRect(0,0,width,height);
		var clipH=0,clipY=0,drawH=0,drawY=0;
		var parFlapH=(height-margin)/2;
		//上段
		clipH=parFlapH/(height/img[nextFlap].height);
		ctx.globalAlpha=1;
		ctx.drawImage(img[nextFlap],0,0,img[nextFlap].width,clipH,0,0,width,parFlapH);
		//下段
		clipY=((parFlapH+margin)/(height/img[nowFlap].height));
		clipH=parFlapH/(height/img[nowFlap].height);
		ctx.globalAlpha=1;
		ctx.drawImage(img[nowFlap],0,clipY,img[nowFlap].width,clipH,0,parFlapH+margin,width,parFlapH);
		//下段シャドー
		if(shadowAlpha>0){
			ctx.fillStyle="#000";
			alpha=shadowAlpha*((status-0.5)/0.5);
			if(alpha<0){
				ctx.globalAlpha=0;
			}else{
				ctx.globalAlpha=alpha;
			}
			ctx.fillRect(0,parFlapH+margin,width,parFlapH);
		}
		//駆動部
		if(0<=status&&status<0.5){
			imgN=nowFlap;
			clipY=0;
			clipH=parFlapH/(height/img[nowFlap].height);
			drawY=parFlapH-Math.cos(status*Math.PI)*parFlapH;
			drawH=Math.cos(status*Math.PI)*parFlapH;
			ctx.fillStyle="#000";
			alpha=shadowAlpha*(status/0.5);
		}else if(0.5<=status&&status<1){
			imgN=nextFlap;
			clipY=((parFlapH+margin)/(height/img[nextFlap].height));
			clipH=parFlapH/(height/img[nextFlap].height);
			drawY=parFlapH+margin;
			drawH=Math.cos((1-status)*Math.PI)*parFlapH;
			ctx.fillStyle="#FFF";
			alpha=shadowAlpha*((1-status)/0.5);
		}
		ctx.globalAlpha=1;
		ctx.drawImage(img[imgN],0,clipY,img[imgN].width,clipH,0,drawY,width,drawH);
		//駆動部シャドー
		if(shadowAlpha>0){
			ctx.globalAlpha=alpha;
			ctx.fillRect(0,drawY,width,drawH);
		}
	});
	return {
		setSize:setSize,
		setImage:setImage,
		setMargin:setMargin,
		setSound:setSound,
		launch:launch,
		dom:dom
	};
}