#include "LyricChangeCommand.h"

#include "EventItem.h"
#include "TreeItem.h"
#include "TreeItemModel.h"

using namespace stand::model;
using namespace stand::delegate::command;

LyricChangeCommand::LyricChangeCommand(const QString &lyric, const QModelIndex &index, QAbstractItemModel *model, QUndoCommand *child)
{
    _lyric = lyric;
    _index = index;
    _model = model;
    if(_model)
    {
        _index = index.model()->index(index.row(), EventItem::LyricData, index.parent());
        _backup = _model->data(_index, Qt::EditRole).toString();
    }
    if(!_index.isValid())
    {
        qDebug("Fatal error, index invalid. row = %d, rowcount = %d, column = %d, columnCount = %d",
               index.row(), ((TreeItem *)index.parent().internalPointer())->childCount()
               , index.column(), ((TreeItem*)index.parent().internalPointer())->columnCount());
        qFatal("LyricChangeCommand::constructor(%s); // index is not valid.", lyric.toLocal8Bit().data());
    }
    setChild(child);
}

void LyricChangeCommand::undo()
{
    _model->setData(_index, _backup, Qt::EditRole);

    if(_child)
    {
        _child->undo();
    }
}

void LyricChangeCommand::redo()
{
    _model->setData(_index, _lyric, Qt::EditRole);

    if(_child)
    {
        _child->redo();
    }
}
