#include "Analyzer.h"

#include "SequenceModel.h"
#include "TrackItem.h"
#include "ControlItem.h"
#include "EventItem.h"
#include "Alignment.h"
#include "Data.h"

#include "Utility.h"

#include "../configure.h"

using namespace stand::echoes;
using namespace stand::model;

void Analyzer::getAlignment(Alignment &dst, TreeItem *events, int id, int step)
{
    if(!events || id < 0 || events->childCount() <= id)
    {
        qDebug("stand::echoes::Analyzer::getAlignment(); // invalid args");
        qDebug(" events = 0x%x, events count = %d, id = %d", events, events ? events->childCount() : -1, id);
    }

    int previousId = id--;
    while(previousId >= 0)
    {
        previousId--;
    }
}

void Analyzer::getData(Data &dst, ControlItem *f0, ControlItem *volume, int tick, int step)
{
    printf("%d\n", tick);
}

bool Analyzer::analyze(QList<QPair<Alignment, Data> > &dst, const Item &item)
{
    if(!item.sequence)
    {
        qDebug("stand::echoes::Analyzer(); // sequence is null");
        return false;
    }

    TreeItem *events = item.sequence->track(item.trackId)->events();
    ControlItem *f0 = item.sequence->track(item.trackId)->controlAt(item.f0ControlId);
    ControlItem *volume = item.sequence->track(item.trackId)->controlAt(item.volumeControlId);
    if(!events || !f0 || !volume)
    {
        qDebug("stand::echoes::Analyzer(); // sequence does not have necessary item(s).");
        qDebug(" events = 0x%x, f0 = 0x%x, volume = 0x%x", events, f0, volume);
        return false;
    }

    for(int i = 0; i < events->childCount(); i++)
    {
        dst.push_back(QPair<Alignment, Data>());
        Alignment &a = dst.last().first;
        Data &d = dst.last().second;

        getAlignment(a, events, i, item.step);
        EventItem *event = dynamic_cast<EventItem*>(events->child(i));
        getData(d, f0, volume, event->tick(), item.step);
    }

    qSort(dst);
    return true;
}
