#ifndef EDITORWIDGET_H
#define EDITORWIDGET_H

#include <QWidget>

class QUndoStack;

namespace stand
{
namespace model
{
class SequenceModel;
}
namespace view
{
class TrackView;
class ControlArea;
}
namespace utility
{
namespace task
{
class Manager;
}
}

namespace gui
{

class EditorWidget : public QWidget
{
    Q_OBJECT
public:
    explicit EditorWidget(QWidget *parent = 0);
    bool confirmClearCurrent();

    inline bool isSaved() const
    {
        return _isSaved;
    }

signals:
    void fileChanged(const QString &name);

public slots:
    void undo();
    void redo();

    void save();
    void saveas();

    void newfile();
    void open();

    void importRawWave();

    void openVsqFile();

private slots:
    void reactivate();

protected:

private:
    void _resetModel(stand::model::SequenceModel *model);
    stand::model::SequenceModel *_model;
    stand::view::TrackView *_trackView;
    stand::view::ControlArea *_controlArea;
    stand::utility::task::Manager *_taskManager;

    QString _currentFilePath;
    bool _isSaved;
    double _framePeriod;
};

}
}

#endif // EDITORWIDGET_H
