#include "EnvelopeComputingTask.h"

#include "envelope/EnvelopeComputer.h"
#include "envelope/Envelope.h"
#include "WaveBuffer.h"

using namespace stand::gui::helper;
using namespace stand::utility::envelope;
using namespace stand::io;

EnvelopeComputingTask::EnvelopeComputingTask(Envelope *target, const WaveBuffer *wave, EnvelopeComputer *computer, QObject *parent) :
    Task(parent)
{
    _target = NULL;
    _wave = NULL;
    _computer = NULL;
    set(target, wave, computer);
}

EnvelopeComputingTask::~EnvelopeComputingTask()
{
    _destroy();
}

void EnvelopeComputingTask::_destroy()
{
    delete _computer;
    _target = NULL;
    _wave = NULL;
    _computer = NULL;
}

void EnvelopeComputingTask::set(Envelope *target, const WaveBuffer *wave, EnvelopeComputer *computer)
{
    _target = target;
    _wave = wave;
    if(computer != _computer)
    {
        delete _computer;
        _computer = computer;
    }
}

bool EnvelopeComputingTask::exec()
{
    if(!_target || !_wave || !_computer || _wave->empty())
    {
        qDebug("EnvelopeComputingTask::exec(t = %d, w = %d, c = %d); // Invalid paramters", _target, _wave, _computer);
        return false;
    }

    return _computer->compute(_target, _wave->data(), _wave->length(), _wave->header()->samplesPerSecond, _target->framePeriod());
}
