#include "ExclusiveEvent.h"
#include "MidiFile.h"

using namespace stand::io::midi;

ExclusiveEvent::ExclusiveEvent()
{
}

ExclusiveEvent::~ExclusiveEvent()
{
}

const char *ExclusiveEvent::set(const char *p, int tick)
{
    if(!p)
    {
        return NULL;
    }
    if(p[0] != 0xf0 && p[0] != 0xf7)
    {
        return p;
    }
    _type = p[0];
    _data = MidiFile::getDeltaTime(_length, &(p[1]));
    setTick(tick);
    if(_type == 0xf0)
    {
        return &(_data[_length + 1]);
    }
    return &(_data[_length]);
}
