#ifndef MIDICHUNK_H
#define MIDICHUNK_H

#include <stdio.h>

namespace stand
{
namespace io
{
namespace midi
{

class MidiChunk
{
public:
    explicit MidiChunk();
    ~MidiChunk();

    bool set(FILE *fp);

    inline const char *header() const
    {
        return _header;
    }

    inline const char *data() const
    {
        return _data;
    }

    inline int length() const
    {
        return _length;
    }

    inline bool empty() const
    {
        return (!_data || _length <= 0);
    }

    bool is(const char *name) const;


private:
    void _destroy();

    char _header[5];
    char *_data;
    int _length;
};

}
}
}

#endif // MIDICHUNK_H
