﻿#ifndef CHARACTERSETTINGS_H
#define CHARACTERSETTINGS_H

#include <QString>
#include <QTextCodec>

namespace stand
{
namespace io
{
namespace utau
{

class CharacterSettings
{
public:
    CharacterSettings();

    bool read(const QString &path, QTextCodec *codec = QTextCodec::codecForName("Shift-JIS"));

    const QString &name() const
    {
        return _name;
    }
    const QString &imagePath() const
    {
        return _imagePath;
    }
    const QString &sample() const
    {
        return _sample;
    }
    const QString &web() const
    {
        return _web;
    }
    const QString &author() const
    {
        return _author;
    }

    inline bool isGood() const
    {
        return _isGood;
    }

private:
    QString _author;
    QString _name;
    QString _imagePath;
    QString _sample;
    QString _web;

    bool _isGood;
};

}
}
}

#endif // CHARACTERSETTINGS_H
