#include "Matrix.h"

#include <stdio.h>

using namespace stand::math;

void stand::math::matrix::CreateMatarix(double ***dst, int x, int y)
{
    if(!dst || x <= 0 || y <= 0)
    {
        return;
    }
    double **pp = *dst;
    *dst = pp = new double*[x];
    pp[0] = new double[x * y];
    for(int i = 1; i < x; i++)
    {
        pp[i] = pp[0] + y * i;
    }
}

void stand::math::matrix::DestroyMatrix(double ***dst)
{
    if(!dst)
    {
        return;
    }
    double **pp = *dst;
    if(pp)
    {
        delete[] pp[0];
    }
    delete[] pp;
    pp = NULL;
}


void stand::math::matrix::GaussianElimination(double **inv, double **src, int dim)
{
    if(!inv || !src || dim <= 0)
    {
        return;
    }

    //　メモリを確保
    double **tmp;
    stand::math::matrix::CreateMatarix(&tmp, dim, dim);

    // 値を初期化．
    for(int i = 0; i < dim; i++)
    {
        for(int j = 0; j < dim; j++)
        {
            inv[i][j] = 0.0;
            tmp[i][j] = src[i][j];
        }
        inv[i][i] = 1.0;
    }

    for(int i = 0; i < dim; i++)
    {
        // i 行目を掃き出す．
        double buf = 1.0 / tmp[i][i];
        for(int j = 0; j < dim; j++)
        {
            tmp[j][i] *= buf;
            inv[j][i] *= buf;
        }
        for(int j = 0; j < dim; j++)
        {
            // j 列目について計算する．
            if(i == j)
            {
                continue;
            }
            double aij = tmp[i][j];
            for(int k = 0; k < dim; k++)
            {
                tmp[k][j] -= tmp[k][i] * aij;
                inv[k][j] -= inv[k][i] * aij;
            }
        }
    }

    stand::math::matrix::DestroyMatrix(&tmp);
}

double stand::math::matrix::Determinant(double **src, int dim)
{
    if(!src || dim <= 0)
    {
        return 0.0;
    }

    double **tmp;
    stand::math::matrix::CreateMatarix(&tmp, dim, dim);

    for(int i = 0; i < dim; i++)
    {
        for(int j = 0; j < dim; j++)
        {
            tmp[i][j] = src[i][j];
        }
    }

    double coefficient = 1.0;

    for(int i = 0; i < dim; i++)
    {
        coefficient *= tmp[i][i];
        for(int j = i + 1; j < dim; j++)
        {
            tmp[j][i] /= tmp[i][i];
        }
        for(int j = i + 1; j < dim; j++)
        {
            double buf = tmp[j][i];
            for(int k = i; k < dim; k++)
            {
                tmp[j][k] -= buf * tmp[i][k];
            }
        }
    }

    stand::math::matrix::DestroyMatrix(&tmp);

    return coefficient;
}

void stand::math::matrix::Covariance(double **dst, double **x, const double *mu, int dim, int n)
{
    if(!dst || !x || dim <= 0 || n <= 0)
    {
        return;
    }
    for(int i = 0; i < dim; i++)
    {
        for(int j = 0; j < dim; j++)
        {
            dst[i][j] = 0.0;
        }
    }
    for(int i = 0; i < n; i++)
    {
        for(int j = 0; j < dim; j++)
        {
            for(int k = 0; k < dim; k++)
            {
                dst[j][k] += (x[i][j] - mu[j]) * (x[i][k] - mu[k]) / (double)n;
            }
        }
    }
}

void stand::math::matrix::Multiple(double **dst, double **A, double **B, int n, int m, int l)
{
    if(!dst || !A || !B || n <= 0 || m <= 0 || l <= 0)
    {
        return;
    }
    for(int i = 0; i < n; i++)
    {
        for(int j = 0; j < l; j++)
        {
            double sum = 0;
            for(int k = 0; k < m; k++)
            {
                sum += A[k][i] * B[j][k];
            }
            dst[j][i] = sum;
        }
    }
}

