#include "Pca.h"

void pc_analysis(double **dst, double *lambda, double *avr, double *deviation, double **src, int N, int num_sam)
{
  double **matrix, tmp;
  int i, j, k;

  if(!dst || !src || N < 2 || num_sam < N)
    return;

  matrix = (double**)malloc(sizeof(double*) * N);
  memset(avr, 0, sizeof(double) * N);
  memset(deviation, 0, sizeof(double) * N);
  for(i = 0; i < num_sam; i++){
    matrix[i] = (double*)malloc(sizeof(double) * N);
    memset(matrix[i], 0, sizeof(double) * N);
  }

  //
  printf("Averaged Vector---\n");
  for(i = 0; i < N; i++){
    for(j = 0; j < num_sam; j++){
      avr[i] += src[j][i] / (double)num_sam;
    }
    printf("%lf\t", avr[i]);
  }
  printf("\n");

  //
  for(i = 0; i < N; i++){
    for(j = 0; j < num_sam; j++){
      tmp = src[j][i] - avr[i];
      deviation[i] += tmp * tmp / (double)(num_sam - 1);
    }
  }
  for(i = 0; i < N; i++){
    deviation[i] = sqrt(deviation[i]);
  }

  for(i = 0; i < N; i++){
    for(j = 0; j < num_sam; j++){
      src[j][i] = (src[j][i] - avr[i]) / deviation[i];
    }
  }

  printf("Relation Matrix---\n");
  for(i = 0; i < N; i++){
    for(j = 0; j < N; j++){
      for(k = 0; k < num_sam; k++){
        matrix[i][j] += src[k][i] * src[k][j];
      }
      matrix[i][j] /= (double)(num_sam - 1);
    printf("%lf\t",matrix[i][j]);
    }
    printf("\n");
  }
  printf("---\n");

  jacobian_method(dst, matrix, N);

  for(i = 0; i < N; i++){
      lambda[i] = matrix[i][i];
  }

  for(i = 0; i < N; i++){
    free(matrix[i]);
  }
  free(matrix);
}

void jacobian_method(double **dst, double **src, int N)
{
  int i, j , k, p , q;
  double temp, s_max = 1.0, app, apq, aqq, alpha, beta, gamma, s, c;
  for(i = 0; i < N; i++){
    memset(dst[i], 0, sizeof(double)*N);
    dst[i][i] = 1.0;
  }
  while(s_max > EIGEN_EPSILON){
    // гʬǰE礭Ȥ򸡺ޤ
    s_max = src[p = 0][q = 1];
    for(i = 0; i < N; i++){
      for(j = 0; j < N; j++){
        if(i == j) continue;
        else if(src[i][j] > s_max){
          p = i; q = j; s_max = src[i][j];
        }
      }
    }
    app = src[p][p];
    apq = src[p][q];
    aqq = src[q][q];

    alpha = (app - aqq) / 2;
    beta  = -apq;
    gamma = fabs(alpha)/sqrt(alpha*alpha + beta*beta);
    s = sqrt((1 - gamma)/2);
    c = sqrt((1 + gamma)/2);
    if(alpha*beta < 0) s = -s;

    for(i = 0; i < N; i++){
      temp = c * src[p][i] - s * src[q][i];
      src[q][i] = s * src[p][i] + c * src[q][i];
      src[p][i] = temp;
    }
    for(i = 0; i < N; i++){
      src[i][p] = src[p][i];
      src[i][q] = src[q][i];
    }

    src[p][p] = c*c*app + s*s*aqq - 2*s*c*apq;
    src[p][q] = s*c*(app-aqq) + (c*c - s*s)*apq;
    src[q][p] = s*c*(app-aqq) + (c*c - s*s)*apq;
    src[q][q] = s*s*app + c*c*aqq + 2*s*c*apq;

    for(i = 0; i < N; i++){
      temp = c * dst[i][p] - s * dst[i][q];
      dst[i][q] = s * dst[i][p] + c * dst[i][q];
      dst[i][p] = temp;
    }
  }
}
