﻿#include "EventItem.h"

#include "Utility.h"

using namespace stand::model;

EventItem::EventItem(const QString &name, TreeItem *parent) :
    TreeItem(name, parent)
{
    _note = _velocity = 64;
    _tick = _length = 0;
}

EventItem::~EventItem()
{
}

int EventItem::columnCount() const
{
    /*
     * 0: tick
     * 1: length
     * 2: note
     * 3: velocity
     * 4: lyric
     * 5: pronounce
     */
    return DataCount;
}

QVariant EventItem::data(int column, int role) const
{
    if(role != Qt::DisplayRole && role != Qt::EditRole)
    {
        return QVariant();
    }

    switch(column)
    {
    case TickData:
        return _tick;
    case LengthData:
        return _length;
    case NoteData:
        return _note;
    case VelocityData:
        return _velocity;
    case LyricData:
        return _lyric;
    case PronounceData:
        return _pronounce;
    case DisplayData:
        return _lyric + "[" + _pronounce + "]";
    }
}

void EventItem::setData(int column, const QVariant &d, int role)
{
    if(role != Qt::DisplayRole && role != Qt::EditRole)
    {
        return;
    }
    switch(column)
    {
    case TickData:
        _tick = d.toInt();
        break;
    case LengthData:
        _length = d.toInt();
        break;
    case NoteData:
        _note = d.toInt();
        break;
    case VelocityData:
        _velocity = d.toInt();
        break;
    case LyricData:
        _lyric = d.toString();
        break;
    case PronounceData:
        _pronounce = d.toString();
        break;
    }
}

void EventItem::setUpDomElement(QDomDocument &doc, QDomElement &element)
{
    element.setTagName("event");
    element.setAttribute("tick", _tick);
    element.setAttribute("length", _length);
    element.setAttribute("note", _note);
    element.setAttribute("velocity", _velocity);
    if(_lyric != QString::null)
    {
        QDomElement lelement = doc.createElement("lyric");
        QDomText ltext = doc.createTextNode(_lyric);
        lelement.appendChild(ltext);
        element.appendChild(lelement);
    }
    if(_pronounce != QString::null)
    {
        QDomElement pelement = doc.createElement("pronounce");
        QDomText ptext = doc.createTextNode(_pronounce);
        pelement.appendChild(ptext);
        element.appendChild(pelement);
    }
}

QString EventItem::toString() const
{
    return QString().append("note ").append(stand::utility::NoteName(note())).append(" tick ").append(QString::number(tick())).append(" length ").append(QString::number(length()));
}
