﻿#ifndef MEASUREITEM_H
#define MEASUREITEM_H

#include "TreeItem.h"

namespace stand
{
namespace sequence
{
class Measure;
}
namespace model
{

class MeasureItem : public TreeItem
{
public:
    struct Rhythm
    {
        int measure;
        int numerator;
        int denominator;
    };

    explicit MeasureItem(const QString &name, int numerator, int denominator, TreeItem *parent = 0);
    virtual ~MeasureItem();

    virtual int columnCount() const;
    virtual QVariant data(int column, int role) const;
    virtual void setData(int column, const QVariant &d, int role);

    inline const QList<Rhythm> &contour() const
    {
        return _contour;
    }

    QList<Rhythm> contour(int first, int last) const;

    void removeColumn(int first, int last);

    inline int length() const
    {
        return _length;
    }

    void setMeasure(const stand::sequence::Measure *measure);

protected:
    virtual void setUpDomElement(QDomDocument &doc, QDomElement &element);

private:
    QList<Rhythm> _contour;

    int _length;
};

}
}

#endif // MEASUREITEM_H
