#ifndef TRACKITEM_H
#define TRACKITEM_H

#include "TreeItem.h"

namespace stand
{
namespace utility
{
namespace envelope
{
class Envelope;
}
}
namespace sequence
{
class Track;
}
namespace model
{

class ControlItem;
class MetaItem;

class TrackItem : public TreeItem
{
    Q_OBJECT
public:
    explicit TrackItem(const QString &name, TreeItem *parent = 0);
    virtual ~TrackItem();

    inline TreeItem *events() const
    {
        return child(0);
    }

    QList<TreeItem *> controls() const;
    ControlItem *controlAt(int id) const;
    int length() const;
    void setTrack(stand::sequence::Track *track);

    TreeItem *createControl(const QString &name, const stand::utility::envelope::Envelope *e, const QVector<int> &ticks, int viewType);

protected:
    virtual void setUpDomElement(QDomDocument &doc, QDomElement &element);
    TreeItem *createControl(const QString &name, double value);

private:
};

}
}

#endif // TRACKITEM_H
