﻿#include "CorpusXmlFactory.h"

#include "PhonemeItem.h"

using namespace stand::model::xml;
using namespace stand::model;

TreeItem *CorpusXmlFactory::createItem(const QDomElement &element, TreeItem *parent) const
{
    if(element.tagName() == "phoneme")
    {
        TreeItem *item = new PhonemeItem(element.attribute("name"), parent);
        _setPhoneme(element, item);
        return item;
    }
    return TreeXmlFactory::createItem(element, parent);
}

void CorpusXmlFactory::_setPhoneme(const QDomElement &element, TreeItem *item)
{
    for(int i = 0; i < element.childNodes().size(); i++)
    {
        QDomElement e = element.childNodes().at(i).toElement();
        int column = PhonemeItem::GetColumnForString(e.tagName());
        item->setData(column, e.text(), 0);
    }
}
