﻿#include "TreeXmlFactory.h"

#include "TreeItem.h"

using namespace stand::model::xml;
using namespace stand::model;

TreeItem *TreeXmlFactory::createItem(const QDomElement &element, TreeItem *parent) const
{
    if(element.tagName() == "data")
    {
        if(parent)
        {
            parent->setData(element.attribute("column").toInt(), element.text(), 0);
        }
        return NULL;
    }
    TreeItem *item = new TreeItem(element.attribute("name"), parent);
    item->setFlags((Qt::ItemFlags)element.attribute("edit_flags").toInt());

    for(int i = 0; i < element.childNodes().size(); i++)
    {
        QDomElement e = element.childNodes().at(i).toElement();
        TreeItem *child = createItem(e, item);
        if(child)
        {
            item->appendChild(child);
        }
    }
    return item;
}


