#ifndef CONTROLCURVE_H
#define CONTROLCURVE_H

#include <QList>
#include "importer/Interpreter.h"

namespace stand
{
namespace sequence
{

class ControlCurve : public importer::Interpreter
{
public:
    struct Point
    {
        int tickBegin;
        int tickEnd;
        double val;
    };

    explicit ControlCurve(double defaultValue);
    virtual ~ControlCurve();

    void add(int tick, double val);
    virtual Interpreter* interpret(const QString &line);

    const QString toString() const;

    double at(int tick) const;

    static double defaultValue(const QString &name);

    inline void clear(double defaultValue = 0.0)
    {
        _data.clear();
        Point p = {INT_MIN, INT_MAX, defaultValue};
        _data.push_back(p);
    }

    inline const QList<Point> &data() const
    {
        return _data;
    }

    inline double defaultValue() const
    {
        if(_data.empty())
        {
            return 0.0;
        }
        return _data[0].val;
    }

protected:
    QList<Point> _data;
};

}
}

#endif // CONTROLCURVE_H
