#include "LyricHandle.h"

#include <QStringList>

using namespace stand::sequence;

QHash<QString, importer::Interpreter *(LyricHandle::*)(const QString &)> LyricHandle::Factories;

LyricHandle::LyricHandle()
{
    if(Factories.empty())
    {
        Factories["Lyric"] = &LyricHandle::_setLyric;
        Factories["Pronounce"] = &LyricHandle::_setPronounce;
    }
}

LyricHandle::~LyricHandle()
{
}

const QString LyricHandle::toString() const
{
    QString retval;
    QString lyric(_lyric);
    lyric.replace(" ", "&");
    QString pronounce(_pronounce);
    pronounce.replace(" ", "&");
    retval = name() + " Lyric " + lyric + "\n";
    retval += name() + " Pronounce " + pronounce + "\n";
    return retval;
}

importer::Interpreter *LyricHandle::interpret(const QString &line)
{
    QStringList sl = line.split(" ", QString::SkipEmptyParts);
    if(sl.size() == 2 && Factories.contains(sl.at(0)))
    {
        return (this->*Factories[sl.at(0)])(sl.at(1));
    }
    return NULL;
}

importer::Interpreter *LyricHandle::_setLyric(const QString &val)
{
    _lyric = val;
    _lyric.replace("&", " ");
    return NULL;
}

importer::Interpreter *LyricHandle::_setPronounce(const QString &val)
{
    _pronounce = val;
    _pronounce.replace("&"," ");
    return NULL;
}

