#ifndef SEQUENCE_H
#define SEQUENCE_H

#include <QObject>
#include <QHash>
#include <QList>

#include "importer/Interpreter.h"

namespace stand
{
namespace sequence
{

class Track;
class Tempo;
class Measure;

namespace importer
{
class Importer;
}

class Sequence : public QObject, importer::Interpreter
{
    Q_OBJECT
public:
    explicit Sequence(QObject *parent = 0);
    virtual ~Sequence();

    bool import(importer::Importer *importer);
    virtual Interpreter* interpret(const QString& line);

    virtual const QString toString() const;

    inline Interpreter *find(const QString &key)
    {
        if(!_dictionary.contains(key))
        {
            return NULL;
        }
        return _dictionary[key];
    }

    const inline Measure *measure() const
    {
        return _measure;
    }

    inline const Tempo *tempo() const
    {
        return _tempo;
    }

    Track *track(int index);
    inline int trackSize() const
    {
        return _tracks.size();
    }

    inline bool empty() const
    {
        return _tracks.empty();
    }

    int tickAt(double ms) const;
    double msAt(int tick) const;

private:
    Interpreter* _setPreMeasure(const QString &val);
    Interpreter* _createMixer(const QString &name);
    Interpreter* _createSequence(const QString &name);
    Interpreter* _createTrack(const QString &name);
    Interpreter* _createTempo(const QString &name);
    Interpreter* _createControl(const QString &name);
    Interpreter* _createMeasure(const QString &name);

    void _destroy();
    Tempo *_tempo;
    Measure *_measure;
    QList<Track *> _tracks;

    QHash<QString, Interpreter *> _dictionary;
    QHash<QString, double> _defaults;

    int _preMeasure;
    int _trackId;
    static const int DefaultPreMeasure = 3;

    static QHash<QString, Interpreter* (Sequence::*)(const QString &)> Factories;
};

}
}

#endif // SEQUENCE_H
