#include "UtilityTest.h"
#include "../utility/Utility.h"
#include "../configure.h"

#include <QtTest/QtTest>

using namespace stand::utility;

UtilityTest::UtilityTest(QObject *parent) :
    QObject(parent)
{
}

void UtilityTest::testLengthForUtau_data()
{
    QTest::addColumn<int>("WaveLength");
    QTest::addColumn<int>("SamplingFrequency");
    QTest::addColumn<float>("LeftBlank");
    QTest::addColumn<float>("RightBlank");
    QTest::addColumn<int>("result");

    QTest::newRow("All Blank") << 44100 << 44100 << 0.0f << 0.0f << 44100;
    QTest::newRow("LeftBlank") << 44100 << 44100 << 500.0f << 0.0f << 22050;
    QTest::newRow("RightBkank+") << 44100 << 44100 << 0.0f << 500.0f << 22050;
    QTest::newRow("RightBlank-") << 44100 << 44100 << 0.0f << -500.0f << 22050;
    QTest::newRow("Mixed l, r+") << 44100 << 44100 << 250.0f << 250.0f << 22050;
    QTest::newRow("Mixed l, r-") << 44100 << 44100 << 250.0f << -500.0f << 22050;
}

void UtilityTest::testLengthForUtau()
{
    QFETCH(int, WaveLength);
    QFETCH(int, SamplingFrequency);
    QFETCH(float, LeftBlank);
    QFETCH(float, RightBlank);
    QFETCH(int, result);
    QCOMPARE(lengthForUtauSetting(WaveLength, SamplingFrequency, LeftBlank, RightBlank), result);
}

void UtilityTest::ticksFromMs_data()
{
    QTest::addColumn<double>("ms");
    QTest::addColumn<double>("bpm");
    QTest::addColumn<int>("result");

    QTest::newRow("Zero data") << 0.0 << 120.0 << 0;
    QTest::newRow("Default test") << 1000.0 << 120.0 << stand::sequence::DefaultTicksPerBeat * 2;
    QTest::newRow("Tempo Changed") << 1000.0 << 88.0 << stand::sequence::DefaultTicksPerBeat * 2 * 88 / 120;
    QTest::newRow("Second Changed") << 800.0 << 88.0 << stand::sequence::DefaultTicksPerBeat * 2 * 88 * 4 / 5 / 120;
}

void UtilityTest::ticksFromMs()
{
    QFETCH(double, ms);
    QFETCH(double, bpm);
    QFETCH(int, result);
    QCOMPARE((int)TicksFromMs(ms, bpm), result);
}

void UtilityTest::msFromTick_data()
{
    QTest::addColumn<int>("tick");
    QTest::addColumn<double>("bpm");
    QTest::addColumn<double>("result");

    QTest::newRow("Zero data") << 0 << 120.0 << 0.0;
    QTest::newRow("Default test") << stand::sequence::DefaultTicksPerBeat * 2 << 120.0 << 1000.0;
    QTest::newRow("Tempo Changed") << stand::sequence::DefaultTicksPerBeat * 2 * 88 / 120 << 88.0 << 1000.0;
    QTest::newRow("Second Changed") << stand::sequence::DefaultTicksPerBeat * 2 * 88 * 4 / 5 / 120 << 88.0 << 1000.0 * (stand::sequence::DefaultTicksPerBeat * 2 * 88 * 4 / 5 / 120) / (stand::sequence::DefaultTicksPerBeat * 2 * 88 / 120);
}

void UtilityTest::msFromTick()
{
    QFETCH(int, tick);
    QFETCH(double, bpm);
    QFETCH(double, result);
    QCOMPARE(MsFromTick(tick, bpm), result);
}
