#ifndef TASK_MANAGER_H
#define TASK_MANAGER_H

#include <QObject>
#include <QMutex>

namespace stand
{
namespace utility
{
namespace task
{

class Task;
class Worker;

class Manager : public QObject
{
    Q_OBJECT
public:
    explicit Manager(QList<Task *> tasks, int numThreads = 1, bool background = false, QObject *parent = 0);
    virtual ~Manager();

    bool set(QList<Task *> tasks, int numThreads, bool background = false);

    inline bool isRunning() const
    {
        return _running;
    }

signals:
    void finished();
    void canceled();

public slots:
    void start();
    void cancel();

private slots:
    void _workerFinished();

private:
    void _destroy();

    QList<Worker *> _workers;
    QList<QThread *> _threads;
    QMutex _mutex;
    bool _running;
    bool _background;

    int _finishCount;
};

}
}
}

#endif // TASK_MANAGER_H
