#include "ControlSelector.h"

#include "ViewSettings.h"
#include "ControlItem.h"

#include <QPainter>
#include <QPaintEvent>
#include <QMouseEvent>

using namespace stand::view;

ControlSelector::ControlSelector(ViewSettings *s, QWidget *parent) :
    QWidget(parent)
{
    _settings = NULL;
    _settingsIsDeletable = false;
    setSettings(s);
}

ControlSelector::~ControlSelector()
{
    if(_settingsIsDeletable)
    {
        delete _settings;
    }
}

void ControlSelector::releaseSettings()
{
    disconnect(this, SLOT(releaseSettings()));
    _settings = new ViewSettings(1, 16, 64, this);
    _settingsIsDeletable = true;
}

void ControlSelector::setSettings(ViewSettings *s)
{
    disconnect(this, SLOT(releaseSettings()));
    if(_settingsIsDeletable)
    {
        delete _settings;
    }
    _settings = s;
    if(s)
    {
        connect(_settings, SIGNAL(AboutToDelete()), this, SLOT(releaseSettings()));
        _settingsIsDeletable = false;
    }
    else
    {
        _settings = new ViewSettings(1, 16, 64, this);
        _settingsIsDeletable = true;
    }
    connect(_settings, SIGNAL(StateChanged()), this, SLOT(update()));
    connect(_settings, SIGNAL(trackChanged()), this, SLOT(repaint()));
    update();
}

void ControlSelector::paintEvent(QPaintEvent *e)
{
    QPainter p(this);
    p.fillRect(e->rect(), QColor(64, 64, 64));

    p.setPen(QColor(0, 192, 192));
    p.drawRect(width() - 1, 0, width() - 1, height());
    QFont font(p.font());
    font.setPointSize(_settings->noteHeight() - 6);
    font.setBold(true);
    p.setFont(font);

    for(int i = 0, k =0; i < _settings->controls().size(); i++)
    {
        if(_settings->controls()[i]->data(stand::model::ControlItem::ViewType, 0).toInt() != stand::model::ControlItem::TypeNormal)
        {
            continue;
        }
        QRect r(8, height() / 64 + k * _settings->noteHeight() * 3 / 2, width() -16, _settings->noteHeight() * 5 / 4);
        QPen penText(QColor(0, 192, 192));
        if(k == _settings->controlId())
        {
            p.fillRect(r, QColor(32, 128, 128));
            penText.setColor(QColor(64, 255, 255));
        }
        else if(k == _settings->controlIdPrevious())
        {
            p.fillRect(r, QColor(32, 96, 96));
        }
        p.setPen(QColor(0, 192, 192));
        p.drawRect(r);
        p.setPen(penText);
        p.drawText(r, _settings->controls()[i]->name(), Qt::AlignCenter | Qt::AlignVCenter);
        k++;
    }
}

void ControlSelector::mousePressEvent(QMouseEvent *e)
{
    for(int i = 0, k =0; i < _settings->controls().size(); i++)
    {
        QRect r(8, height() / 64 + k * _settings->noteHeight() * 3 / 2, width() -16, _settings->noteHeight() * 5 / 4);
        if(r.contains(e->pos()))
        {
            if(_settings->controlId() != i)
            {
                _settings->setControlId(i);
                update();
            }
            break;
        }
        k++;
    }
}
