﻿#ifndef MEASUREVIEW_H
#define MEASUREVIEW_H

#include <QWidget>
#include <QUndoCommand>

class QLineEdit;

namespace stand
{
namespace model
{
class MeasureItem;
class ControlItem;
class TreeItem;
}
namespace view
{

class ViewSettings;

class MeasureView : public QWidget
{
    Q_OBJECT
    struct _Point;
public:
    explicit MeasureView(QWidget *parent);
    virtual ~MeasureView();

    void setSettings(ViewSettings *s);
signals:

protected:
    void paintEvent(QPaintEvent *e);

    void mousePressEvent(QMouseEvent *e);
    void mouseDoubleClickEvent(QMouseEvent *e);

    bool eventFilter(QObject *o, QEvent *e);

public slots:
    void releaseSettings();
    void reset();
    void BarMoved(int, int);
    void widthChanged(int);

    void getEditorData();

private:
    _Point _indexAt(QPoint pos);
    QString _stringFromPoint(_Point *p);

    void _drawLines(int begin, int end, QPainter *p, QPaintEvent *e);
    void _drawTempo(int begin, int end, QPainter *p, QPaintEvent *e);
    void _drawMeasure(int begin, int end, QPainter *p, QPaintEvent *e);

    ViewSettings *_settings;
    bool _settingsIsDeletable;
    QLineEdit *_editor;

    enum _PointType
    {
        _TypeTempo = 1,
        _TypeMeasure = 2
    };

    struct _Point
    {
        int tick;
        int type;
        double tempo;
        int up;
        int down;
    };
    _Point _current;

    class MeasureCommand : public QUndoCommand
    {
    public:
        explicit MeasureCommand(_Point newPoint, ViewSettings *s);

        void undo();
        void redo();
    private:
        _Point n, o;
        ViewSettings *settings;
    };
};

}
}

#endif // MEASUREVIEW_H
