﻿#include "TrackSelector.h"

#include <QPainter>
#include <QPaintEvent>

#include "ViewSettings.h"

using namespace stand::view;

TrackSelector::TrackSelector(ViewSettings *s, QWidget *parent) :
    QWidget(parent)
{
    _settings = NULL;
    _settingsIsDeletable = false;
    setSettings(s);
}

TrackSelector::~TrackSelector()
{
    if(_settingsIsDeletable)
    {
        delete _settings;
    }
}

void TrackSelector::releaseSettings()
{
    disconnect(this, SLOT(releaseSettings()));
    _settings = new ViewSettings(1, 16, 64, this);
    _settingsIsDeletable = true;
}

void TrackSelector::setSettings(ViewSettings *s)
{
    disconnect(this, SLOT(releaseSettings()));
    if(_settingsIsDeletable)
    {
        delete _settings;
    }
    _settings = s;
    if(s)
    {
        connect(_settings, SIGNAL(AboutToDelete()), this, SLOT(releaseSettings()));
        _settingsIsDeletable = false;
    }
    else
    {
        _settings = new ViewSettings(1, 16, 64, this);
        _settingsIsDeletable = true;
    }
    connect(_settings, SIGNAL(StateChanged()), this, SLOT(reset()));
    reset();
}

void TrackSelector::reset()
{
    setFixedHeight(_settings->noteHeight() * 1);
    update();
}

void TrackSelector::paintEvent(QPaintEvent *e)
{
    QPainter p(this);
    QFont font(p.font());
    font.setPointSize(height() - 6);
    font.setBold(true);
    p.setFont(font);
    p.fillRect(e->rect(), QColor(96, 96, 96));
    p.setPen(QColor(0, 192, 192));
    p.drawRect(-1, 0, width() + 1, height() - 1);

    for(int i = 0; i < _settings->tracks().size(); i++)
    {
        QRect r(i * _settings->beatWidth(), 0, _settings->beatWidth() + 1, _settings->noteHeight() - 1);
        p.setPen(QColor(0, 192, 192));
        p.drawRect(r);
        p.setPen(QColor(0, 255, 255));
        p.drawText(r.x() + 4, 1, _settings->beatWidth() - 4, _settings->noteHeight() - 2, Qt::AlignLeft | Qt::AlignVCenter, tr("Track") + QString::number(i));
    }
}
