#ifndef TRACKVIEW_H
#define TRACKVIEW_H

#include "AbstractPianoroll.h"

namespace stand
{
namespace model
{
class TrackItem;
class EventItem;
class SequenceModel;
class TreeItem;
}
namespace view
{

class TrackView : public AbstractPianoroll
{
    Q_OBJECT
public:
    explicit TrackView(QWidget *parent = 0);
    ~TrackView();

    //virtual void keyboardSearch(const QString &search);
    //virtual void setSelectionModel(QItemSelectionModel *selectionModel);
    //virtual int sizeHintForColumn(int column) const;
    //virtual int sizeHintForRow(int row) const;

    virtual QModelIndex indexAt(const QPoint &point) const;
    virtual void scrollTo(const QModelIndex &index, ScrollHint hint);
    virtual void setModel(QAbstractItemModel *model);
    virtual QRect visualRect(const QModelIndex &index) const;

protected:

    //virtual bool edit(const QModelIndex &index, EditTrigger trigger, QEvent *event);
    //virtual QModelIndexList selectedIndexes();
    //virtual QItemSelectionModel::SelectionFlags selectionCommand(const QModelIndex &index, const QEvent *event) const;
    //virtual void startDrag(Qt::DropActions supportedActions);
    //virtual QStyleOptionViewItem viewOptions() const;

    virtual int horizontalOffset() const;
    virtual bool isIndexHidden(const QModelIndex &index) const;
    virtual QModelIndex moveCursor(CursorAction cursorAction, Qt::KeyboardModifiers modifiers);
    virtual void setSelection(const QRect &rect, QItemSelectionModel::SelectionFlags command);
    virtual int verticalOffset() const;
    virtual QRegion visualRegionForSelection(const QItemSelection &selection) const;

    virtual void paintEvent(QPaintEvent *e);
    virtual void mousePressEvent(QMouseEvent *e);
    virtual void mouseMoveEvent(QMouseEvent *e);
    virtual void mouseReleaseEvent(QMouseEvent *e);
    virtual void showEvent(QShowEvent *e);
    virtual bool eventFilter(QObject *o, QEvent *e);

    virtual void dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight);

    virtual int length();

signals:

public slots:

protected slots:
    virtual void selectionChanged(const QItemSelection &selected, const QItemSelection &deselected);

private:
    enum ClickKind
    {
        ClickNothing = 0,
        ClickBackground,
        ClickNote,
        ClickNoteLeftEdge,
        ClickNoteRightEdge
    } _clickKind;

private:
    int _beginId(stand::model::EventItem *events, int tick, int beginNote, int endNote);
    void _drawNotes(QPainter *p, QPaintEvent *e);
    void _drawSelectionBox(QPainter *p, QPaintEvent *e);

    void _mouseDragOnBackground(QMouseEvent *e);

    int _length;
    bool _autoScroll;

    bool _isDragged;
    QPoint _leftClickedPosition;
    QPoint _leftDraggedPosition;
    QRect _previousRect;

    stand::model::SequenceModel *_model;
};

}
}

#endif // TRACKVIEW_H
