﻿#include "ViewArea.h"

#include <QResizeEvent>
#include <QPaintEvent>
#include <QPainter>

using namespace stand::view;

ViewArea::ViewArea(QWidget *parent) :
    QFrame(parent)
{
    setAutoFillBackground(true);
    QPalette p(palette());
    p.setColor(QPalette::Window, QColor(64, 64, 64));
    setPalette(p);
    QFrame *frame = new QFrame(this);
    _frameIsCreated = true;
    _frame = frame;
    frame->setFrameStyle(QFrame::Box);
    setLineWidth(1);
    //frame->setLineWidth(1);
    _frame->hide();
    _lineWidth = lineWidth();
    _x = _y = lineWidth();
    frame->setAutoFillBackground(false);
    frame->move(_x, _y);
    frame->resize(size());

    _h = _v = NoResize;
}

ViewArea::~ViewArea()
{
    delete _frame;
}

void ViewArea::setResizePolicy(ResizePolicy h, ResizePolicy v)
{
    _h = h;
    _v = v;
}

void ViewArea::addWidget(QWidget *w)
{
    if(!w)
    {
        return;
    }
    _widgets.push_back(w);
    w->setParent(this);
    w->move(_x, _y);
    w->resize(_frame->size());
    w->installEventFilter(this);
    w->show();
    _frame->raise();
    _frame->move(_x, _y);
    _frame->setAttribute(Qt::WA_TransparentForMouseEvents, true);
}

void ViewArea::clearWidgets()
{
    _widgets.clear();
}

bool ViewArea::eventFilter(QObject *o, QEvent *e)
{
    if(e->type() == QEvent::Resize)
    {
        for(int i = 0; i < _widgets.size(); i++)
        {
            if(o == _widgets[i])
            {
                if(_h == Resize)
                {
                    setMinimumWidth(_widgets[i]->minimumWidth());
                }
                if(_v == Resize)
                {
                    setMinimumHeight(_widgets[i]->minimumHeight());
                }
                break;
            }
        }
    }
    if(e->type() == QEvent::Paint)
    {
        QPaintEvent *pe = (QPaintEvent *)(e);
        for(int i = 0; i < _widgets.size(); i++)
        {
            if(_widgets[i] != o)
            {
                _widgets[i]->update(pe->rect());
            }
        }
        if(o != _frame)
        {
            _frame->update(pe->rect());
        }
    }
    return QFrame::eventFilter(o, e);
}

void ViewArea::verticalScroll(int y)
{
    _y = -y + _lineWidth;
    for(int i = 0; i < _widgets.size(); i++)
    {
        _widgets[i]->move(_widgets[i]->x(), _y);
    }
    _frame->move(_frame->x(), _y);
}

void ViewArea::horizontalScroll(int x)
{
    _x = -x + _lineWidth;
    for(int i = 0; i < _widgets.size(); i++)
    {
        _widgets[i]->move(_x, _widgets[i]->y());
    }
    _frame->move(_x, _frame->y());
}

void ViewArea::resizeEvent(QResizeEvent *e)
{
    _frame->resize(e->size());
    for(int i = 0; i < _widgets.size(); i++)
    {
        _widgets[i]->resize(e->size());
    }
}
