<?php
// vim: foldmethod=marker
/**
 *  Ethna_DB_Util.php
 *
 *  @author     Yoshinari Takaka <takaoka@beatcraf.com> 
 *  @license    http://www.opensource.org/licenses/bsd-license.php The BSD License
 *  @package    Ethna
 *  @version    $Id: 87e2830f31c01f30fcacd6a8180f29e6b18b1489 $
 */

// {{{ Ethna_DB_Util
/**
 *  データベースアクセス関連ヘルパクラス
 *
 *  @author     Yoshinari Takaka <takaoka@beatcraf.com> 
 *  @access     public
 *  @package    Ethna
 */
class Ethna_DB_Util
{
    /*
     *  データベース接続を取得します。 
     *
     *  @param $db_key  データベース接続設定キー 
     *  @return Ethna_DB データベース接続オブジェクト | エラー時は Ethna_Error
     */
    function getDB($db_key = '')
    {
        $ctl =& Ethna_Controller::getInstance();
        $backend =& $ctl->getBackend();
        return $backend->getDB($db_key);        
    }
}
// }}}

?>
