/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.ant.taskdefs;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import jp.sf.fess.ant.sax.XdocToTexParser;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;

public class XdocToTex
extends Task {
    private File destDir;
    private String encoding;
    protected Set<ResourceCollection> rcs = new LinkedHashSet<ResourceCollection>();

    public void execute() throws BuildException {
        this.validateAttributes();
        for (ResourceCollection rc : this.rcs) {
            String[] srcFiles;
            if (!(rc instanceof FileSet) || !rc.isFilesystemOnly()) continue;
            FileSet fs = (FileSet)rc;
            DirectoryScanner ds = null;
            try {
                ds = fs.getDirectoryScanner(this.getProject());
            }
            catch (BuildException e) {
                this.log("Warning: " + this.getMessage((Exception)((Object)e)), 0);
                continue;
            }
            File fromDir = fs.getDir(this.getProject());
            String[] stringArray = srcFiles = ds.getIncludedFiles();
            int n = srcFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String src = stringArray[n2];
                File srcFile = new File(fromDir, src);
                XdocToTexParser parser = new XdocToTexParser();
                parser.setTask(this);
                if (this.encoding != null) {
                    parser.setCharset(this.encoding);
                }
                parser.parse(srcFile, new File(this.destDir, srcFile.getName().replace(".xml", ".tex")));
                ++n2;
            }
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.destDir == null) {
            throw new BuildException("todir must be set.");
        }
        if (this.rcs.isEmpty()) {
            throw new BuildException("fileSet must be set.");
        }
    }

    private String getMessage(Exception ex) {
        return ex.getMessage() == null ? ex.toString() : ex.getMessage();
    }

    public void setTodir(File destDir) {
        this.destDir = destDir;
    }

    public void addFileset(FileSet set) {
        this.add((ResourceCollection)set);
    }

    public void add(ResourceCollection res) {
        this.rcs.add(res);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

