<tiles:insert template="/WEB-INF/view/common/admin/layout.jsp" flush="true">
	<tiles:put name="title"><bean:message key="labels.search_log_configuration" /></tiles:put>
	<tiles:put name="header" value="/WEB-INF/view/common/admin/header.jsp" />
	<tiles:put name="footer" value="/WEB-INF/view/common/admin/footer.jsp" />
	<tiles:put name="menu" value="/WEB-INF/view/common/admin/menu.jsp" />
	<tiles:put name="menuType" value="searchLog" />
	<tiles:put name="headerScript" type="string">
<link rel="stylesheet" href="${f:url('/css/smoothness/jquery-ui-1.8.2.searchLog.css')}" type="text/css" media="all" />
<script type="text/javascript" src="${f:url('/js/admin/jquery-ui-1.8.2.searchLog.min.js')}"></script>
<script type="text/javascript" src="${f:url('/js/admin/searchLog.js')}"></script>
	</tiles:put>
	<tiles:put name="body" type="string">

      <div id="main">

<!-- Message: BEGIN -->
<div><html:messages id="msg" message="true"><bean:write name="msg" ignore="true"/></html:messages><html:errors/></div>
<!-- Message: END -->

<!-- Search: BEGIN -->
<div class="form-table">
<s:form>
<table>
	<tbody>
		<tr>
			<td>
				<table><tbody>
					<tr>
						<th style="width:100px;"><bean:message key="labels.search_log_search_word_search"/></th>
						<td style="width:300px;"><html:text property="searchParams.searchWord" style="width:98%;"></html:text></td>
					</tr>
					<tr>
						<th rowspan="2"><bean:message key="labels.search_log_search_term"/></th>
						<td>
						<html:text property="searchParams.startDate" styleId="searchStartDate" size="10"></html:text>
						<html:select property="searchParams.startHour">
							<html:option value=""></html:option>
							<c:forEach begin="0" end="23" step="1" varStatus="status">
								<html:option value="${status.index}">${status.index}</html:option>
							</c:forEach>
						</html:select>
						:
						<html:select property="searchParams.startMin">
							<html:option value=""></html:option>
							<c:forEach begin="0" end="59" step="1" varStatus="status">
								<html:option value="${status.index}">${status.index}</html:option>
							</c:forEach>
						</html:select>
						</td>
					</tr>
					<tr>
						<td>
						<html:text property="searchParams.endDate" styleId="searchEndDate" size="10"></html:text>
						<html:select property="searchParams.endHour">
							<html:option value=""></html:option>
							<c:forEach begin="0" end="23" step="1" varStatus="status">
								<html:option value="${status.index}">${status.index}</html:option>
							</c:forEach>
						</html:select>
						:
						<html:select property="searchParams.endMin">
							<html:option value=""></html:option>
							<c:forEach begin="0" end="59" step="1" varStatus="status">
								<html:option value="${status.index}">${status.index}</html:option>
							</c:forEach>
						</html:select>
						</td>
					</tr>
					<tr>
						<th><bean:message key="labels.search_log_search_start_page"/></th>
						<td><html:checkbox property="searchParams.startPage"><bean:message key="labels.enabled"/></html:checkbox></td>
					</tr>
				</tbody></table>
			</td>
			<td>
				<input type="submit" name="search" value="<bean:message key="labels.search_log_button_search"/>"/>
				<input type="submit" name="reset" value="<bean:message key="labels.search_log_button_reset"/>"/>
			</td>
		</tr>
	</tbody>
</table>
</s:form>
</div>
<!-- Search: END -->

<div style="margin-top:5px;">
<script><!-- 
function confirmToDeleteAll() {
	if(confirm('<bean:message key="labels.search_log_delete_all_confirmation"/>')){
		return true;
	} else {
		return false;
	}
}
// -->
</script>
<s:link href="deleteall" onclick="return confirmToDeleteAll();"><bean:message key="labels.search_log_delete_all_link"/></s:link>
<s:link href="download"><bean:message key="labels.search_log_download_csv"/></s:link>
</div>

<!-- List: BEGIN -->
<div class="list-table" style="margin-top:5px;">
<table border="1">
	<thead>
		<tr>
				<th style="text-align: center;width:120px;">
				<s:link href="search?searchParams.sortField=requestedTime&searchParams.sortOrder=${searchParams.reverseSortOrder}"><bean:message key="labels.search_log_requested_time"/></s:link>
<c:if test="${searchParams.sortField=='requestedTime'}">
<c:if test="${searchParams.sortOrder=='asc'}"><bean:message key="labels.search_log_sort_up"/></c:if>
<c:if test="${searchParams.sortOrder=='desc'}"><bean:message key="labels.search_log_sort_down"/></c:if>
</c:if>
				</th>
				<th style="text-align: center;width:200px;">
				<s:link href="search?searchParams.sortField=searchWord&searchParams.sortOrder=${searchParams.reverseSortOrder}"><bean:message key="labels.search_log_search_word"/></s:link>
<c:if test="${searchParams.sortField=='searchWord'}">
<c:if test="${searchParams.sortOrder=='asc'}"><bean:message key="labels.search_log_sort_up"/></c:if>
<c:if test="${searchParams.sortOrder=='desc'}"><bean:message key="labels.search_log_sort_down"/></c:if>
</c:if>
				</th>
				<th style="text-align: center;">
				<s:link href="search?searchParams.sortField=responseTime&searchParams.sortOrder=${searchParams.reverseSortOrder}"><bean:message key="labels.search_log_response_time"/></s:link>
<c:if test="${searchParams.sortField=='responseTime'}">
<c:if test="${searchParams.sortOrder=='asc'}"><bean:message key="labels.search_log_sort_up"/></c:if>
<c:if test="${searchParams.sortOrder=='desc'}"><bean:message key="labels.search_log_sort_down"/></c:if>
</c:if>
				</th>
				<th style="text-align: center;">
				<s:link href="search?searchParams.sortField=hitCount&searchParams.sortOrder=${searchParams.reverseSortOrder}"><bean:message key="labels.search_log_hit_count"/></s:link>
<c:if test="${searchParams.sortField=='hitCount'}">
<c:if test="${searchParams.sortOrder=='asc'}"><bean:message key="labels.search_log_sort_up"/></c:if>
<c:if test="${searchParams.sortOrder=='desc'}"><bean:message key="labels.search_log_sort_down"/></c:if>
</c:if>
				</th>
			<th style="text-align: center;">&nbsp;</th>
		</tr>
	</thead>
	<tbody>
		<c:forEach var="data" varStatus="s" items="${searchLogItems}">
		<tr class="${s.index % 2 == 0 ? 'row1' : 'row2'}">
								<td>${f:h(data.requestedTimeForList)}</td>
								<td>${f:h(data.searchWord)}</td>
								<td style="text-align:right;">${f:h(data.responseTime)}</td>
								<td style="text-align:right;">${f:h(data.hitCount)}</td>
			<td align="center">
				<s:link href="confirmpage/4/${f:u(data.id)}"><bean:message key="labels.search_log_link_details"/></s:link>
				<s:link href="deletepage/3/${f:u(data.id)}"><bean:message key="labels.search_log_link_delete"/></s:link>
			</td>
		</tr>
		</c:forEach>
	</tbody>
</table>
<!-- Page Navigation: BEGIN -->
<div>
	<span>
		<c:if test="${searchLogPager.existPrePage}">
		<s:link href="list/${searchLogPager.currentPageNumber - 1}"><bean:message key="labels.crud_link_prev_page"/></s:link>
		</c:if>
	</span>
	<span>
		<c:forEach var="p" varStatus="s" items="${searchLogPager.pageNumberList}">
		<span>
			<c:if test="${p == searchLogPager.currentPageNumber}">
			${p}
			</c:if>
			<c:if test="${p != searchLogPager.currentPageNumber}">
			<s:link href="list/${p}">${p}</s:link>
			</c:if>
		</span>
		</c:forEach>
	</span>
	<span>
		<c:if test="${searchLogPager.existNextPage}">
		<s:link href="list/${searchLogPager.currentPageNumber + 1}"><bean:message key="labels.crud_link_next_page"/></s:link>
		</c:if>
	</span>
</div>
<div>
	<span>
		${searchLogPager.currentPageNumber}/${searchLogPager.allPageCount} (${searchLogPager.allRecordCount})
	</span>
</div>
<!-- Page Navigation: END -->
</div>
<!-- List: END -->

</div>

	</tiles:put>
</tiles:insert>
