/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.cbean.cq.bs;

import java.util.Map;

import jp.sf.fess.db.cbean.WebCrawlingConfigCB;
import jp.sf.fess.db.cbean.cq.RequestHeaderCQ;
import jp.sf.fess.db.cbean.cq.WebAuthenticationCQ;
import jp.sf.fess.db.cbean.cq.WebConfigToBrowserTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.WebConfigToLabelTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.WebConfigToRoleTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.WebCrawlingConfigCQ;
import jp.sf.fess.db.cbean.cq.ciq.WebCrawlingConfigCIQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;

/**
 * The base condition-query of WEB_CRAWLING_CONFIG.
 * @author DBFlute(AutoGenerator)
 */
public class BsWebCrawlingConfigCQ extends AbstractBsWebCrawlingConfigCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected WebCrawlingConfigCIQ _inlineQuery;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public BsWebCrawlingConfigCQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                              Inline
    //                                                                              ======
    /**
     * Prepare inline query. <br />
     * {select ... from ... left outer join (select * from WEB_CRAWLING_CONFIG) where abc = [abc] ...}
     * @return Inline query. (NotNull)
     */
    public WebCrawlingConfigCIQ inline() {
        if (_inlineQuery == null) {
            _inlineQuery = new WebCrawlingConfigCIQ(getChildQuery(),
                    getSqlClause(), getAliasName(), getNestLevel(), this);
        }
        _inlineQuery.xsetOnClauseInline(false);
        return _inlineQuery;
    }

    /**
     * Prepare on-clause query. <br />
     * {select ... from ... left outer join WEB_CRAWLING_CONFIG on ... and abc = [abc] ...}
     * @return On-clause query. (NotNull)
     */
    public WebCrawlingConfigCIQ on() {
        if (isBaseQuery(this)) {
            throw new UnsupportedOperationException(
                    "Unsupported on-clause for local table!");
        }
        WebCrawlingConfigCIQ inlineQuery = inline();
        inlineQuery.xsetOnClauseInline(true);
        return inlineQuery;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    protected ConditionValue _id;

    public ConditionValue getId() {
        if (_id == null) {
            _id = nCV();
        }
        return _id;
    }

    protected ConditionValue getCValueId() {
        return getId();
    }

    protected Map<String, RequestHeaderCQ> _id_InScopeSubQuery_RequestHeaderListMap;

    public Map<String, RequestHeaderCQ> getId_InScopeSubQuery_RequestHeaderList() {
        return _id_InScopeSubQuery_RequestHeaderListMap;
    }

    public String keepId_InScopeSubQuery_RequestHeaderList(
            RequestHeaderCQ subQuery) {
        if (_id_InScopeSubQuery_RequestHeaderListMap == null) {
            _id_InScopeSubQuery_RequestHeaderListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeSubQuery_RequestHeaderListMap.size() + 1);
        _id_InScopeSubQuery_RequestHeaderListMap.put(key, subQuery);
        return "id_InScopeSubQuery_RequestHeaderList." + key;
    }

    protected Map<String, WebAuthenticationCQ> _id_InScopeSubQuery_WebAuthenticationListMap;

    public Map<String, WebAuthenticationCQ> getId_InScopeSubQuery_WebAuthenticationList() {
        return _id_InScopeSubQuery_WebAuthenticationListMap;
    }

    public String keepId_InScopeSubQuery_WebAuthenticationList(
            WebAuthenticationCQ subQuery) {
        if (_id_InScopeSubQuery_WebAuthenticationListMap == null) {
            _id_InScopeSubQuery_WebAuthenticationListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeSubQuery_WebAuthenticationListMap.size() + 1);
        _id_InScopeSubQuery_WebAuthenticationListMap.put(key, subQuery);
        return "id_InScopeSubQuery_WebAuthenticationList." + key;
    }

    protected Map<String, WebConfigToBrowserTypeMappingCQ> _id_InScopeSubQuery_WebConfigToBrowserTypeMappingListMap;

    public Map<String, WebConfigToBrowserTypeMappingCQ> getId_InScopeSubQuery_WebConfigToBrowserTypeMappingList() {
        return _id_InScopeSubQuery_WebConfigToBrowserTypeMappingListMap;
    }

    public String keepId_InScopeSubQuery_WebConfigToBrowserTypeMappingList(
            WebConfigToBrowserTypeMappingCQ subQuery) {
        if (_id_InScopeSubQuery_WebConfigToBrowserTypeMappingListMap == null) {
            _id_InScopeSubQuery_WebConfigToBrowserTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeSubQuery_WebConfigToBrowserTypeMappingListMap
                        .size() + 1);
        _id_InScopeSubQuery_WebConfigToBrowserTypeMappingListMap.put(key,
                subQuery);
        return "id_InScopeSubQuery_WebConfigToBrowserTypeMappingList." + key;
    }

    protected Map<String, WebConfigToLabelTypeMappingCQ> _id_InScopeSubQuery_WebConfigToLabelTypeMappingListMap;

    public Map<String, WebConfigToLabelTypeMappingCQ> getId_InScopeSubQuery_WebConfigToLabelTypeMappingList() {
        return _id_InScopeSubQuery_WebConfigToLabelTypeMappingListMap;
    }

    public String keepId_InScopeSubQuery_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery) {
        if (_id_InScopeSubQuery_WebConfigToLabelTypeMappingListMap == null) {
            _id_InScopeSubQuery_WebConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeSubQuery_WebConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_InScopeSubQuery_WebConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_InScopeSubQuery_WebConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, WebConfigToRoleTypeMappingCQ> _id_InScopeSubQuery_WebConfigToRoleTypeMappingListMap;

    public Map<String, WebConfigToRoleTypeMappingCQ> getId_InScopeSubQuery_WebConfigToRoleTypeMappingList() {
        return _id_InScopeSubQuery_WebConfigToRoleTypeMappingListMap;
    }

    public String keepId_InScopeSubQuery_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery) {
        if (_id_InScopeSubQuery_WebConfigToRoleTypeMappingListMap == null) {
            _id_InScopeSubQuery_WebConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeSubQuery_WebConfigToRoleTypeMappingListMap.size() + 1);
        _id_InScopeSubQuery_WebConfigToRoleTypeMappingListMap
                .put(key, subQuery);
        return "id_InScopeSubQuery_WebConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, RequestHeaderCQ> _id_NotInScopeSubQuery_RequestHeaderListMap;

    public Map<String, RequestHeaderCQ> getId_NotInScopeSubQuery_RequestHeaderList() {
        return _id_NotInScopeSubQuery_RequestHeaderListMap;
    }

    public String keepId_NotInScopeSubQuery_RequestHeaderList(
            RequestHeaderCQ subQuery) {
        if (_id_NotInScopeSubQuery_RequestHeaderListMap == null) {
            _id_NotInScopeSubQuery_RequestHeaderListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeSubQuery_RequestHeaderListMap.size() + 1);
        _id_NotInScopeSubQuery_RequestHeaderListMap.put(key, subQuery);
        return "id_NotInScopeSubQuery_RequestHeaderList." + key;
    }

    protected Map<String, WebAuthenticationCQ> _id_NotInScopeSubQuery_WebAuthenticationListMap;

    public Map<String, WebAuthenticationCQ> getId_NotInScopeSubQuery_WebAuthenticationList() {
        return _id_NotInScopeSubQuery_WebAuthenticationListMap;
    }

    public String keepId_NotInScopeSubQuery_WebAuthenticationList(
            WebAuthenticationCQ subQuery) {
        if (_id_NotInScopeSubQuery_WebAuthenticationListMap == null) {
            _id_NotInScopeSubQuery_WebAuthenticationListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeSubQuery_WebAuthenticationListMap.size() + 1);
        _id_NotInScopeSubQuery_WebAuthenticationListMap.put(key, subQuery);
        return "id_NotInScopeSubQuery_WebAuthenticationList." + key;
    }

    protected Map<String, WebConfigToBrowserTypeMappingCQ> _id_NotInScopeSubQuery_WebConfigToBrowserTypeMappingListMap;

    public Map<String, WebConfigToBrowserTypeMappingCQ> getId_NotInScopeSubQuery_WebConfigToBrowserTypeMappingList() {
        return _id_NotInScopeSubQuery_WebConfigToBrowserTypeMappingListMap;
    }

    public String keepId_NotInScopeSubQuery_WebConfigToBrowserTypeMappingList(
            WebConfigToBrowserTypeMappingCQ subQuery) {
        if (_id_NotInScopeSubQuery_WebConfigToBrowserTypeMappingListMap == null) {
            _id_NotInScopeSubQuery_WebConfigToBrowserTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeSubQuery_WebConfigToBrowserTypeMappingListMap
                        .size() + 1);
        _id_NotInScopeSubQuery_WebConfigToBrowserTypeMappingListMap.put(key,
                subQuery);
        return "id_NotInScopeSubQuery_WebConfigToBrowserTypeMappingList." + key;
    }

    protected Map<String, WebConfigToLabelTypeMappingCQ> _id_NotInScopeSubQuery_WebConfigToLabelTypeMappingListMap;

    public Map<String, WebConfigToLabelTypeMappingCQ> getId_NotInScopeSubQuery_WebConfigToLabelTypeMappingList() {
        return _id_NotInScopeSubQuery_WebConfigToLabelTypeMappingListMap;
    }

    public String keepId_NotInScopeSubQuery_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery) {
        if (_id_NotInScopeSubQuery_WebConfigToLabelTypeMappingListMap == null) {
            _id_NotInScopeSubQuery_WebConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeSubQuery_WebConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_NotInScopeSubQuery_WebConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_NotInScopeSubQuery_WebConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, WebConfigToRoleTypeMappingCQ> _id_NotInScopeSubQuery_WebConfigToRoleTypeMappingListMap;

    public Map<String, WebConfigToRoleTypeMappingCQ> getId_NotInScopeSubQuery_WebConfigToRoleTypeMappingList() {
        return _id_NotInScopeSubQuery_WebConfigToRoleTypeMappingListMap;
    }

    public String keepId_NotInScopeSubQuery_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery) {
        if (_id_NotInScopeSubQuery_WebConfigToRoleTypeMappingListMap == null) {
            _id_NotInScopeSubQuery_WebConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeSubQuery_WebConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_NotInScopeSubQuery_WebConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_NotInScopeSubQuery_WebConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, RequestHeaderCQ> _id_ExistsSubQuery_RequestHeaderListMap;

    public Map<String, RequestHeaderCQ> getId_ExistsSubQuery_RequestHeaderList() {
        return _id_ExistsSubQuery_RequestHeaderListMap;
    }

    public String keepId_ExistsSubQuery_RequestHeaderList(
            RequestHeaderCQ subQuery) {
        if (_id_ExistsSubQuery_RequestHeaderListMap == null) {
            _id_ExistsSubQuery_RequestHeaderListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsSubQuery_RequestHeaderListMap.size() + 1);
        _id_ExistsSubQuery_RequestHeaderListMap.put(key, subQuery);
        return "id_ExistsSubQuery_RequestHeaderList." + key;
    }

    protected Map<String, WebAuthenticationCQ> _id_ExistsSubQuery_WebAuthenticationListMap;

    public Map<String, WebAuthenticationCQ> getId_ExistsSubQuery_WebAuthenticationList() {
        return _id_ExistsSubQuery_WebAuthenticationListMap;
    }

    public String keepId_ExistsSubQuery_WebAuthenticationList(
            WebAuthenticationCQ subQuery) {
        if (_id_ExistsSubQuery_WebAuthenticationListMap == null) {
            _id_ExistsSubQuery_WebAuthenticationListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsSubQuery_WebAuthenticationListMap.size() + 1);
        _id_ExistsSubQuery_WebAuthenticationListMap.put(key, subQuery);
        return "id_ExistsSubQuery_WebAuthenticationList." + key;
    }

    protected Map<String, WebConfigToBrowserTypeMappingCQ> _id_ExistsSubQuery_WebConfigToBrowserTypeMappingListMap;

    public Map<String, WebConfigToBrowserTypeMappingCQ> getId_ExistsSubQuery_WebConfigToBrowserTypeMappingList() {
        return _id_ExistsSubQuery_WebConfigToBrowserTypeMappingListMap;
    }

    public String keepId_ExistsSubQuery_WebConfigToBrowserTypeMappingList(
            WebConfigToBrowserTypeMappingCQ subQuery) {
        if (_id_ExistsSubQuery_WebConfigToBrowserTypeMappingListMap == null) {
            _id_ExistsSubQuery_WebConfigToBrowserTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsSubQuery_WebConfigToBrowserTypeMappingListMap
                        .size() + 1);
        _id_ExistsSubQuery_WebConfigToBrowserTypeMappingListMap.put(key,
                subQuery);
        return "id_ExistsSubQuery_WebConfigToBrowserTypeMappingList." + key;
    }

    protected Map<String, WebConfigToLabelTypeMappingCQ> _id_ExistsSubQuery_WebConfigToLabelTypeMappingListMap;

    public Map<String, WebConfigToLabelTypeMappingCQ> getId_ExistsSubQuery_WebConfigToLabelTypeMappingList() {
        return _id_ExistsSubQuery_WebConfigToLabelTypeMappingListMap;
    }

    public String keepId_ExistsSubQuery_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery) {
        if (_id_ExistsSubQuery_WebConfigToLabelTypeMappingListMap == null) {
            _id_ExistsSubQuery_WebConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsSubQuery_WebConfigToLabelTypeMappingListMap.size() + 1);
        _id_ExistsSubQuery_WebConfigToLabelTypeMappingListMap
                .put(key, subQuery);
        return "id_ExistsSubQuery_WebConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, WebConfigToRoleTypeMappingCQ> _id_ExistsSubQuery_WebConfigToRoleTypeMappingListMap;

    public Map<String, WebConfigToRoleTypeMappingCQ> getId_ExistsSubQuery_WebConfigToRoleTypeMappingList() {
        return _id_ExistsSubQuery_WebConfigToRoleTypeMappingListMap;
    }

    public String keepId_ExistsSubQuery_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery) {
        if (_id_ExistsSubQuery_WebConfigToRoleTypeMappingListMap == null) {
            _id_ExistsSubQuery_WebConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsSubQuery_WebConfigToRoleTypeMappingListMap.size() + 1);
        _id_ExistsSubQuery_WebConfigToRoleTypeMappingListMap.put(key, subQuery);
        return "id_ExistsSubQuery_WebConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, RequestHeaderCQ> _id_NotExistsSubQuery_RequestHeaderListMap;

    public Map<String, RequestHeaderCQ> getId_NotExistsSubQuery_RequestHeaderList() {
        return _id_NotExistsSubQuery_RequestHeaderListMap;
    }

    public String keepId_NotExistsSubQuery_RequestHeaderList(
            RequestHeaderCQ subQuery) {
        if (_id_NotExistsSubQuery_RequestHeaderListMap == null) {
            _id_NotExistsSubQuery_RequestHeaderListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsSubQuery_RequestHeaderListMap.size() + 1);
        _id_NotExistsSubQuery_RequestHeaderListMap.put(key, subQuery);
        return "id_NotExistsSubQuery_RequestHeaderList." + key;
    }

    protected Map<String, WebAuthenticationCQ> _id_NotExistsSubQuery_WebAuthenticationListMap;

    public Map<String, WebAuthenticationCQ> getId_NotExistsSubQuery_WebAuthenticationList() {
        return _id_NotExistsSubQuery_WebAuthenticationListMap;
    }

    public String keepId_NotExistsSubQuery_WebAuthenticationList(
            WebAuthenticationCQ subQuery) {
        if (_id_NotExistsSubQuery_WebAuthenticationListMap == null) {
            _id_NotExistsSubQuery_WebAuthenticationListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsSubQuery_WebAuthenticationListMap.size() + 1);
        _id_NotExistsSubQuery_WebAuthenticationListMap.put(key, subQuery);
        return "id_NotExistsSubQuery_WebAuthenticationList." + key;
    }

    protected Map<String, WebConfigToBrowserTypeMappingCQ> _id_NotExistsSubQuery_WebConfigToBrowserTypeMappingListMap;

    public Map<String, WebConfigToBrowserTypeMappingCQ> getId_NotExistsSubQuery_WebConfigToBrowserTypeMappingList() {
        return _id_NotExistsSubQuery_WebConfigToBrowserTypeMappingListMap;
    }

    public String keepId_NotExistsSubQuery_WebConfigToBrowserTypeMappingList(
            WebConfigToBrowserTypeMappingCQ subQuery) {
        if (_id_NotExistsSubQuery_WebConfigToBrowserTypeMappingListMap == null) {
            _id_NotExistsSubQuery_WebConfigToBrowserTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsSubQuery_WebConfigToBrowserTypeMappingListMap
                        .size() + 1);
        _id_NotExistsSubQuery_WebConfigToBrowserTypeMappingListMap.put(key,
                subQuery);
        return "id_NotExistsSubQuery_WebConfigToBrowserTypeMappingList." + key;
    }

    protected Map<String, WebConfigToLabelTypeMappingCQ> _id_NotExistsSubQuery_WebConfigToLabelTypeMappingListMap;

    public Map<String, WebConfigToLabelTypeMappingCQ> getId_NotExistsSubQuery_WebConfigToLabelTypeMappingList() {
        return _id_NotExistsSubQuery_WebConfigToLabelTypeMappingListMap;
    }

    public String keepId_NotExistsSubQuery_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery) {
        if (_id_NotExistsSubQuery_WebConfigToLabelTypeMappingListMap == null) {
            _id_NotExistsSubQuery_WebConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsSubQuery_WebConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_NotExistsSubQuery_WebConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_NotExistsSubQuery_WebConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, WebConfigToRoleTypeMappingCQ> _id_NotExistsSubQuery_WebConfigToRoleTypeMappingListMap;

    public Map<String, WebConfigToRoleTypeMappingCQ> getId_NotExistsSubQuery_WebConfigToRoleTypeMappingList() {
        return _id_NotExistsSubQuery_WebConfigToRoleTypeMappingListMap;
    }

    public String keepId_NotExistsSubQuery_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery) {
        if (_id_NotExistsSubQuery_WebConfigToRoleTypeMappingListMap == null) {
            _id_NotExistsSubQuery_WebConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsSubQuery_WebConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_NotExistsSubQuery_WebConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_NotExistsSubQuery_WebConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, RequestHeaderCQ> _id_SpecifyDerivedReferrer_RequestHeaderListMap;

    public Map<String, RequestHeaderCQ> getId_SpecifyDerivedReferrer_RequestHeaderList() {
        return _id_SpecifyDerivedReferrer_RequestHeaderListMap;
    }

    public String keepId_SpecifyDerivedReferrer_RequestHeaderList(
            RequestHeaderCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_RequestHeaderListMap == null) {
            _id_SpecifyDerivedReferrer_RequestHeaderListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_RequestHeaderListMap.size() + 1);
        _id_SpecifyDerivedReferrer_RequestHeaderListMap.put(key, subQuery);
        return "id_SpecifyDerivedReferrer_RequestHeaderList." + key;
    }

    protected Map<String, WebAuthenticationCQ> _id_SpecifyDerivedReferrer_WebAuthenticationListMap;

    public Map<String, WebAuthenticationCQ> getId_SpecifyDerivedReferrer_WebAuthenticationList() {
        return _id_SpecifyDerivedReferrer_WebAuthenticationListMap;
    }

    public String keepId_SpecifyDerivedReferrer_WebAuthenticationList(
            WebAuthenticationCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_WebAuthenticationListMap == null) {
            _id_SpecifyDerivedReferrer_WebAuthenticationListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_WebAuthenticationListMap.size() + 1);
        _id_SpecifyDerivedReferrer_WebAuthenticationListMap.put(key, subQuery);
        return "id_SpecifyDerivedReferrer_WebAuthenticationList." + key;
    }

    protected Map<String, WebConfigToBrowserTypeMappingCQ> _id_SpecifyDerivedReferrer_WebConfigToBrowserTypeMappingListMap;

    public Map<String, WebConfigToBrowserTypeMappingCQ> getId_SpecifyDerivedReferrer_WebConfigToBrowserTypeMappingList() {
        return _id_SpecifyDerivedReferrer_WebConfigToBrowserTypeMappingListMap;
    }

    public String keepId_SpecifyDerivedReferrer_WebConfigToBrowserTypeMappingList(
            WebConfigToBrowserTypeMappingCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_WebConfigToBrowserTypeMappingListMap == null) {
            _id_SpecifyDerivedReferrer_WebConfigToBrowserTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_WebConfigToBrowserTypeMappingListMap
                        .size() + 1);
        _id_SpecifyDerivedReferrer_WebConfigToBrowserTypeMappingListMap.put(
                key, subQuery);
        return "id_SpecifyDerivedReferrer_WebConfigToBrowserTypeMappingList."
                + key;
    }

    protected Map<String, WebConfigToLabelTypeMappingCQ> _id_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingListMap;

    public Map<String, WebConfigToLabelTypeMappingCQ> getId_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingList() {
        return _id_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingListMap;
    }

    public String keepId_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingListMap == null) {
            _id_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingList."
                + key;
    }

    protected Map<String, WebConfigToRoleTypeMappingCQ> _id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingListMap;

    public Map<String, WebConfigToRoleTypeMappingCQ> getId_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingList() {
        return _id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingListMap;
    }

    public String keepId_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingListMap == null) {
            _id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingList."
                + key;
    }

    protected Map<String, RequestHeaderCQ> _id_QueryDerivedReferrer_RequestHeaderListMap;

    public Map<String, RequestHeaderCQ> getId_QueryDerivedReferrer_RequestHeaderList() {
        return _id_QueryDerivedReferrer_RequestHeaderListMap;
    }

    public String keepId_QueryDerivedReferrer_RequestHeaderList(
            RequestHeaderCQ subQuery) {
        if (_id_QueryDerivedReferrer_RequestHeaderListMap == null) {
            _id_QueryDerivedReferrer_RequestHeaderListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_RequestHeaderListMap.size() + 1);
        _id_QueryDerivedReferrer_RequestHeaderListMap.put(key, subQuery);
        return "id_QueryDerivedReferrer_RequestHeaderList." + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_RequestHeaderListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_RequestHeaderListParameter() {
        return _id_QueryDerivedReferrer_RequestHeaderListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_RequestHeaderListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_RequestHeaderListParameterMap == null) {
            _id_QueryDerivedReferrer_RequestHeaderListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_RequestHeaderListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_RequestHeaderListParameterMap.put(key,
                parameterValue);
        return "id_QueryDerivedReferrer_RequestHeaderListParameter." + key;
    }

    protected Map<String, WebAuthenticationCQ> _id_QueryDerivedReferrer_WebAuthenticationListMap;

    public Map<String, WebAuthenticationCQ> getId_QueryDerivedReferrer_WebAuthenticationList() {
        return _id_QueryDerivedReferrer_WebAuthenticationListMap;
    }

    public String keepId_QueryDerivedReferrer_WebAuthenticationList(
            WebAuthenticationCQ subQuery) {
        if (_id_QueryDerivedReferrer_WebAuthenticationListMap == null) {
            _id_QueryDerivedReferrer_WebAuthenticationListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_WebAuthenticationListMap.size() + 1);
        _id_QueryDerivedReferrer_WebAuthenticationListMap.put(key, subQuery);
        return "id_QueryDerivedReferrer_WebAuthenticationList." + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_WebAuthenticationListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_WebAuthenticationListParameter() {
        return _id_QueryDerivedReferrer_WebAuthenticationListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_WebAuthenticationListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_WebAuthenticationListParameterMap == null) {
            _id_QueryDerivedReferrer_WebAuthenticationListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_WebAuthenticationListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_WebAuthenticationListParameterMap.put(key,
                parameterValue);
        return "id_QueryDerivedReferrer_WebAuthenticationListParameter." + key;
    }

    protected Map<String, WebConfigToBrowserTypeMappingCQ> _id_QueryDerivedReferrer_WebConfigToBrowserTypeMappingListMap;

    public Map<String, WebConfigToBrowserTypeMappingCQ> getId_QueryDerivedReferrer_WebConfigToBrowserTypeMappingList() {
        return _id_QueryDerivedReferrer_WebConfigToBrowserTypeMappingListMap;
    }

    public String keepId_QueryDerivedReferrer_WebConfigToBrowserTypeMappingList(
            WebConfigToBrowserTypeMappingCQ subQuery) {
        if (_id_QueryDerivedReferrer_WebConfigToBrowserTypeMappingListMap == null) {
            _id_QueryDerivedReferrer_WebConfigToBrowserTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_WebConfigToBrowserTypeMappingListMap
                        .size() + 1);
        _id_QueryDerivedReferrer_WebConfigToBrowserTypeMappingListMap.put(key,
                subQuery);
        return "id_QueryDerivedReferrer_WebConfigToBrowserTypeMappingList."
                + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_WebConfigToBrowserTypeMappingListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_WebConfigToBrowserTypeMappingListParameter() {
        return _id_QueryDerivedReferrer_WebConfigToBrowserTypeMappingListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_WebConfigToBrowserTypeMappingListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_WebConfigToBrowserTypeMappingListParameterMap == null) {
            _id_QueryDerivedReferrer_WebConfigToBrowserTypeMappingListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_WebConfigToBrowserTypeMappingListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_WebConfigToBrowserTypeMappingListParameterMap
                .put(key, parameterValue);
        return "id_QueryDerivedReferrer_WebConfigToBrowserTypeMappingListParameter."
                + key;
    }

    protected Map<String, WebConfigToLabelTypeMappingCQ> _id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListMap;

    public Map<String, WebConfigToLabelTypeMappingCQ> getId_QueryDerivedReferrer_WebConfigToLabelTypeMappingList() {
        return _id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListMap;
    }

    public String keepId_QueryDerivedReferrer_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery) {
        if (_id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListMap == null) {
            _id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListMap
                        .size() + 1);
        _id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListMap.put(key,
                subQuery);
        return "id_QueryDerivedReferrer_WebConfigToLabelTypeMappingList." + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameter() {
        return _id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameterMap == null) {
            _id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameterMap
                .put(key, parameterValue);
        return "id_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameter."
                + key;
    }

    protected Map<String, WebConfigToRoleTypeMappingCQ> _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListMap;

    public Map<String, WebConfigToRoleTypeMappingCQ> getId_QueryDerivedReferrer_WebConfigToRoleTypeMappingList() {
        return _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListMap;
    }

    public String keepId_QueryDerivedReferrer_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery) {
        if (_id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListMap == null) {
            _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_QueryDerivedReferrer_WebConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameter() {
        return _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameterMap == null) {
            _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameterMap
                .put(key, parameterValue);
        return "id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameter."
                + key;
    }

    public BsWebCrawlingConfigCQ addOrderBy_Id_Asc() {
        regOBA("ID");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_Id_Desc() {
        regOBD("ID");
        return this;
    }

    protected ConditionValue _name;

    public ConditionValue getName() {
        if (_name == null) {
            _name = nCV();
        }
        return _name;
    }

    protected ConditionValue getCValueName() {
        return getName();
    }

    public BsWebCrawlingConfigCQ addOrderBy_Name_Asc() {
        regOBA("NAME");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_Name_Desc() {
        regOBD("NAME");
        return this;
    }

    protected ConditionValue _urls;

    public ConditionValue getUrls() {
        if (_urls == null) {
            _urls = nCV();
        }
        return _urls;
    }

    protected ConditionValue getCValueUrls() {
        return getUrls();
    }

    public BsWebCrawlingConfigCQ addOrderBy_Urls_Asc() {
        regOBA("URLS");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_Urls_Desc() {
        regOBD("URLS");
        return this;
    }

    protected ConditionValue _includedUrls;

    public ConditionValue getIncludedUrls() {
        if (_includedUrls == null) {
            _includedUrls = nCV();
        }
        return _includedUrls;
    }

    protected ConditionValue getCValueIncludedUrls() {
        return getIncludedUrls();
    }

    public BsWebCrawlingConfigCQ addOrderBy_IncludedUrls_Asc() {
        regOBA("INCLUDED_URLS");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_IncludedUrls_Desc() {
        regOBD("INCLUDED_URLS");
        return this;
    }

    protected ConditionValue _excludedUrls;

    public ConditionValue getExcludedUrls() {
        if (_excludedUrls == null) {
            _excludedUrls = nCV();
        }
        return _excludedUrls;
    }

    protected ConditionValue getCValueExcludedUrls() {
        return getExcludedUrls();
    }

    public BsWebCrawlingConfigCQ addOrderBy_ExcludedUrls_Asc() {
        regOBA("EXCLUDED_URLS");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_ExcludedUrls_Desc() {
        regOBD("EXCLUDED_URLS");
        return this;
    }

    protected ConditionValue _includedDocUrls;

    public ConditionValue getIncludedDocUrls() {
        if (_includedDocUrls == null) {
            _includedDocUrls = nCV();
        }
        return _includedDocUrls;
    }

    protected ConditionValue getCValueIncludedDocUrls() {
        return getIncludedDocUrls();
    }

    public BsWebCrawlingConfigCQ addOrderBy_IncludedDocUrls_Asc() {
        regOBA("INCLUDED_DOC_URLS");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_IncludedDocUrls_Desc() {
        regOBD("INCLUDED_DOC_URLS");
        return this;
    }

    protected ConditionValue _excludedDocUrls;

    public ConditionValue getExcludedDocUrls() {
        if (_excludedDocUrls == null) {
            _excludedDocUrls = nCV();
        }
        return _excludedDocUrls;
    }

    protected ConditionValue getCValueExcludedDocUrls() {
        return getExcludedDocUrls();
    }

    public BsWebCrawlingConfigCQ addOrderBy_ExcludedDocUrls_Asc() {
        regOBA("EXCLUDED_DOC_URLS");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_ExcludedDocUrls_Desc() {
        regOBD("EXCLUDED_DOC_URLS");
        return this;
    }

    protected ConditionValue _depth;

    public ConditionValue getDepth() {
        if (_depth == null) {
            _depth = nCV();
        }
        return _depth;
    }

    protected ConditionValue getCValueDepth() {
        return getDepth();
    }

    public BsWebCrawlingConfigCQ addOrderBy_Depth_Asc() {
        regOBA("DEPTH");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_Depth_Desc() {
        regOBD("DEPTH");
        return this;
    }

    protected ConditionValue _maxAccessCount;

    public ConditionValue getMaxAccessCount() {
        if (_maxAccessCount == null) {
            _maxAccessCount = nCV();
        }
        return _maxAccessCount;
    }

    protected ConditionValue getCValueMaxAccessCount() {
        return getMaxAccessCount();
    }

    public BsWebCrawlingConfigCQ addOrderBy_MaxAccessCount_Asc() {
        regOBA("MAX_ACCESS_COUNT");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_MaxAccessCount_Desc() {
        regOBD("MAX_ACCESS_COUNT");
        return this;
    }

    protected ConditionValue _userAgent;

    public ConditionValue getUserAgent() {
        if (_userAgent == null) {
            _userAgent = nCV();
        }
        return _userAgent;
    }

    protected ConditionValue getCValueUserAgent() {
        return getUserAgent();
    }

    public BsWebCrawlingConfigCQ addOrderBy_UserAgent_Asc() {
        regOBA("USER_AGENT");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_UserAgent_Desc() {
        regOBD("USER_AGENT");
        return this;
    }

    protected ConditionValue _numOfThread;

    public ConditionValue getNumOfThread() {
        if (_numOfThread == null) {
            _numOfThread = nCV();
        }
        return _numOfThread;
    }

    protected ConditionValue getCValueNumOfThread() {
        return getNumOfThread();
    }

    public BsWebCrawlingConfigCQ addOrderBy_NumOfThread_Asc() {
        regOBA("NUM_OF_THREAD");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_NumOfThread_Desc() {
        regOBD("NUM_OF_THREAD");
        return this;
    }

    protected ConditionValue _intervalTime;

    public ConditionValue getIntervalTime() {
        if (_intervalTime == null) {
            _intervalTime = nCV();
        }
        return _intervalTime;
    }

    protected ConditionValue getCValueIntervalTime() {
        return getIntervalTime();
    }

    public BsWebCrawlingConfigCQ addOrderBy_IntervalTime_Asc() {
        regOBA("INTERVAL_TIME");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_IntervalTime_Desc() {
        regOBD("INTERVAL_TIME");
        return this;
    }

    protected ConditionValue _boost;

    public ConditionValue getBoost() {
        if (_boost == null) {
            _boost = nCV();
        }
        return _boost;
    }

    protected ConditionValue getCValueBoost() {
        return getBoost();
    }

    public BsWebCrawlingConfigCQ addOrderBy_Boost_Asc() {
        regOBA("BOOST");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_Boost_Desc() {
        regOBD("BOOST");
        return this;
    }

    protected ConditionValue _available;

    public ConditionValue getAvailable() {
        if (_available == null) {
            _available = nCV();
        }
        return _available;
    }

    protected ConditionValue getCValueAvailable() {
        return getAvailable();
    }

    public BsWebCrawlingConfigCQ addOrderBy_Available_Asc() {
        regOBA("AVAILABLE");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_Available_Desc() {
        regOBD("AVAILABLE");
        return this;
    }

    protected ConditionValue _sortOrder;

    public ConditionValue getSortOrder() {
        if (_sortOrder == null) {
            _sortOrder = nCV();
        }
        return _sortOrder;
    }

    protected ConditionValue getCValueSortOrder() {
        return getSortOrder();
    }

    public BsWebCrawlingConfigCQ addOrderBy_SortOrder_Asc() {
        regOBA("SORT_ORDER");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_SortOrder_Desc() {
        regOBD("SORT_ORDER");
        return this;
    }

    protected ConditionValue _createdBy;

    public ConditionValue getCreatedBy() {
        if (_createdBy == null) {
            _createdBy = nCV();
        }
        return _createdBy;
    }

    protected ConditionValue getCValueCreatedBy() {
        return getCreatedBy();
    }

    public BsWebCrawlingConfigCQ addOrderBy_CreatedBy_Asc() {
        regOBA("CREATED_BY");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_CreatedBy_Desc() {
        regOBD("CREATED_BY");
        return this;
    }

    protected ConditionValue _createdTime;

    public ConditionValue getCreatedTime() {
        if (_createdTime == null) {
            _createdTime = nCV();
        }
        return _createdTime;
    }

    protected ConditionValue getCValueCreatedTime() {
        return getCreatedTime();
    }

    public BsWebCrawlingConfigCQ addOrderBy_CreatedTime_Asc() {
        regOBA("CREATED_TIME");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_CreatedTime_Desc() {
        regOBD("CREATED_TIME");
        return this;
    }

    protected ConditionValue _updatedBy;

    public ConditionValue getUpdatedBy() {
        if (_updatedBy == null) {
            _updatedBy = nCV();
        }
        return _updatedBy;
    }

    protected ConditionValue getCValueUpdatedBy() {
        return getUpdatedBy();
    }

    public BsWebCrawlingConfigCQ addOrderBy_UpdatedBy_Asc() {
        regOBA("UPDATED_BY");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_UpdatedBy_Desc() {
        regOBD("UPDATED_BY");
        return this;
    }

    protected ConditionValue _updatedTime;

    public ConditionValue getUpdatedTime() {
        if (_updatedTime == null) {
            _updatedTime = nCV();
        }
        return _updatedTime;
    }

    protected ConditionValue getCValueUpdatedTime() {
        return getUpdatedTime();
    }

    public BsWebCrawlingConfigCQ addOrderBy_UpdatedTime_Asc() {
        regOBA("UPDATED_TIME");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_UpdatedTime_Desc() {
        regOBD("UPDATED_TIME");
        return this;
    }

    protected ConditionValue _deletedBy;

    public ConditionValue getDeletedBy() {
        if (_deletedBy == null) {
            _deletedBy = nCV();
        }
        return _deletedBy;
    }

    protected ConditionValue getCValueDeletedBy() {
        return getDeletedBy();
    }

    public BsWebCrawlingConfigCQ addOrderBy_DeletedBy_Asc() {
        regOBA("DELETED_BY");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_DeletedBy_Desc() {
        regOBD("DELETED_BY");
        return this;
    }

    protected ConditionValue _deletedTime;

    public ConditionValue getDeletedTime() {
        if (_deletedTime == null) {
            _deletedTime = nCV();
        }
        return _deletedTime;
    }

    protected ConditionValue getCValueDeletedTime() {
        return getDeletedTime();
    }

    public BsWebCrawlingConfigCQ addOrderBy_DeletedTime_Asc() {
        regOBA("DELETED_TIME");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_DeletedTime_Desc() {
        regOBD("DELETED_TIME");
        return this;
    }

    protected ConditionValue _versionNo;

    public ConditionValue getVersionNo() {
        if (_versionNo == null) {
            _versionNo = nCV();
        }
        return _versionNo;
    }

    protected ConditionValue getCValueVersionNo() {
        return getVersionNo();
    }

    public BsWebCrawlingConfigCQ addOrderBy_VersionNo_Asc() {
        regOBA("VERSION_NO");
        return this;
    }

    public BsWebCrawlingConfigCQ addOrderBy_VersionNo_Desc() {
        regOBD("VERSION_NO");
        return this;
    }

    // ===================================================================================
    //                                                           Specified Derived OrderBy
    //                                                           =========================
    public BsWebCrawlingConfigCQ addSpecifiedDerivedOrderBy_Asc(String aliasName) {
        registerSpecifiedDerivedOrderBy_Asc(aliasName);
        return this;
    }

    public BsWebCrawlingConfigCQ addSpecifiedDerivedOrderBy_Desc(
            String aliasName) {
        registerSpecifiedDerivedOrderBy_Desc(aliasName);
        return this;
    }

    // ===================================================================================
    //                                                                         Union Query
    //                                                                         ===========
    protected void reflectRelationOnUnionQuery(ConditionQuery baseQueryAsSuper,
            ConditionQuery unionQueryAsSuper) {
    }

    // ===================================================================================
    //                                                                       Foreign Query
    //                                                                       =============
    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    protected Map<String, WebCrawlingConfigCQ> _scalarSubQueryMap;

    public Map<String, WebCrawlingConfigCQ> getScalarSubQuery() {
        return _scalarSubQueryMap;
    }

    public String keepScalarSubQuery(WebCrawlingConfigCQ subQuery) {
        if (_scalarSubQueryMap == null) {
            _scalarSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_scalarSubQueryMap.size() + 1);
        _scalarSubQueryMap.put(key, subQuery);
        return "scalarSubQuery." + key;
    }

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    protected Map<String, WebCrawlingConfigCQ> _myselfInScopeSubQueryMap;

    public Map<String, WebCrawlingConfigCQ> getMyselfInScopeSubQuery() {
        return _myselfInScopeSubQueryMap;
    }

    public String keepMyselfInScopeSubQuery(WebCrawlingConfigCQ subQuery) {
        if (_myselfInScopeSubQueryMap == null) {
            _myselfInScopeSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_myselfInScopeSubQueryMap.size() + 1);
        _myselfInScopeSubQueryMap.put(key, subQuery);
        return "myselfInScopeSubQuery." + key;
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    String xCB() {
        return WebCrawlingConfigCB.class.getName();
    }

    String xCQ() {
        return WebCrawlingConfigCQ.class.getName();
    }

    String xMap() {
        return Map.class.getName();
    }
}
