/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity.dbmeta;

import java.util.List;
import java.util.Map;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.exentity.WebConfigToLabelTypeMapping;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.AbstractDBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.dbmeta.name.TableSqlName;
import org.seasar.dbflute.helper.StringKeyMap;

/**
 * The DB meta of WEB_CONFIG_TO_LABEL_TYPE_MAPPING. (Singleton)
 * @author DBFlute(AutoGenerator)
 */
public class WebConfigToLabelTypeMappingDbm extends AbstractDBMeta {

    // ===================================================================================
    //                                                                           Singleton
    //                                                                           =========
    private static final WebConfigToLabelTypeMappingDbm _instance = new WebConfigToLabelTypeMappingDbm();

    private WebConfigToLabelTypeMappingDbm() {
    }

    public static WebConfigToLabelTypeMappingDbm getInstance() {
        return _instance;
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    public DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                                          Table Info
    //                                                                          ==========
    protected final String _tableDbName = "WEB_CONFIG_TO_LABEL_TYPE_MAPPING";

    protected final String _tablePropertyName = "webConfigToLabelTypeMapping";

    protected final TableSqlName _tableSqlName = new TableSqlName(
            "WEB_CONFIG_TO_LABEL_TYPE_MAPPING");

    public String getTableDbName() {
        return _tableDbName;
    }

    public String getTablePropertyName() {
        return _tablePropertyName;
    }

    public TableSqlName getTableSqlName() {
        return _tableSqlName;
    }

    // ===================================================================================
    //                                                                         Column Info
    //                                                                         ===========
    protected final ColumnInfo _columnId = cci("ID", "ID", null, true, "id",
            Long.class, true, true, "BIGINT", 19, 0, false, null, null, null,
            null, null);

    protected final ColumnInfo _columnWebConfigId = cci("WEB_CONFIG_ID",
            "WEB_CONFIG_ID", null, true, "webConfigId", Long.class, false,
            false, "BIGINT", 19, 0, false, null, null, "webCrawlingConfig",
            null, null);

    protected final ColumnInfo _columnLabelTypeId = cci("LABEL_TYPE_ID",
            "LABEL_TYPE_ID", null, true, "labelTypeId", Long.class, false,
            false, "BIGINT", 19, 0, false, null, null, "labelType", null, null);

    public ColumnInfo columnId() {
        return _columnId;
    }

    public ColumnInfo columnWebConfigId() {
        return _columnWebConfigId;
    }

    public ColumnInfo columnLabelTypeId() {
        return _columnLabelTypeId;
    }

    protected List<ColumnInfo> ccil() {
        List<ColumnInfo> ls = newArrayList();
        ls.add(columnId());
        ls.add(columnWebConfigId());
        ls.add(columnLabelTypeId());
        return ls;
    }

    {
        initializeInformationResource();
    }

    // ===================================================================================
    //                                                                         Unique Info
    //                                                                         ===========
    // -----------------------------------------------------
    //                                       Primary Element
    //                                       ---------------
    public UniqueInfo getPrimaryUniqueInfo() {
        return cpui(columnId());
    }

    public boolean hasPrimaryKey() {
        return true;
    }

    public boolean hasTwoOrMorePrimaryKeys() {
        return false;
    }

    // ===================================================================================
    //                                                                       Relation Info
    //                                                                       =============
    // -----------------------------------------------------
    //                                      Foreign Property
    //                                      ----------------
    public ForeignInfo foreignLabelType() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnLabelTypeId(),
                LabelTypeDbm.getInstance().columnId());
        return cfi("labelType", this, LabelTypeDbm.getInstance(), map, 0, false);
    }

    public ForeignInfo foreignWebCrawlingConfig() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnWebConfigId(),
                WebCrawlingConfigDbm.getInstance().columnId());
        return cfi("webCrawlingConfig", this,
                WebCrawlingConfigDbm.getInstance(), map, 1, false);
    }

    // -----------------------------------------------------
    //                                     Referrer Property
    //                                     -----------------

    // ===================================================================================
    //                                                                        Various Info
    //                                                                        ============
    public boolean hasIdentity() {
        return true;
    }

    // ===================================================================================
    //                                                                           Type Name
    //                                                                           =========
    public String getEntityTypeName() {
        return "jp.sf.fess.db.exentity.WebConfigToLabelTypeMapping";
    }

    public String getConditionBeanTypeName() {
        return "jp.sf.fess.db.cbean.bs.WebConfigToLabelTypeMappingCB";
    }

    public String getDaoTypeName() {
        return "jp.sf.fess.db.exdao.WebConfigToLabelTypeMappingDao";
    }

    public String getBehaviorTypeName() {
        return "jp.sf.fess.db.exbhv.WebConfigToLabelTypeMappingBhv";
    }

    // ===================================================================================
    //                                                                         Object Type
    //                                                                         ===========
    public Class<WebConfigToLabelTypeMapping> getEntityType() {
        return WebConfigToLabelTypeMapping.class;
    }

    // ===================================================================================
    //                                                                     Object Instance
    //                                                                     ===============
    public Entity newEntity() {
        return newMyEntity();
    }

    public WebConfigToLabelTypeMapping newMyEntity() {
        return new WebConfigToLabelTypeMapping();
    }

    // ===================================================================================
    //                                                                     Entity Handling
    //                                                                     ===============  
    public void acceptPrimaryKeyMap(Entity e, Map<String, ? extends Object> m) {
        doAcceptPrimaryKeyMap((WebConfigToLabelTypeMapping) e, m, _epsMap);
    }

    public Map<String, Object> extractPrimaryKeyMap(Entity e) {
        return doExtractPrimaryKeyMap(e);
    }

    public Map<String, Object> extractAllColumnMap(Entity e) {
        return doExtractAllColumnMap(e);
    }

    // ===================================================================================
    //                                                               Entity Property Setup
    //                                                               =====================
    // It's very INTERNAL!
    protected final Map<String, Eps<WebConfigToLabelTypeMapping>> _epsMap = StringKeyMap
            .createAsFlexibleConcurrent();
    {
        setupEps(_epsMap, new EpsId(), columnId());
        setupEps(_epsMap, new EpsWebConfigId(), columnWebConfigId());
        setupEps(_epsMap, new EpsLabelTypeId(), columnLabelTypeId());
    }

    public boolean hasEntityPropertySetupper(String propertyName) {
        return _epsMap.containsKey(propertyName);
    }

    public void setupEntityProperty(String propertyName, Object entity,
            Object value) {
        findEps(_epsMap, propertyName).setup(
                (WebConfigToLabelTypeMapping) entity, value);
    }

    public class EpsId implements Eps<WebConfigToLabelTypeMapping> {
        public void setup(WebConfigToLabelTypeMapping e, Object v) {
            e.setId(ctl(v));
        }
    }

    public class EpsWebConfigId implements Eps<WebConfigToLabelTypeMapping> {
        public void setup(WebConfigToLabelTypeMapping e, Object v) {
            e.setWebConfigId(ctl(v));
        }
    }

    public class EpsLabelTypeId implements Eps<WebConfigToLabelTypeMapping> {
        public void setup(WebConfigToLabelTypeMapping e, Object v) {
            e.setLabelTypeId(ctl(v));
        }
    }
}
