/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.bs;

import java.util.Collection;

import jp.sf.fess.db.allcommon.CDef;
import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.cbean.ClickLogCB;
import jp.sf.fess.db.cbean.SearchLogCB;
import jp.sf.fess.db.cbean.cq.ClickLogCQ;
import jp.sf.fess.db.cbean.cq.SearchLogCQ;

import org.seasar.dbflute.cbean.AbstractConditionQuery;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.SubQuery;
import org.seasar.dbflute.cbean.chelper.HpQDRFunction;
import org.seasar.dbflute.cbean.chelper.HpQDRSetupper;
import org.seasar.dbflute.cbean.chelper.HpSSQFunction;
import org.seasar.dbflute.cbean.chelper.HpSSQSetupper;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.DateFromToOption;
import org.seasar.dbflute.cbean.coption.DerivedReferrerOption;
import org.seasar.dbflute.cbean.coption.FromToOption;
import org.seasar.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.DBMetaProvider;

/**
 * The abstract condition-query of SEARCH_LOG.
 * @author DBFlute(AutoGenerator)
 */
public abstract class AbstractBsSearchLogCQ extends AbstractConditionQuery {

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public AbstractBsSearchLogCQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                     DBMeta Provider
    //                                                                     ===============
    @Override
    protected DBMetaProvider xgetDBMetaProvider() {
        return DBMetaInstanceHandler.getProvider();
    }

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "SEARCH_LOG";
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * ID: {PK, ID, NotNull, BIGINT(19)}
     * @param id The value of id as equal.
     */
    public void setId_Equal(Long id) {
        doSetId_Equal(id);
    }

    protected void doSetId_Equal(Long id) {
        regId(CK_EQ, id);
    }

    /**
     * NotEqual(&lt;&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as notEqual.
     */
    public void setId_NotEqual(Long id) {
        doSetId_NotEqual(id);
    }

    protected void doSetId_NotEqual(Long id) {
        regId(CK_NES, id);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as greaterThan.
     */
    public void setId_GreaterThan(Long id) {
        regId(CK_GT, id);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as lessThan.
     */
    public void setId_LessThan(Long id) {
        regId(CK_LT, id);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as greaterEqual.
     */
    public void setId_GreaterEqual(Long id) {
        regId(CK_GE, id);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as lessEqual.
     */
    public void setId_LessEqual(Long id) {
        regId(CK_LE, id);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param idList The collection of id as inScope.
     */
    public void setId_InScope(Collection<Long> idList) {
        doSetId_InScope(idList);
    }

    protected void doSetId_InScope(Collection<Long> idList) {
        regINS(CK_INS, cTL(idList), getCValueId(), "ID");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param idList The collection of id as notInScope.
     */
    public void setId_NotInScope(Collection<Long> idList) {
        doSetId_NotInScope(idList);
    }

    protected void doSetId_NotInScope(Collection<Long> idList) {
        regINS(CK_NINS, cTL(idList), getCValueId(), "ID");
    }

    /**
     * Set up ExistsReferrer (co-related sub-query). <br />
     * {exists (select SEARCH_ID from CLICK_LOG where ...)} <br />
     * CLICK_LOG as 'clickLogList'.
     * <pre>
     * cb.query().<span style="color: #FD4747">existsClickLogList</span>(new SubQuery&lt;ClickLogCB&gt;() {
     *     public void query(SearchLogCB subCB) {
     *         subCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param subQuery The sub-query of ClickLogList for 'exists'. (NotNull)
     */
    public void existsClickLogList(SubQuery<ClickLogCB> subQuery) {
        assertObjectNotNull("subQuery<ClickLogCB>", subQuery);
        ClickLogCB cb = new ClickLogCB();
        cb.xsetupForExistsReferrer(this);
        subQuery.query(cb);
        String subQueryPropertyName = keepId_ExistsReferrer_ClickLogList(cb
                .query()); // for saving query-value.
        registerExistsReferrer(cb.query(), "ID", "SEARCH_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_ExistsReferrer_ClickLogList(
            ClickLogCQ subQuery);

    /**
     * Set up NotExistsReferrer (co-related sub-query). <br />
     * {not exists (select SEARCH_ID from CLICK_LOG where ...)} <br />
     * CLICK_LOG as 'clickLogList'.
     * <pre>
     * cb.query().<span style="color: #FD4747">notExistsClickLogList</span>(new SubQuery&lt;ClickLogCB&gt;() {
     *     public void query(SearchLogCB subCB) {
     *         subCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param subQuery The sub-query of Id_NotExistsReferrer_ClickLogList for 'not exists'. (NotNull)
     */
    public void notExistsClickLogList(SubQuery<ClickLogCB> subQuery) {
        assertObjectNotNull("subQuery<ClickLogCB>", subQuery);
        ClickLogCB cb = new ClickLogCB();
        cb.xsetupForExistsReferrer(this);
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotExistsReferrer_ClickLogList(cb
                .query()); // for saving query-value.
        registerNotExistsReferrer(cb.query(), "ID", "SEARCH_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotExistsReferrer_ClickLogList(
            ClickLogCQ subQuery);

    /**
     * Set up InScopeRelation (sub-query). <br />
     * {in (select SEARCH_ID from CLICK_LOG where ...)} <br />
     * CLICK_LOG as 'clickLogList'.
     * @param subQuery The sub-query of ClickLogList for 'in-scope'. (NotNull)
     */
    public void inScopeClickLogList(SubQuery<ClickLogCB> subQuery) {
        assertObjectNotNull("subQuery<ClickLogCB>", subQuery);
        ClickLogCB cb = new ClickLogCB();
        cb.xsetupForInScopeRelation(this);
        subQuery.query(cb);
        String subQueryPropertyName = keepId_InScopeRelation_ClickLogList(cb
                .query()); // for saving query-value.
        registerInScopeRelation(cb.query(), "ID", "SEARCH_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_InScopeRelation_ClickLogList(
            ClickLogCQ subQuery);

    /**
     * Set up NotInScopeRelation (sub-query). <br />
     * {not in (select SEARCH_ID from CLICK_LOG where ...)} <br />
     * CLICK_LOG as 'clickLogList'.
     * @param subQuery The sub-query of ClickLogList for 'not in-scope'. (NotNull)
     */
    public void notInScopeClickLogList(SubQuery<ClickLogCB> subQuery) {
        assertObjectNotNull("subQuery<ClickLogCB>", subQuery);
        ClickLogCB cb = new ClickLogCB();
        cb.xsetupForInScopeRelation(this);
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotInScopeRelation_ClickLogList(cb
                .query()); // for saving query-value.
        registerNotInScopeRelation(cb.query(), "ID", "SEARCH_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotInScopeRelation_ClickLogList(
            ClickLogCQ subQuery);

    public void xsderiveClickLogList(String function,
            SubQuery<ClickLogCB> subQuery, String aliasName,
            DerivedReferrerOption option) {
        assertObjectNotNull("subQuery<ClickLogCB>", subQuery);
        ClickLogCB cb = new ClickLogCB();
        cb.xsetupForDerivedReferrer(this);
        subQuery.query(cb);
        String subQueryPropertyName = keepId_SpecifyDerivedReferrer_ClickLogList(cb
                .query()); // for saving query-value.
        registerSpecifyDerivedReferrer(function, cb.query(), "ID", "SEARCH_ID",
                subQueryPropertyName, aliasName, option);
    }

    public abstract String keepId_SpecifyDerivedReferrer_ClickLogList(
            ClickLogCQ subQuery);

    /**
     * Prepare for (Query)DerivedReferrer. <br />
     * {FOO &lt;= (select max(BAR) from CLICK_LOG where ...)} <br />
     * CLICK_LOG as 'clickLogList'.
     * @return The object to set up a function for referrer table. (NotNull)
     */
    public HpQDRFunction<ClickLogCB> derivedClickLogList() {
        return xcreateQDRFunctionClickLogList();
    }

    protected HpQDRFunction<ClickLogCB> xcreateQDRFunctionClickLogList() {
        return new HpQDRFunction<ClickLogCB>(new HpQDRSetupper<ClickLogCB>() {
            public void setup(String function, SubQuery<ClickLogCB> subQuery,
                    String operand, Object value, DerivedReferrerOption option) {
                xqderiveClickLogList(function, subQuery, operand, value, option);
            }
        });
    }

    public void xqderiveClickLogList(String function,
            SubQuery<ClickLogCB> subQuery, String operand, Object value,
            DerivedReferrerOption option) {
        assertObjectNotNull("subQuery<ClickLogCB>", subQuery);
        ClickLogCB cb = new ClickLogCB();
        cb.xsetupForDerivedReferrer(this);
        subQuery.query(cb);
        String subQueryPropertyName = keepId_QueryDerivedReferrer_ClickLogList(cb
                .query()); // for saving query-value.
        String parameterPropertyName = keepId_QueryDerivedReferrer_ClickLogListParameter(value);
        registerQueryDerivedReferrer(function, cb.query(), "ID", "SEARCH_ID",
                subQueryPropertyName, operand, value, parameterPropertyName,
                option);
    }

    public abstract String keepId_QueryDerivedReferrer_ClickLogList(
            ClickLogCQ subQuery);

    public abstract String keepId_QueryDerivedReferrer_ClickLogListParameter(
            Object parameterValue);

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setId_IsNull() {
        regId(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setId_IsNotNull() {
        regId(CK_ISNN, DOBJ);
    }

    protected void regId(ConditionKey k, Object v) {
        regQ(k, v, getCValueId(), "ID");
    }

    abstract protected ConditionValue getCValueId();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * SEARCH_WORD: {IX, VARCHAR(1000)}
     * @param searchWord The value of searchWord as equal.
     */
    public void setSearchWord_Equal(String searchWord) {
        doSetSearchWord_Equal(fRES(searchWord));
    }

    protected void doSetSearchWord_Equal(String searchWord) {
        regSearchWord(CK_EQ, searchWord);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param searchWord The value of searchWord as notEqual.
     */
    public void setSearchWord_NotEqual(String searchWord) {
        doSetSearchWord_NotEqual(fRES(searchWord));
    }

    protected void doSetSearchWord_NotEqual(String searchWord) {
        regSearchWord(CK_NES, searchWord);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param searchWord The value of searchWord as greaterThan.
     */
    public void setSearchWord_GreaterThan(String searchWord) {
        regSearchWord(CK_GT, fRES(searchWord));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param searchWord The value of searchWord as lessThan.
     */
    public void setSearchWord_LessThan(String searchWord) {
        regSearchWord(CK_LT, fRES(searchWord));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param searchWord The value of searchWord as greaterEqual.
     */
    public void setSearchWord_GreaterEqual(String searchWord) {
        regSearchWord(CK_GE, fRES(searchWord));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param searchWord The value of searchWord as lessEqual.
     */
    public void setSearchWord_LessEqual(String searchWord) {
        regSearchWord(CK_LE, fRES(searchWord));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param searchWordList The collection of searchWord as inScope.
     */
    public void setSearchWord_InScope(Collection<String> searchWordList) {
        doSetSearchWord_InScope(searchWordList);
    }

    public void doSetSearchWord_InScope(Collection<String> searchWordList) {
        regINS(CK_INS, cTL(searchWordList), getCValueSearchWord(),
                "SEARCH_WORD");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param searchWordList The collection of searchWord as notInScope.
     */
    public void setSearchWord_NotInScope(Collection<String> searchWordList) {
        doSetSearchWord_NotInScope(searchWordList);
    }

    public void doSetSearchWord_NotInScope(Collection<String> searchWordList) {
        regINS(CK_NINS, cTL(searchWordList), getCValueSearchWord(),
                "SEARCH_WORD");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param searchWord The value of searchWord as prefixSearch.
     */
    public void setSearchWord_PrefixSearch(String searchWord) {
        setSearchWord_LikeSearch(searchWord, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param searchWord The value of searchWord as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setSearchWord_LikeSearch(String searchWord,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(searchWord), getCValueSearchWord(), "SEARCH_WORD",
                likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param searchWord The value of searchWord as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setSearchWord_NotLikeSearch(String searchWord,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(searchWord), getCValueSearchWord(), "SEARCH_WORD",
                likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setSearchWord_IsNull() {
        regSearchWord(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setSearchWord_IsNotNull() {
        regSearchWord(CK_ISNN, DOBJ);
    }

    protected void regSearchWord(ConditionKey k, Object v) {
        regQ(k, v, getCValueSearchWord(), "SEARCH_WORD");
    }

    abstract protected ConditionValue getCValueSearchWord();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * SEARCH_QUERY: {VARCHAR(1000)}
     * @param searchQuery The value of searchQuery as equal.
     */
    public void setSearchQuery_Equal(String searchQuery) {
        doSetSearchQuery_Equal(fRES(searchQuery));
    }

    protected void doSetSearchQuery_Equal(String searchQuery) {
        regSearchQuery(CK_EQ, searchQuery);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param searchQuery The value of searchQuery as notEqual.
     */
    public void setSearchQuery_NotEqual(String searchQuery) {
        doSetSearchQuery_NotEqual(fRES(searchQuery));
    }

    protected void doSetSearchQuery_NotEqual(String searchQuery) {
        regSearchQuery(CK_NES, searchQuery);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param searchQuery The value of searchQuery as greaterThan.
     */
    public void setSearchQuery_GreaterThan(String searchQuery) {
        regSearchQuery(CK_GT, fRES(searchQuery));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param searchQuery The value of searchQuery as lessThan.
     */
    public void setSearchQuery_LessThan(String searchQuery) {
        regSearchQuery(CK_LT, fRES(searchQuery));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param searchQuery The value of searchQuery as greaterEqual.
     */
    public void setSearchQuery_GreaterEqual(String searchQuery) {
        regSearchQuery(CK_GE, fRES(searchQuery));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param searchQuery The value of searchQuery as lessEqual.
     */
    public void setSearchQuery_LessEqual(String searchQuery) {
        regSearchQuery(CK_LE, fRES(searchQuery));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param searchQueryList The collection of searchQuery as inScope.
     */
    public void setSearchQuery_InScope(Collection<String> searchQueryList) {
        doSetSearchQuery_InScope(searchQueryList);
    }

    public void doSetSearchQuery_InScope(Collection<String> searchQueryList) {
        regINS(CK_INS, cTL(searchQueryList), getCValueSearchQuery(),
                "SEARCH_QUERY");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param searchQueryList The collection of searchQuery as notInScope.
     */
    public void setSearchQuery_NotInScope(Collection<String> searchQueryList) {
        doSetSearchQuery_NotInScope(searchQueryList);
    }

    public void doSetSearchQuery_NotInScope(Collection<String> searchQueryList) {
        regINS(CK_NINS, cTL(searchQueryList), getCValueSearchQuery(),
                "SEARCH_QUERY");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param searchQuery The value of searchQuery as prefixSearch.
     */
    public void setSearchQuery_PrefixSearch(String searchQuery) {
        setSearchQuery_LikeSearch(searchQuery, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param searchQuery The value of searchQuery as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setSearchQuery_LikeSearch(String searchQuery,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(searchQuery), getCValueSearchQuery(),
                "SEARCH_QUERY", likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param searchQuery The value of searchQuery as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setSearchQuery_NotLikeSearch(String searchQuery,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(searchQuery), getCValueSearchQuery(),
                "SEARCH_QUERY", likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setSearchQuery_IsNull() {
        regSearchQuery(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setSearchQuery_IsNotNull() {
        regSearchQuery(CK_ISNN, DOBJ);
    }

    protected void regSearchQuery(ConditionKey k, Object v) {
        regQ(k, v, getCValueSearchQuery(), "SEARCH_QUERY");
    }

    abstract protected ConditionValue getCValueSearchQuery();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * SOLR_QUERY: {VARCHAR(1000)}
     * @param solrQuery The value of solrQuery as equal.
     */
    public void setSolrQuery_Equal(String solrQuery) {
        doSetSolrQuery_Equal(fRES(solrQuery));
    }

    protected void doSetSolrQuery_Equal(String solrQuery) {
        regSolrQuery(CK_EQ, solrQuery);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param solrQuery The value of solrQuery as notEqual.
     */
    public void setSolrQuery_NotEqual(String solrQuery) {
        doSetSolrQuery_NotEqual(fRES(solrQuery));
    }

    protected void doSetSolrQuery_NotEqual(String solrQuery) {
        regSolrQuery(CK_NES, solrQuery);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param solrQuery The value of solrQuery as greaterThan.
     */
    public void setSolrQuery_GreaterThan(String solrQuery) {
        regSolrQuery(CK_GT, fRES(solrQuery));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param solrQuery The value of solrQuery as lessThan.
     */
    public void setSolrQuery_LessThan(String solrQuery) {
        regSolrQuery(CK_LT, fRES(solrQuery));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param solrQuery The value of solrQuery as greaterEqual.
     */
    public void setSolrQuery_GreaterEqual(String solrQuery) {
        regSolrQuery(CK_GE, fRES(solrQuery));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param solrQuery The value of solrQuery as lessEqual.
     */
    public void setSolrQuery_LessEqual(String solrQuery) {
        regSolrQuery(CK_LE, fRES(solrQuery));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param solrQueryList The collection of solrQuery as inScope.
     */
    public void setSolrQuery_InScope(Collection<String> solrQueryList) {
        doSetSolrQuery_InScope(solrQueryList);
    }

    public void doSetSolrQuery_InScope(Collection<String> solrQueryList) {
        regINS(CK_INS, cTL(solrQueryList), getCValueSolrQuery(), "SOLR_QUERY");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param solrQueryList The collection of solrQuery as notInScope.
     */
    public void setSolrQuery_NotInScope(Collection<String> solrQueryList) {
        doSetSolrQuery_NotInScope(solrQueryList);
    }

    public void doSetSolrQuery_NotInScope(Collection<String> solrQueryList) {
        regINS(CK_NINS, cTL(solrQueryList), getCValueSolrQuery(), "SOLR_QUERY");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param solrQuery The value of solrQuery as prefixSearch.
     */
    public void setSolrQuery_PrefixSearch(String solrQuery) {
        setSolrQuery_LikeSearch(solrQuery, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param solrQuery The value of solrQuery as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setSolrQuery_LikeSearch(String solrQuery,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(solrQuery), getCValueSolrQuery(), "SOLR_QUERY",
                likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param solrQuery The value of solrQuery as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setSolrQuery_NotLikeSearch(String solrQuery,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(solrQuery), getCValueSolrQuery(), "SOLR_QUERY",
                likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setSolrQuery_IsNull() {
        regSolrQuery(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setSolrQuery_IsNotNull() {
        regSolrQuery(CK_ISNN, DOBJ);
    }

    protected void regSolrQuery(ConditionKey k, Object v) {
        regQ(k, v, getCValueSolrQuery(), "SOLR_QUERY");
    }

    abstract protected ConditionValue getCValueSolrQuery();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * REQUESTED_TIME: {IX, NotNull, TIMESTAMP(23, 10)}
     * @param requestedTime The value of requestedTime as equal.
     */
    public void setRequestedTime_Equal(java.sql.Timestamp requestedTime) {
        regRequestedTime(CK_EQ, requestedTime);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param requestedTime The value of requestedTime as greaterThan.
     */
    public void setRequestedTime_GreaterThan(java.sql.Timestamp requestedTime) {
        regRequestedTime(CK_GT, requestedTime);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param requestedTime The value of requestedTime as lessThan.
     */
    public void setRequestedTime_LessThan(java.sql.Timestamp requestedTime) {
        regRequestedTime(CK_LT, requestedTime);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param requestedTime The value of requestedTime as greaterEqual.
     */
    public void setRequestedTime_GreaterEqual(java.sql.Timestamp requestedTime) {
        regRequestedTime(CK_GE, requestedTime);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param requestedTime The value of requestedTime as lessEqual.
     */
    public void setRequestedTime_LessEqual(java.sql.Timestamp requestedTime) {
        regRequestedTime(CK_LE, requestedTime);
    }

    /**
     * FromTo with various options. (versatile) <br />
     * {(default) fromDatetime &lt;= column &lt;= toDatetime} <br />
     * And NullIgnored, OnlyOnceRegistered.
     * @param fromDatetime The from-datetime(yyyy/MM/dd HH:mm:ss.SSS) of requestedTime. (NullAllowed)
     * @param toDatetime The to-datetime(yyyy/MM/dd HH:mm:ss.SSS) of requestedTime. (NullAllowed)
     * @param fromToOption The option of from-to. (NotNull)
     */
    public void setRequestedTime_FromTo(java.util.Date fromDatetime,
            java.util.Date toDatetime, FromToOption fromToOption) {
        regFTQ((fromDatetime != null ? new java.sql.Timestamp(
                fromDatetime.getTime()) : null),
                (toDatetime != null ? new java.sql.Timestamp(toDatetime
                        .getTime()) : null), getCValueRequestedTime(),
                "REQUESTED_TIME", fromToOption);
    }

    /**
     * DateFromTo. (Date means yyyy/MM/dd) <br />
     * {fromDate &lt;= column &lt; toDate + 1 day} <br />
     * And NullIgnored, OnlyOnceRegistered.
     * <pre>
     * ex) from:{2007/04/10 08:24:53} to:{2007/04/16 14:36:29}
     *     --&gt; column &gt;= '2007/04/10 00:00:00'
     *     and column <span style="color: #FD4747">&lt; '2007/04/17 00:00:00'</span>
     * </pre>
     * @param fromDate The from-date(yyyy/MM/dd) of requestedTime. (NullAllowed)
     * @param toDate The to-date(yyyy/MM/dd) of requestedTime. (NullAllowed)
     */
    public void setRequestedTime_DateFromTo(java.util.Date fromDate,
            java.util.Date toDate) {
        setRequestedTime_FromTo(fromDate, toDate, new DateFromToOption());
    }

    protected void regRequestedTime(ConditionKey k, Object v) {
        regQ(k, v, getCValueRequestedTime(), "REQUESTED_TIME");
    }

    abstract protected ConditionValue getCValueRequestedTime();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * RESPONSE_TIME: {IX, NotNull, INTEGER(10)}
     * @param responseTime The value of responseTime as equal.
     */
    public void setResponseTime_Equal(Integer responseTime) {
        doSetResponseTime_Equal(responseTime);
    }

    protected void doSetResponseTime_Equal(Integer responseTime) {
        regResponseTime(CK_EQ, responseTime);
    }

    /**
     * NotEqual(&lt;&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param responseTime The value of responseTime as notEqual.
     */
    public void setResponseTime_NotEqual(Integer responseTime) {
        doSetResponseTime_NotEqual(responseTime);
    }

    protected void doSetResponseTime_NotEqual(Integer responseTime) {
        regResponseTime(CK_NES, responseTime);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param responseTime The value of responseTime as greaterThan.
     */
    public void setResponseTime_GreaterThan(Integer responseTime) {
        regResponseTime(CK_GT, responseTime);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param responseTime The value of responseTime as lessThan.
     */
    public void setResponseTime_LessThan(Integer responseTime) {
        regResponseTime(CK_LT, responseTime);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param responseTime The value of responseTime as greaterEqual.
     */
    public void setResponseTime_GreaterEqual(Integer responseTime) {
        regResponseTime(CK_GE, responseTime);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param responseTime The value of responseTime as lessEqual.
     */
    public void setResponseTime_LessEqual(Integer responseTime) {
        regResponseTime(CK_LE, responseTime);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param responseTimeList The collection of responseTime as inScope.
     */
    public void setResponseTime_InScope(Collection<Integer> responseTimeList) {
        doSetResponseTime_InScope(responseTimeList);
    }

    protected void doSetResponseTime_InScope(
            Collection<Integer> responseTimeList) {
        regINS(CK_INS, cTL(responseTimeList), getCValueResponseTime(),
                "RESPONSE_TIME");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param responseTimeList The collection of responseTime as notInScope.
     */
    public void setResponseTime_NotInScope(Collection<Integer> responseTimeList) {
        doSetResponseTime_NotInScope(responseTimeList);
    }

    protected void doSetResponseTime_NotInScope(
            Collection<Integer> responseTimeList) {
        regINS(CK_NINS, cTL(responseTimeList), getCValueResponseTime(),
                "RESPONSE_TIME");
    }

    protected void regResponseTime(ConditionKey k, Object v) {
        regQ(k, v, getCValueResponseTime(), "RESPONSE_TIME");
    }

    abstract protected ConditionValue getCValueResponseTime();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * HIT_COUNT: {IX, NotNull, BIGINT(19)}
     * @param hitCount The value of hitCount as equal.
     */
    public void setHitCount_Equal(Long hitCount) {
        doSetHitCount_Equal(hitCount);
    }

    protected void doSetHitCount_Equal(Long hitCount) {
        regHitCount(CK_EQ, hitCount);
    }

    /**
     * NotEqual(&lt;&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param hitCount The value of hitCount as notEqual.
     */
    public void setHitCount_NotEqual(Long hitCount) {
        doSetHitCount_NotEqual(hitCount);
    }

    protected void doSetHitCount_NotEqual(Long hitCount) {
        regHitCount(CK_NES, hitCount);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param hitCount The value of hitCount as greaterThan.
     */
    public void setHitCount_GreaterThan(Long hitCount) {
        regHitCount(CK_GT, hitCount);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param hitCount The value of hitCount as lessThan.
     */
    public void setHitCount_LessThan(Long hitCount) {
        regHitCount(CK_LT, hitCount);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param hitCount The value of hitCount as greaterEqual.
     */
    public void setHitCount_GreaterEqual(Long hitCount) {
        regHitCount(CK_GE, hitCount);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param hitCount The value of hitCount as lessEqual.
     */
    public void setHitCount_LessEqual(Long hitCount) {
        regHitCount(CK_LE, hitCount);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param hitCountList The collection of hitCount as inScope.
     */
    public void setHitCount_InScope(Collection<Long> hitCountList) {
        doSetHitCount_InScope(hitCountList);
    }

    protected void doSetHitCount_InScope(Collection<Long> hitCountList) {
        regINS(CK_INS, cTL(hitCountList), getCValueHitCount(), "HIT_COUNT");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param hitCountList The collection of hitCount as notInScope.
     */
    public void setHitCount_NotInScope(Collection<Long> hitCountList) {
        doSetHitCount_NotInScope(hitCountList);
    }

    protected void doSetHitCount_NotInScope(Collection<Long> hitCountList) {
        regINS(CK_NINS, cTL(hitCountList), getCValueHitCount(), "HIT_COUNT");
    }

    protected void regHitCount(ConditionKey k, Object v) {
        regQ(k, v, getCValueHitCount(), "HIT_COUNT");
    }

    abstract protected ConditionValue getCValueHitCount();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * QUERY_OFFSET: {NotNull, INTEGER(10)}
     * @param queryOffset The value of queryOffset as equal.
     */
    public void setQueryOffset_Equal(Integer queryOffset) {
        doSetQueryOffset_Equal(queryOffset);
    }

    protected void doSetQueryOffset_Equal(Integer queryOffset) {
        regQueryOffset(CK_EQ, queryOffset);
    }

    /**
     * NotEqual(&lt;&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param queryOffset The value of queryOffset as notEqual.
     */
    public void setQueryOffset_NotEqual(Integer queryOffset) {
        doSetQueryOffset_NotEqual(queryOffset);
    }

    protected void doSetQueryOffset_NotEqual(Integer queryOffset) {
        regQueryOffset(CK_NES, queryOffset);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param queryOffset The value of queryOffset as greaterThan.
     */
    public void setQueryOffset_GreaterThan(Integer queryOffset) {
        regQueryOffset(CK_GT, queryOffset);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param queryOffset The value of queryOffset as lessThan.
     */
    public void setQueryOffset_LessThan(Integer queryOffset) {
        regQueryOffset(CK_LT, queryOffset);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param queryOffset The value of queryOffset as greaterEqual.
     */
    public void setQueryOffset_GreaterEqual(Integer queryOffset) {
        regQueryOffset(CK_GE, queryOffset);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param queryOffset The value of queryOffset as lessEqual.
     */
    public void setQueryOffset_LessEqual(Integer queryOffset) {
        regQueryOffset(CK_LE, queryOffset);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param queryOffsetList The collection of queryOffset as inScope.
     */
    public void setQueryOffset_InScope(Collection<Integer> queryOffsetList) {
        doSetQueryOffset_InScope(queryOffsetList);
    }

    protected void doSetQueryOffset_InScope(Collection<Integer> queryOffsetList) {
        regINS(CK_INS, cTL(queryOffsetList), getCValueQueryOffset(),
                "QUERY_OFFSET");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param queryOffsetList The collection of queryOffset as notInScope.
     */
    public void setQueryOffset_NotInScope(Collection<Integer> queryOffsetList) {
        doSetQueryOffset_NotInScope(queryOffsetList);
    }

    protected void doSetQueryOffset_NotInScope(
            Collection<Integer> queryOffsetList) {
        regINS(CK_NINS, cTL(queryOffsetList), getCValueQueryOffset(),
                "QUERY_OFFSET");
    }

    protected void regQueryOffset(ConditionKey k, Object v) {
        regQ(k, v, getCValueQueryOffset(), "QUERY_OFFSET");
    }

    abstract protected ConditionValue getCValueQueryOffset();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * QUERY_PAGE_SIZE: {NotNull, INTEGER(10)}
     * @param queryPageSize The value of queryPageSize as equal.
     */
    public void setQueryPageSize_Equal(Integer queryPageSize) {
        doSetQueryPageSize_Equal(queryPageSize);
    }

    protected void doSetQueryPageSize_Equal(Integer queryPageSize) {
        regQueryPageSize(CK_EQ, queryPageSize);
    }

    /**
     * NotEqual(&lt;&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param queryPageSize The value of queryPageSize as notEqual.
     */
    public void setQueryPageSize_NotEqual(Integer queryPageSize) {
        doSetQueryPageSize_NotEqual(queryPageSize);
    }

    protected void doSetQueryPageSize_NotEqual(Integer queryPageSize) {
        regQueryPageSize(CK_NES, queryPageSize);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param queryPageSize The value of queryPageSize as greaterThan.
     */
    public void setQueryPageSize_GreaterThan(Integer queryPageSize) {
        regQueryPageSize(CK_GT, queryPageSize);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param queryPageSize The value of queryPageSize as lessThan.
     */
    public void setQueryPageSize_LessThan(Integer queryPageSize) {
        regQueryPageSize(CK_LT, queryPageSize);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param queryPageSize The value of queryPageSize as greaterEqual.
     */
    public void setQueryPageSize_GreaterEqual(Integer queryPageSize) {
        regQueryPageSize(CK_GE, queryPageSize);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param queryPageSize The value of queryPageSize as lessEqual.
     */
    public void setQueryPageSize_LessEqual(Integer queryPageSize) {
        regQueryPageSize(CK_LE, queryPageSize);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param queryPageSizeList The collection of queryPageSize as inScope.
     */
    public void setQueryPageSize_InScope(Collection<Integer> queryPageSizeList) {
        doSetQueryPageSize_InScope(queryPageSizeList);
    }

    protected void doSetQueryPageSize_InScope(
            Collection<Integer> queryPageSizeList) {
        regINS(CK_INS, cTL(queryPageSizeList), getCValueQueryPageSize(),
                "QUERY_PAGE_SIZE");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param queryPageSizeList The collection of queryPageSize as notInScope.
     */
    public void setQueryPageSize_NotInScope(
            Collection<Integer> queryPageSizeList) {
        doSetQueryPageSize_NotInScope(queryPageSizeList);
    }

    protected void doSetQueryPageSize_NotInScope(
            Collection<Integer> queryPageSizeList) {
        regINS(CK_NINS, cTL(queryPageSizeList), getCValueQueryPageSize(),
                "QUERY_PAGE_SIZE");
    }

    protected void regQueryPageSize(ConditionKey k, Object v) {
        regQ(k, v, getCValueQueryPageSize(), "QUERY_PAGE_SIZE");
    }

    abstract protected ConditionValue getCValueQueryPageSize();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * USER_AGENT: {VARCHAR(255)}
     * @param userAgent The value of userAgent as equal.
     */
    public void setUserAgent_Equal(String userAgent) {
        doSetUserAgent_Equal(fRES(userAgent));
    }

    protected void doSetUserAgent_Equal(String userAgent) {
        regUserAgent(CK_EQ, userAgent);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userAgent The value of userAgent as notEqual.
     */
    public void setUserAgent_NotEqual(String userAgent) {
        doSetUserAgent_NotEqual(fRES(userAgent));
    }

    protected void doSetUserAgent_NotEqual(String userAgent) {
        regUserAgent(CK_NES, userAgent);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userAgent The value of userAgent as greaterThan.
     */
    public void setUserAgent_GreaterThan(String userAgent) {
        regUserAgent(CK_GT, fRES(userAgent));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userAgent The value of userAgent as lessThan.
     */
    public void setUserAgent_LessThan(String userAgent) {
        regUserAgent(CK_LT, fRES(userAgent));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userAgent The value of userAgent as greaterEqual.
     */
    public void setUserAgent_GreaterEqual(String userAgent) {
        regUserAgent(CK_GE, fRES(userAgent));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userAgent The value of userAgent as lessEqual.
     */
    public void setUserAgent_LessEqual(String userAgent) {
        regUserAgent(CK_LE, fRES(userAgent));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param userAgentList The collection of userAgent as inScope.
     */
    public void setUserAgent_InScope(Collection<String> userAgentList) {
        doSetUserAgent_InScope(userAgentList);
    }

    public void doSetUserAgent_InScope(Collection<String> userAgentList) {
        regINS(CK_INS, cTL(userAgentList), getCValueUserAgent(), "USER_AGENT");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param userAgentList The collection of userAgent as notInScope.
     */
    public void setUserAgent_NotInScope(Collection<String> userAgentList) {
        doSetUserAgent_NotInScope(userAgentList);
    }

    public void doSetUserAgent_NotInScope(Collection<String> userAgentList) {
        regINS(CK_NINS, cTL(userAgentList), getCValueUserAgent(), "USER_AGENT");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param userAgent The value of userAgent as prefixSearch.
     */
    public void setUserAgent_PrefixSearch(String userAgent) {
        setUserAgent_LikeSearch(userAgent, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param userAgent The value of userAgent as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setUserAgent_LikeSearch(String userAgent,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(userAgent), getCValueUserAgent(), "USER_AGENT",
                likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param userAgent The value of userAgent as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setUserAgent_NotLikeSearch(String userAgent,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(userAgent), getCValueUserAgent(), "USER_AGENT",
                likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setUserAgent_IsNull() {
        regUserAgent(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setUserAgent_IsNotNull() {
        regUserAgent(CK_ISNN, DOBJ);
    }

    protected void regUserAgent(ConditionKey k, Object v) {
        regQ(k, v, getCValueUserAgent(), "USER_AGENT");
    }

    abstract protected ConditionValue getCValueUserAgent();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * REFERER: {VARCHAR(1000)}
     * @param referer The value of referer as equal.
     */
    public void setReferer_Equal(String referer) {
        doSetReferer_Equal(fRES(referer));
    }

    protected void doSetReferer_Equal(String referer) {
        regReferer(CK_EQ, referer);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param referer The value of referer as notEqual.
     */
    public void setReferer_NotEqual(String referer) {
        doSetReferer_NotEqual(fRES(referer));
    }

    protected void doSetReferer_NotEqual(String referer) {
        regReferer(CK_NES, referer);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param referer The value of referer as greaterThan.
     */
    public void setReferer_GreaterThan(String referer) {
        regReferer(CK_GT, fRES(referer));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param referer The value of referer as lessThan.
     */
    public void setReferer_LessThan(String referer) {
        regReferer(CK_LT, fRES(referer));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param referer The value of referer as greaterEqual.
     */
    public void setReferer_GreaterEqual(String referer) {
        regReferer(CK_GE, fRES(referer));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param referer The value of referer as lessEqual.
     */
    public void setReferer_LessEqual(String referer) {
        regReferer(CK_LE, fRES(referer));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param refererList The collection of referer as inScope.
     */
    public void setReferer_InScope(Collection<String> refererList) {
        doSetReferer_InScope(refererList);
    }

    public void doSetReferer_InScope(Collection<String> refererList) {
        regINS(CK_INS, cTL(refererList), getCValueReferer(), "REFERER");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param refererList The collection of referer as notInScope.
     */
    public void setReferer_NotInScope(Collection<String> refererList) {
        doSetReferer_NotInScope(refererList);
    }

    public void doSetReferer_NotInScope(Collection<String> refererList) {
        regINS(CK_NINS, cTL(refererList), getCValueReferer(), "REFERER");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param referer The value of referer as prefixSearch.
     */
    public void setReferer_PrefixSearch(String referer) {
        setReferer_LikeSearch(referer, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param referer The value of referer as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setReferer_LikeSearch(String referer,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(referer), getCValueReferer(), "REFERER",
                likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param referer The value of referer as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setReferer_NotLikeSearch(String referer,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(referer), getCValueReferer(), "REFERER",
                likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setReferer_IsNull() {
        regReferer(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setReferer_IsNotNull() {
        regReferer(CK_ISNN, DOBJ);
    }

    protected void regReferer(ConditionKey k, Object v) {
        regQ(k, v, getCValueReferer(), "REFERER");
    }

    abstract protected ConditionValue getCValueReferer();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * CLIENT_IP: {VARCHAR(50)}
     * @param clientIp The value of clientIp as equal.
     */
    public void setClientIp_Equal(String clientIp) {
        doSetClientIp_Equal(fRES(clientIp));
    }

    protected void doSetClientIp_Equal(String clientIp) {
        regClientIp(CK_EQ, clientIp);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param clientIp The value of clientIp as notEqual.
     */
    public void setClientIp_NotEqual(String clientIp) {
        doSetClientIp_NotEqual(fRES(clientIp));
    }

    protected void doSetClientIp_NotEqual(String clientIp) {
        regClientIp(CK_NES, clientIp);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param clientIp The value of clientIp as greaterThan.
     */
    public void setClientIp_GreaterThan(String clientIp) {
        regClientIp(CK_GT, fRES(clientIp));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param clientIp The value of clientIp as lessThan.
     */
    public void setClientIp_LessThan(String clientIp) {
        regClientIp(CK_LT, fRES(clientIp));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param clientIp The value of clientIp as greaterEqual.
     */
    public void setClientIp_GreaterEqual(String clientIp) {
        regClientIp(CK_GE, fRES(clientIp));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param clientIp The value of clientIp as lessEqual.
     */
    public void setClientIp_LessEqual(String clientIp) {
        regClientIp(CK_LE, fRES(clientIp));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param clientIpList The collection of clientIp as inScope.
     */
    public void setClientIp_InScope(Collection<String> clientIpList) {
        doSetClientIp_InScope(clientIpList);
    }

    public void doSetClientIp_InScope(Collection<String> clientIpList) {
        regINS(CK_INS, cTL(clientIpList), getCValueClientIp(), "CLIENT_IP");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param clientIpList The collection of clientIp as notInScope.
     */
    public void setClientIp_NotInScope(Collection<String> clientIpList) {
        doSetClientIp_NotInScope(clientIpList);
    }

    public void doSetClientIp_NotInScope(Collection<String> clientIpList) {
        regINS(CK_NINS, cTL(clientIpList), getCValueClientIp(), "CLIENT_IP");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param clientIp The value of clientIp as prefixSearch.
     */
    public void setClientIp_PrefixSearch(String clientIp) {
        setClientIp_LikeSearch(clientIp, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param clientIp The value of clientIp as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setClientIp_LikeSearch(String clientIp,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(clientIp), getCValueClientIp(), "CLIENT_IP",
                likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param clientIp The value of clientIp as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setClientIp_NotLikeSearch(String clientIp,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(clientIp), getCValueClientIp(), "CLIENT_IP",
                likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setClientIp_IsNull() {
        regClientIp(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setClientIp_IsNotNull() {
        regClientIp(CK_ISNN, DOBJ);
    }

    protected void regClientIp(ConditionKey k, Object v) {
        regQ(k, v, getCValueClientIp(), "CLIENT_IP");
    }

    abstract protected ConditionValue getCValueClientIp();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * USER_SESSION_ID: {IX+, VARCHAR(100)}
     * @param userSessionId The value of userSessionId as equal.
     */
    public void setUserSessionId_Equal(String userSessionId) {
        doSetUserSessionId_Equal(fRES(userSessionId));
    }

    protected void doSetUserSessionId_Equal(String userSessionId) {
        regUserSessionId(CK_EQ, userSessionId);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userSessionId The value of userSessionId as notEqual.
     */
    public void setUserSessionId_NotEqual(String userSessionId) {
        doSetUserSessionId_NotEqual(fRES(userSessionId));
    }

    protected void doSetUserSessionId_NotEqual(String userSessionId) {
        regUserSessionId(CK_NES, userSessionId);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userSessionId The value of userSessionId as greaterThan.
     */
    public void setUserSessionId_GreaterThan(String userSessionId) {
        regUserSessionId(CK_GT, fRES(userSessionId));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userSessionId The value of userSessionId as lessThan.
     */
    public void setUserSessionId_LessThan(String userSessionId) {
        regUserSessionId(CK_LT, fRES(userSessionId));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userSessionId The value of userSessionId as greaterEqual.
     */
    public void setUserSessionId_GreaterEqual(String userSessionId) {
        regUserSessionId(CK_GE, fRES(userSessionId));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userSessionId The value of userSessionId as lessEqual.
     */
    public void setUserSessionId_LessEqual(String userSessionId) {
        regUserSessionId(CK_LE, fRES(userSessionId));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param userSessionIdList The collection of userSessionId as inScope.
     */
    public void setUserSessionId_InScope(Collection<String> userSessionIdList) {
        doSetUserSessionId_InScope(userSessionIdList);
    }

    public void doSetUserSessionId_InScope(Collection<String> userSessionIdList) {
        regINS(CK_INS, cTL(userSessionIdList), getCValueUserSessionId(),
                "USER_SESSION_ID");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param userSessionIdList The collection of userSessionId as notInScope.
     */
    public void setUserSessionId_NotInScope(Collection<String> userSessionIdList) {
        doSetUserSessionId_NotInScope(userSessionIdList);
    }

    public void doSetUserSessionId_NotInScope(
            Collection<String> userSessionIdList) {
        regINS(CK_NINS, cTL(userSessionIdList), getCValueUserSessionId(),
                "USER_SESSION_ID");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param userSessionId The value of userSessionId as prefixSearch.
     */
    public void setUserSessionId_PrefixSearch(String userSessionId) {
        setUserSessionId_LikeSearch(userSessionId, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param userSessionId The value of userSessionId as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setUserSessionId_LikeSearch(String userSessionId,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(userSessionId), getCValueUserSessionId(),
                "USER_SESSION_ID", likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param userSessionId The value of userSessionId as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setUserSessionId_NotLikeSearch(String userSessionId,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(userSessionId), getCValueUserSessionId(),
                "USER_SESSION_ID", likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setUserSessionId_IsNull() {
        regUserSessionId(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setUserSessionId_IsNotNull() {
        regUserSessionId(CK_ISNN, DOBJ);
    }

    protected void regUserSessionId(ConditionKey k, Object v) {
        regQ(k, v, getCValueUserSessionId(), "USER_SESSION_ID");
    }

    abstract protected ConditionValue getCValueUserSessionId();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * ACCESS_TYPE: {NotNull, VARCHAR(1), classification=AccessType}
     * @param accessType The value of accessType as equal.
     */
    public void setAccessType_Equal(String accessType) {
        doSetAccessType_Equal(fRES(accessType));
    }

    /**
     * Equal(=). As AccessType. And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * Access Type
     * @param cdef The instance of classification definition (as ENUM type).
     */
    public void setAccessType_Equal_AsAccessType(CDef.AccessType cdef) {
        doSetAccessType_Equal(cdef.code());
    }

    /**
     * Equal(=). As Web. And OnlyOnceRegistered. <br />
     * Web: Web
     */
    public void setAccessType_Equal_Web() {
        setAccessType_Equal_AsAccessType(CDef.AccessType.Web);
    }

    /**
     * Equal(=). As Mobile. And OnlyOnceRegistered. <br />
     * Mobile: Mobile
     */
    public void setAccessType_Equal_Mobile() {
        setAccessType_Equal_AsAccessType(CDef.AccessType.Mobile);
    }

    /**
     * Equal(=). As Xml. And OnlyOnceRegistered. <br />
     * Xml: Xml
     */
    public void setAccessType_Equal_Xml() {
        setAccessType_Equal_AsAccessType(CDef.AccessType.Xml);
    }

    /**
     * Equal(=). As Json. And OnlyOnceRegistered. <br />
     * Json: Json
     */
    public void setAccessType_Equal_Json() {
        setAccessType_Equal_AsAccessType(CDef.AccessType.Json);
    }

    protected void doSetAccessType_Equal(String accessType) {
        regAccessType(CK_EQ, accessType);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param accessType The value of accessType as notEqual.
     */
    public void setAccessType_NotEqual(String accessType) {
        doSetAccessType_NotEqual(fRES(accessType));
    }

    /**
     * NotEqual(&lt;&gt;). As AccessType. And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * Access Type
     * @param cdef The instance of classification definition (as ENUM type).
     */
    public void setAccessType_NotEqual_AsAccessType(CDef.AccessType cdef) {
        doSetAccessType_NotEqual(cdef.code());
    }

    /**
     * NotEqual(&lt;&gt;). As Web. And OnlyOnceRegistered. <br />
     * Web: Web
     */
    public void setAccessType_NotEqual_Web() {
        setAccessType_NotEqual_AsAccessType(CDef.AccessType.Web);
    }

    /**
     * NotEqual(&lt;&gt;). As Mobile. And OnlyOnceRegistered. <br />
     * Mobile: Mobile
     */
    public void setAccessType_NotEqual_Mobile() {
        setAccessType_NotEqual_AsAccessType(CDef.AccessType.Mobile);
    }

    /**
     * NotEqual(&lt;&gt;). As Xml. And OnlyOnceRegistered. <br />
     * Xml: Xml
     */
    public void setAccessType_NotEqual_Xml() {
        setAccessType_NotEqual_AsAccessType(CDef.AccessType.Xml);
    }

    /**
     * NotEqual(&lt;&gt;). As Json. And OnlyOnceRegistered. <br />
     * Json: Json
     */
    public void setAccessType_NotEqual_Json() {
        setAccessType_NotEqual_AsAccessType(CDef.AccessType.Json);
    }

    protected void doSetAccessType_NotEqual(String accessType) {
        regAccessType(CK_NES, accessType);
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param accessTypeList The collection of accessType as inScope.
     */
    public void setAccessType_InScope(Collection<String> accessTypeList) {
        doSetAccessType_InScope(accessTypeList);
    }

    /**
     * InScope(in ('a', 'b')). As AccessType. And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered. <br />
     * Access Type
     * @param cdefList The list of classification definition (as ENUM type).
     */
    public void setAccessType_InScope_AsAccessType(
            Collection<CDef.AccessType> cdefList) {
        doSetAccessType_InScope(cTStrL(cdefList));
    }

    public void doSetAccessType_InScope(Collection<String> accessTypeList) {
        regINS(CK_INS, cTL(accessTypeList), getCValueAccessType(),
                "ACCESS_TYPE");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param accessTypeList The collection of accessType as notInScope.
     */
    public void setAccessType_NotInScope(Collection<String> accessTypeList) {
        doSetAccessType_NotInScope(accessTypeList);
    }

    /**
     * NotInScope(not in ('a', 'b')). As AccessType. And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered. <br />
     * Access Type
     * @param cdefList The list of classification definition (as ENUM type).
     */
    public void setAccessType_NotInScope_AsAccessType(
            Collection<CDef.AccessType> cdefList) {
        doSetAccessType_NotInScope(cTStrL(cdefList));
    }

    public void doSetAccessType_NotInScope(Collection<String> accessTypeList) {
        regINS(CK_NINS, cTL(accessTypeList), getCValueAccessType(),
                "ACCESS_TYPE");
    }

    protected void regAccessType(ConditionKey k, Object v) {
        regQ(k, v, getCValueAccessType(), "ACCESS_TYPE");
    }

    abstract protected ConditionValue getCValueAccessType();

    // ===================================================================================
    //                                                                    Scalar Condition
    //                                                                    ================
    /**
     * Prepare ScalarCondition as equal. <br />
     * {where FOO = (select max(BAR) from ...)
     * <pre>
     * cb.query().<span style="color: #FD4747">scalar_Equal()</span>.max(new SubQuery&lt;SearchLogCB&gt;() {
     *     public void query(SearchLogCB subCB) {
     *         subCB.specify().setXxx... <span style="color: #3F7E5E">// derived column for function</span>
     *         subCB.query().setYyy...
     *     }
     * });
     * </pre>
     * @return The object to set up a function. (NotNull)
     */
    public HpSSQFunction<SearchLogCB> scalar_Equal() {
        return xcreateSSQFunction(CK_EQ.getOperand());
    }

    /**
     * Prepare ScalarCondition as equal. <br />
     * {where FOO &lt;&gt; (select max(BAR) from ...)
     * <pre>
     * cb.query().<span style="color: #FD4747">scalar_NotEqual()</span>.max(new SubQuery&lt;SearchLogCB&gt;() {
     *     public void query(SearchLogCB subCB) {
     *         subCB.specify().setXxx... <span style="color: #3F7E5E">// derived column for function</span>
     *         subCB.query().setYyy...
     *     }
     * });
     * </pre>
     * @return The object to set up a function. (NotNull)
     */
    public HpSSQFunction<SearchLogCB> scalar_NotEqual() {
        return xcreateSSQFunction(CK_NES.getOperand());
    }

    /**
     * Prepare ScalarCondition as greaterThan. <br />
     * {where FOO &gt; (select max(BAR) from ...)
     * <pre>
     * cb.query().<span style="color: #FD4747">scalar_GreaterThan()</span>.max(new SubQuery&lt;SearchLogCB&gt;() {
     *     public void query(SearchLogCB subCB) {
     *         subCB.specify().setFoo... <span style="color: #3F7E5E">// derived column for function</span>
     *         subCB.query().setBar...
     *     }
     * });
     * </pre>
     * @return The object to set up a function. (NotNull)
     */
    public HpSSQFunction<SearchLogCB> scalar_GreaterThan() {
        return xcreateSSQFunction(CK_GT.getOperand());
    }

    /**
     * Prepare ScalarCondition as lessThan. <br />
     * {where FOO &lt; (select max(BAR) from ...)
     * <pre>
     * cb.query().<span style="color: #FD4747">scalar_LessThan()</span>.max(new SubQuery&lt;SearchLogCB&gt;() {
     *     public void query(SearchLogCB subCB) {
     *         subCB.specify().setFoo... <span style="color: #3F7E5E">// derived column for function</span>
     *         subCB.query().setBar...
     *     }
     * });
     * </pre>
     * @return The object to set up a function. (NotNull)
     */
    public HpSSQFunction<SearchLogCB> scalar_LessThan() {
        return xcreateSSQFunction(CK_LT.getOperand());
    }

    /**
     * Prepare ScalarCondition as greaterEqual. <br />
     * {where FOO &gt;= (select max(BAR) from ...)
     * <pre>
     * cb.query().<span style="color: #FD4747">scalar_GreaterEqual()</span>.max(new SubQuery&lt;SearchLogCB&gt;() {
     *     public void query(SearchLogCB subCB) {
     *         subCB.specify().setFoo... <span style="color: #3F7E5E">// derived column for function</span>
     *         subCB.query().setBar...
     *     }
     * });
     * </pre>
     * @return The object to set up a function. (NotNull)
     */
    public HpSSQFunction<SearchLogCB> scalar_GreaterEqual() {
        return xcreateSSQFunction(CK_GE.getOperand());
    }

    /**
     * Prepare ScalarCondition as lessEqual. <br />
     * {where FOO &lt;= (select max(BAR) from ...)
     * <pre>
     * cb.query().<span style="color: #FD4747">scalar_LessEqual()</span>.max(new SubQuery&lt;SearchLogCB&gt;() {
     *     public void query(SearchLogCB subCB) {
     *         subCB.specify().setFoo... <span style="color: #3F7E5E">// derived column for function</span>
     *         subCB.query().setBar...
     *     }
     * });
     * </pre>
     * @return The object to set up a function. (NotNull)
     */
    public HpSSQFunction<SearchLogCB> scalar_LessEqual() {
        return xcreateSSQFunction(CK_LE.getOperand());
    }

    protected HpSSQFunction<SearchLogCB> xcreateSSQFunction(final String operand) {
        return new HpSSQFunction<SearchLogCB>(new HpSSQSetupper<SearchLogCB>() {
            public void setup(String function, SubQuery<SearchLogCB> subQuery) {
                xscalarCondition(function, subQuery, operand);
            }
        });
    }

    protected void xscalarCondition(String function,
            SubQuery<SearchLogCB> subQuery, String operand) {
        assertObjectNotNull("subQuery<SearchLogCB>", subQuery);
        SearchLogCB cb = new SearchLogCB();
        cb.xsetupForScalarCondition(this);
        subQuery.query(cb);
        String subQueryPropertyName = keepScalarCondition(cb.query()); // for saving query-value.
        registerScalarCondition(function, cb.query(), subQueryPropertyName,
                operand);
    }

    public abstract String keepScalarCondition(SearchLogCQ subQuery);

    // ===================================================================================
    //                                                                      Myself InScope
    //                                                                      ==============
    /**
     * Myself InScope (SubQuery). {mainly for CLOB and Union}
     * @param subQuery The implementation of sub query. (NotNull)
     */
    public void myselfInScope(SubQuery<SearchLogCB> subQuery) {
        assertObjectNotNull("subQuery<SearchLogCB>", subQuery);
        SearchLogCB cb = new SearchLogCB();
        cb.xsetupForInScopeRelation(this);
        subQuery.query(cb);
        String subQueryPropertyName = keepMyselfInScopeRelation(cb.query()); // for saving query-value.
        registerInScopeRelation(cb.query(), "ID", "ID", subQueryPropertyName);
    }

    public abstract String keepMyselfInScopeRelation(SearchLogCQ subQuery);

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // very internal (for suppressing warn about 'Not Use Import')
    protected String xabCB() {
        return SearchLogCB.class.getName();
    }

    protected String xabCQ() {
        return SearchLogCQ.class.getName();
    }

    protected String xabLSO() {
        return LikeSearchOption.class.getName();
    }

    protected String xabSSQS() {
        return HpSSQSetupper.class.getName();
    }
}
