/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.bs;

import java.util.Map;

import jp.sf.fess.db.cbean.SearchLogCB;
import jp.sf.fess.db.cbean.cq.ClickLogCQ;
import jp.sf.fess.db.cbean.cq.SearchLogCQ;
import jp.sf.fess.db.cbean.cq.ciq.SearchLogCIQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;

/**
 * The base condition-query of SEARCH_LOG.
 * @author DBFlute(AutoGenerator)
 */
public class BsSearchLogCQ extends AbstractBsSearchLogCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected SearchLogCIQ _inlineQuery;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public BsSearchLogCQ(ConditionQuery childQuery, SqlClause sqlClause,
            String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                              Inline
    //                                                                              ======
    /**
     * Prepare InlineView query. <br />
     * {select ... from ... left outer join (select * from SEARCH_LOG) where FOO = [value] ...}
     * <pre>
     * cb.query().queryMemberStatus().<span style="color: #FD4747">inline()</span>.setFoo...;
     * </pre>
     * @return The condition-query for InlineView query. (NotNull)
     */
    public SearchLogCIQ inline() {
        if (_inlineQuery == null) {
            _inlineQuery = createInlineQuery();
        }
        _inlineQuery.xsetOnClause(false);
        return _inlineQuery;
    }

    protected SearchLogCIQ createInlineQuery() {
        return new SearchLogCIQ(xgetReferrerQuery(), xgetSqlClause(),
                xgetAliasName(), xgetNestLevel(), this);
    }

    /**
     * Prepare OnClause query. <br />
     * {select ... from ... left outer join SEARCH_LOG on ... and FOO = [value] ...}
     * <pre>
     * cb.query().queryMemberStatus().<span style="color: #FD4747">on()</span>.setFoo...;
     * </pre>
     * @return The condition-query for OnClause query. (NotNull)
     * @throws IllegalConditionBeanOperationException When this condition-query is base query.
     */
    public SearchLogCIQ on() {
        if (isBaseQuery()) {
            throw new IllegalConditionBeanOperationException(
                    "OnClause for local table is unavailable!");
        }
        SearchLogCIQ inlineQuery = inline();
        inlineQuery.xsetOnClause(true);
        return inlineQuery;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    protected ConditionValue _id;

    public ConditionValue getId() {
        if (_id == null) {
            _id = nCV();
        }
        return _id;
    }

    protected ConditionValue getCValueId() {
        return getId();
    }

    protected Map<String, ClickLogCQ> _id_ExistsReferrer_ClickLogListMap;

    public Map<String, ClickLogCQ> getId_ExistsReferrer_ClickLogList() {
        return _id_ExistsReferrer_ClickLogListMap;
    }

    public String keepId_ExistsReferrer_ClickLogList(ClickLogCQ subQuery) {
        if (_id_ExistsReferrer_ClickLogListMap == null) {
            _id_ExistsReferrer_ClickLogListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsReferrer_ClickLogListMap.size() + 1);
        _id_ExistsReferrer_ClickLogListMap.put(key, subQuery);
        return "id_ExistsReferrer_ClickLogList." + key;
    }

    protected Map<String, ClickLogCQ> _id_NotExistsReferrer_ClickLogListMap;

    public Map<String, ClickLogCQ> getId_NotExistsReferrer_ClickLogList() {
        return _id_NotExistsReferrer_ClickLogListMap;
    }

    public String keepId_NotExistsReferrer_ClickLogList(ClickLogCQ subQuery) {
        if (_id_NotExistsReferrer_ClickLogListMap == null) {
            _id_NotExistsReferrer_ClickLogListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsReferrer_ClickLogListMap.size() + 1);
        _id_NotExistsReferrer_ClickLogListMap.put(key, subQuery);
        return "id_NotExistsReferrer_ClickLogList." + key;
    }

    protected Map<String, ClickLogCQ> _id_SpecifyDerivedReferrer_ClickLogListMap;

    public Map<String, ClickLogCQ> getId_SpecifyDerivedReferrer_ClickLogList() {
        return _id_SpecifyDerivedReferrer_ClickLogListMap;
    }

    public String keepId_SpecifyDerivedReferrer_ClickLogList(ClickLogCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_ClickLogListMap == null) {
            _id_SpecifyDerivedReferrer_ClickLogListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_ClickLogListMap.size() + 1);
        _id_SpecifyDerivedReferrer_ClickLogListMap.put(key, subQuery);
        return "id_SpecifyDerivedReferrer_ClickLogList." + key;
    }

    protected Map<String, ClickLogCQ> _id_InScopeRelation_ClickLogListMap;

    public Map<String, ClickLogCQ> getId_InScopeRelation_ClickLogList() {
        return _id_InScopeRelation_ClickLogListMap;
    }

    public String keepId_InScopeRelation_ClickLogList(ClickLogCQ subQuery) {
        if (_id_InScopeRelation_ClickLogListMap == null) {
            _id_InScopeRelation_ClickLogListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeRelation_ClickLogListMap.size() + 1);
        _id_InScopeRelation_ClickLogListMap.put(key, subQuery);
        return "id_InScopeRelation_ClickLogList." + key;
    }

    protected Map<String, ClickLogCQ> _id_NotInScopeRelation_ClickLogListMap;

    public Map<String, ClickLogCQ> getId_NotInScopeRelation_ClickLogList() {
        return _id_NotInScopeRelation_ClickLogListMap;
    }

    public String keepId_NotInScopeRelation_ClickLogList(ClickLogCQ subQuery) {
        if (_id_NotInScopeRelation_ClickLogListMap == null) {
            _id_NotInScopeRelation_ClickLogListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeRelation_ClickLogListMap.size() + 1);
        _id_NotInScopeRelation_ClickLogListMap.put(key, subQuery);
        return "id_NotInScopeRelation_ClickLogList." + key;
    }

    protected Map<String, ClickLogCQ> _id_QueryDerivedReferrer_ClickLogListMap;

    public Map<String, ClickLogCQ> getId_QueryDerivedReferrer_ClickLogList() {
        return _id_QueryDerivedReferrer_ClickLogListMap;
    }

    public String keepId_QueryDerivedReferrer_ClickLogList(ClickLogCQ subQuery) {
        if (_id_QueryDerivedReferrer_ClickLogListMap == null) {
            _id_QueryDerivedReferrer_ClickLogListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_ClickLogListMap.size() + 1);
        _id_QueryDerivedReferrer_ClickLogListMap.put(key, subQuery);
        return "id_QueryDerivedReferrer_ClickLogList." + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_ClickLogListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_ClickLogListParameter() {
        return _id_QueryDerivedReferrer_ClickLogListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_ClickLogListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_ClickLogListParameterMap == null) {
            _id_QueryDerivedReferrer_ClickLogListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_ClickLogListParameterMap.size() + 1);
        _id_QueryDerivedReferrer_ClickLogListParameterMap.put(key,
                parameterValue);
        return "id_QueryDerivedReferrer_ClickLogListParameter." + key;
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_Id_Asc() {
        regOBA("ID");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_Id_Desc() {
        regOBD("ID");
        return this;
    }

    protected ConditionValue _searchWord;

    public ConditionValue getSearchWord() {
        if (_searchWord == null) {
            _searchWord = nCV();
        }
        return _searchWord;
    }

    protected ConditionValue getCValueSearchWord() {
        return getSearchWord();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_SearchWord_Asc() {
        regOBA("SEARCH_WORD");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_SearchWord_Desc() {
        regOBD("SEARCH_WORD");
        return this;
    }

    protected ConditionValue _searchQuery;

    public ConditionValue getSearchQuery() {
        if (_searchQuery == null) {
            _searchQuery = nCV();
        }
        return _searchQuery;
    }

    protected ConditionValue getCValueSearchQuery() {
        return getSearchQuery();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_SearchQuery_Asc() {
        regOBA("SEARCH_QUERY");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_SearchQuery_Desc() {
        regOBD("SEARCH_QUERY");
        return this;
    }

    protected ConditionValue _solrQuery;

    public ConditionValue getSolrQuery() {
        if (_solrQuery == null) {
            _solrQuery = nCV();
        }
        return _solrQuery;
    }

    protected ConditionValue getCValueSolrQuery() {
        return getSolrQuery();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_SolrQuery_Asc() {
        regOBA("SOLR_QUERY");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_SolrQuery_Desc() {
        regOBD("SOLR_QUERY");
        return this;
    }

    protected ConditionValue _requestedTime;

    public ConditionValue getRequestedTime() {
        if (_requestedTime == null) {
            _requestedTime = nCV();
        }
        return _requestedTime;
    }

    protected ConditionValue getCValueRequestedTime() {
        return getRequestedTime();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_RequestedTime_Asc() {
        regOBA("REQUESTED_TIME");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_RequestedTime_Desc() {
        regOBD("REQUESTED_TIME");
        return this;
    }

    protected ConditionValue _responseTime;

    public ConditionValue getResponseTime() {
        if (_responseTime == null) {
            _responseTime = nCV();
        }
        return _responseTime;
    }

    protected ConditionValue getCValueResponseTime() {
        return getResponseTime();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_ResponseTime_Asc() {
        regOBA("RESPONSE_TIME");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_ResponseTime_Desc() {
        regOBD("RESPONSE_TIME");
        return this;
    }

    protected ConditionValue _hitCount;

    public ConditionValue getHitCount() {
        if (_hitCount == null) {
            _hitCount = nCV();
        }
        return _hitCount;
    }

    protected ConditionValue getCValueHitCount() {
        return getHitCount();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_HitCount_Asc() {
        regOBA("HIT_COUNT");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_HitCount_Desc() {
        regOBD("HIT_COUNT");
        return this;
    }

    protected ConditionValue _queryOffset;

    public ConditionValue getQueryOffset() {
        if (_queryOffset == null) {
            _queryOffset = nCV();
        }
        return _queryOffset;
    }

    protected ConditionValue getCValueQueryOffset() {
        return getQueryOffset();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_QueryOffset_Asc() {
        regOBA("QUERY_OFFSET");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_QueryOffset_Desc() {
        regOBD("QUERY_OFFSET");
        return this;
    }

    protected ConditionValue _queryPageSize;

    public ConditionValue getQueryPageSize() {
        if (_queryPageSize == null) {
            _queryPageSize = nCV();
        }
        return _queryPageSize;
    }

    protected ConditionValue getCValueQueryPageSize() {
        return getQueryPageSize();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_QueryPageSize_Asc() {
        regOBA("QUERY_PAGE_SIZE");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_QueryPageSize_Desc() {
        regOBD("QUERY_PAGE_SIZE");
        return this;
    }

    protected ConditionValue _userAgent;

    public ConditionValue getUserAgent() {
        if (_userAgent == null) {
            _userAgent = nCV();
        }
        return _userAgent;
    }

    protected ConditionValue getCValueUserAgent() {
        return getUserAgent();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_UserAgent_Asc() {
        regOBA("USER_AGENT");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_UserAgent_Desc() {
        regOBD("USER_AGENT");
        return this;
    }

    protected ConditionValue _referer;

    public ConditionValue getReferer() {
        if (_referer == null) {
            _referer = nCV();
        }
        return _referer;
    }

    protected ConditionValue getCValueReferer() {
        return getReferer();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_Referer_Asc() {
        regOBA("REFERER");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_Referer_Desc() {
        regOBD("REFERER");
        return this;
    }

    protected ConditionValue _clientIp;

    public ConditionValue getClientIp() {
        if (_clientIp == null) {
            _clientIp = nCV();
        }
        return _clientIp;
    }

    protected ConditionValue getCValueClientIp() {
        return getClientIp();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_ClientIp_Asc() {
        regOBA("CLIENT_IP");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_ClientIp_Desc() {
        regOBD("CLIENT_IP");
        return this;
    }

    protected ConditionValue _userSessionId;

    public ConditionValue getUserSessionId() {
        if (_userSessionId == null) {
            _userSessionId = nCV();
        }
        return _userSessionId;
    }

    protected ConditionValue getCValueUserSessionId() {
        return getUserSessionId();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_UserSessionId_Asc() {
        regOBA("USER_SESSION_ID");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_UserSessionId_Desc() {
        regOBD("USER_SESSION_ID");
        return this;
    }

    protected ConditionValue _accessType;

    public ConditionValue getAccessType() {
        if (_accessType == null) {
            _accessType = nCV();
        }
        return _accessType;
    }

    protected ConditionValue getCValueAccessType() {
        return getAccessType();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_AccessType_Asc() {
        regOBA("ACCESS_TYPE");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addOrderBy_AccessType_Desc() {
        regOBD("ACCESS_TYPE");
        return this;
    }

    // ===================================================================================
    //                                                           Specified Derived OrderBy
    //                                                           =========================
    /**
     * Add order-by for specified derived column as ascend.
     * <pre>
     * cb.specify().derivedPurchaseList().max(new SubQuery&lt;PurchaseCB&gt;() {
     *     public void query(PurchaseCB subCB) {
     *         subCB.specify().columnPurchaseDatetime();
     *     }
     * }, <span style="color: #FD4747">aliasName</span>);
     * <span style="color: #3F7E5E">// order by [alias-name] asc</span>
     * cb.<span style="color: #FD4747">addSpecifiedDerivedOrderBy_Asc</span>(<span style="color: #FD4747">aliasName</span>);
     * </pre>
     * @param aliasName The alias name specified at (Specify)DerivedReferrer. (NotNull)
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addSpecifiedDerivedOrderBy_Asc(String aliasName) {
        registerSpecifiedDerivedOrderBy_Asc(aliasName);
        return this;
    }

    /**
     * Add order-by for specified derived column as descend.
     * <pre>
     * cb.specify().derivedPurchaseList().max(new SubQuery&lt;PurchaseCB&gt;() {
     *     public void query(PurchaseCB subCB) {
     *         subCB.specify().columnPurchaseDatetime();
     *     }
     * }, <span style="color: #FD4747">aliasName</span>);
     * <span style="color: #3F7E5E">// order by [alias-name] desc</span>
     * cb.<span style="color: #FD4747">addSpecifiedDerivedOrderBy_Desc</span>(<span style="color: #FD4747">aliasName</span>);
     * </pre>
     * @param aliasName The alias name specified at (Specify)DerivedReferrer. (NotNull)
     * @return this. (NotNull)
     */
    public BsSearchLogCQ addSpecifiedDerivedOrderBy_Desc(String aliasName) {
        registerSpecifiedDerivedOrderBy_Desc(aliasName);
        return this;
    }

    // ===================================================================================
    //                                                                         Union Query
    //                                                                         ===========
    protected void reflectRelationOnUnionQuery(ConditionQuery baseQueryAsSuper,
            ConditionQuery unionQueryAsSuper) {
    }

    // ===================================================================================
    //                                                                       Foreign Query
    //                                                                       =============
    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    protected Map<String, SearchLogCQ> _scalarConditionMap;

    public Map<String, SearchLogCQ> getScalarCondition() {
        return _scalarConditionMap;
    }

    public String keepScalarCondition(SearchLogCQ subQuery) {
        if (_scalarConditionMap == null) {
            _scalarConditionMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_scalarConditionMap.size() + 1);
        _scalarConditionMap.put(key, subQuery);
        return "scalarCondition." + key;
    }

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    protected Map<String, SearchLogCQ> _myselfInScopeRelationMap;

    public Map<String, SearchLogCQ> getMyselfInScopeRelation() {
        return _myselfInScopeRelationMap;
    }

    public String keepMyselfInScopeRelation(SearchLogCQ subQuery) {
        if (_myselfInScopeRelationMap == null) {
            _myselfInScopeRelationMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_myselfInScopeRelationMap.size() + 1);
        _myselfInScopeRelationMap.put(key, subQuery);
        return "myselfInScopeRelation." + key;
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // very internal (for suppressing warn about 'Not Use Import')
    protected String xCB() {
        return SearchLogCB.class.getName();
    }

    protected String xCQ() {
        return SearchLogCQ.class.getName();
    }

    protected String xMap() {
        return Map.class.getName();
    }
}
