package jp.sf.fess.solr.plugin;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;

import java.util.List;

import jp.sf.fess.solr.plugin.suggest.SuggestConverterCreator;
import jp.sf.fess.suggest.converter.SuggestConverter;

import org.junit.Test;

public class SuggestConverterCreatorTest {
    @Test
    public void createTwoInstance() {
        final String text = "["
                + //
                "{\"class\":\"jp.sf.fess.suggest.converter.SymbolConveter\","
                + "\"method\":[{\"name\":\"addSymbol\",\"args\":[\"A\"]}]}"
                + ","
                + //
                "{\"class\":\"jp.sf.fess.suggest.converter.SymbolConveter\",\"args\":[\"B\",\"E\"],"
                + "\"method\":[{\"name\":\"addSymbol\",\"args\":[\"X\"]},{\"name\":\"addSymbol\",\"args\":[\"Y\"]}]}"
                + ","
                + //
                "{\"class\":\"jp.sf.fess.suggest.converter.ReplaceConverter\","
                + "\"method\":[{\"name\":\"addReplaceString\",\"args\":[\"x\",\"X\"]},{\"name\":\"addReplaceString\",\"args\":[\"y\",\"Y\"]}]}"
                + //
                "]";
        final List<SuggestConverter> list = SuggestConverterCreator
                .create(text);
        assertThat(list.size(), is(3));
        assertThat(list.get(0).getClass().getName(),
                is("jp.sf.fess.suggest.converter.SymbolConveter"));
        assertThat(list.get(0).convert("abcABC"), is("abc__ID0__BC"));
        assertThat(list.get(1).getClass().getName(),
                is("jp.sf.fess.suggest.converter.SymbolConveter"));
        assertThat(list.get(1).convert("xyzXYZ"), is("xyzB0EB1EZ"));
        assertThat(list.get(2).getClass().getName(),
                is("jp.sf.fess.suggest.converter.ReplaceConverter"));
        assertThat(list.get(2).convert("xyzXYZ"), is("XYzXYZ"));

    }

    @Test
    public void createOneInstance() {
        final String text = "["
                + //
                "{\"class\":\"jp.sf.fess.suggest.converter.ICUConverter\",\"args\":[\"Fullwidth-Halfwidth\"]}"
                + //
                "]";
        final List<SuggestConverter> list = SuggestConverterCreator
                .create(text);
        assertThat(list.size(), is(1));
        assertThat(list.get(0).getClass().getName(),
                is("jp.sf.fess.suggest.converter.ICUConverter"));

    }

    @Test
    public void createEmpty() {
        List<SuggestConverter> list;

        list = SuggestConverterCreator.create("");
        assertThat(list.size(), is(0));

        list = SuggestConverterCreator.create(null);
        assertThat(list.size(), is(0));
    }
}
