/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.bs;

import java.util.Map;

import jp.sf.fess.db.cbean.DataConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.cq.DataConfigToLabelTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.DataCrawlingConfigCQ;
import jp.sf.fess.db.cbean.cq.LabelTypeCQ;
import jp.sf.fess.db.cbean.cq.ciq.DataConfigToLabelTypeMappingCIQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;

/**
 * The base condition-query of DATA_CONFIG_TO_LABEL_TYPE_MAPPING.
 * @author DBFlute(AutoGenerator)
 */
public class BsDataConfigToLabelTypeMappingCQ extends
        AbstractBsDataConfigToLabelTypeMappingCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected DataConfigToLabelTypeMappingCIQ _inlineQuery;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public BsDataConfigToLabelTypeMappingCQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                              Inline
    //                                                                              ======
    /**
     * Prepare inline query. <br />
     * {select ... from ... left outer join (select * from DATA_CONFIG_TO_LABEL_TYPE_MAPPING) where abc = [abc] ...}
     * @return Inline query. (NotNull)
     */
    public DataConfigToLabelTypeMappingCIQ inline() {
        if (_inlineQuery == null) {
            _inlineQuery = new DataConfigToLabelTypeMappingCIQ(getChildQuery(),
                    getSqlClause(), getAliasName(), getNestLevel(), this);
        }
        _inlineQuery.xsetOnClauseInline(false);
        return _inlineQuery;
    }

    /**
     * Prepare on-clause query. <br />
     * {select ... from ... left outer join DATA_CONFIG_TO_LABEL_TYPE_MAPPING on ... and abc = [abc] ...}
     * @return On-clause query. (NotNull)
     */
    public DataConfigToLabelTypeMappingCIQ on() {
        if (isBaseQuery(this)) {
            throw new UnsupportedOperationException(
                    "Unsupported on-clause for local table!");
        }
        DataConfigToLabelTypeMappingCIQ inlineQuery = inline();
        inlineQuery.xsetOnClauseInline(true);
        return inlineQuery;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    protected ConditionValue _id;

    public ConditionValue getId() {
        if (_id == null) {
            _id = nCV();
        }
        return _id;
    }

    protected ConditionValue getCValueId() {
        return getId();
    }

    public BsDataConfigToLabelTypeMappingCQ addOrderBy_Id_Asc() {
        regOBA("ID");
        return this;
    }

    public BsDataConfigToLabelTypeMappingCQ addOrderBy_Id_Desc() {
        regOBD("ID");
        return this;
    }

    protected ConditionValue _dataConfigId;

    public ConditionValue getDataConfigId() {
        if (_dataConfigId == null) {
            _dataConfigId = nCV();
        }
        return _dataConfigId;
    }

    protected ConditionValue getCValueDataConfigId() {
        return getDataConfigId();
    }

    protected Map<String, DataCrawlingConfigCQ> _dataConfigId_InScopeSubQuery_DataCrawlingConfigMap;

    public Map<String, DataCrawlingConfigCQ> getDataConfigId_InScopeSubQuery_DataCrawlingConfig() {
        return _dataConfigId_InScopeSubQuery_DataCrawlingConfigMap;
    }

    public String keepDataConfigId_InScopeSubQuery_DataCrawlingConfig(
            DataCrawlingConfigCQ subQuery) {
        if (_dataConfigId_InScopeSubQuery_DataCrawlingConfigMap == null) {
            _dataConfigId_InScopeSubQuery_DataCrawlingConfigMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_dataConfigId_InScopeSubQuery_DataCrawlingConfigMap.size() + 1);
        _dataConfigId_InScopeSubQuery_DataCrawlingConfigMap.put(key, subQuery);
        return "dataConfigId_InScopeSubQuery_DataCrawlingConfig." + key;
    }

    public BsDataConfigToLabelTypeMappingCQ addOrderBy_DataConfigId_Asc() {
        regOBA("DATA_CONFIG_ID");
        return this;
    }

    public BsDataConfigToLabelTypeMappingCQ addOrderBy_DataConfigId_Desc() {
        regOBD("DATA_CONFIG_ID");
        return this;
    }

    protected ConditionValue _labelTypeId;

    public ConditionValue getLabelTypeId() {
        if (_labelTypeId == null) {
            _labelTypeId = nCV();
        }
        return _labelTypeId;
    }

    protected ConditionValue getCValueLabelTypeId() {
        return getLabelTypeId();
    }

    protected Map<String, LabelTypeCQ> _labelTypeId_InScopeSubQuery_LabelTypeMap;

    public Map<String, LabelTypeCQ> getLabelTypeId_InScopeSubQuery_LabelType() {
        return _labelTypeId_InScopeSubQuery_LabelTypeMap;
    }

    public String keepLabelTypeId_InScopeSubQuery_LabelType(LabelTypeCQ subQuery) {
        if (_labelTypeId_InScopeSubQuery_LabelTypeMap == null) {
            _labelTypeId_InScopeSubQuery_LabelTypeMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_labelTypeId_InScopeSubQuery_LabelTypeMap.size() + 1);
        _labelTypeId_InScopeSubQuery_LabelTypeMap.put(key, subQuery);
        return "labelTypeId_InScopeSubQuery_LabelType." + key;
    }

    public BsDataConfigToLabelTypeMappingCQ addOrderBy_LabelTypeId_Asc() {
        regOBA("LABEL_TYPE_ID");
        return this;
    }

    public BsDataConfigToLabelTypeMappingCQ addOrderBy_LabelTypeId_Desc() {
        regOBD("LABEL_TYPE_ID");
        return this;
    }

    // ===================================================================================
    //                                                           Specified Derived OrderBy
    //                                                           =========================
    public BsDataConfigToLabelTypeMappingCQ addSpecifiedDerivedOrderBy_Asc(
            String aliasName) {
        registerSpecifiedDerivedOrderBy_Asc(aliasName);
        return this;
    }

    public BsDataConfigToLabelTypeMappingCQ addSpecifiedDerivedOrderBy_Desc(
            String aliasName) {
        registerSpecifiedDerivedOrderBy_Desc(aliasName);
        return this;
    }

    // ===================================================================================
    //                                                                         Union Query
    //                                                                         ===========
    protected void reflectRelationOnUnionQuery(ConditionQuery baseQueryAsSuper,
            ConditionQuery unionQueryAsSuper) {
        DataConfigToLabelTypeMappingCQ baseQuery = (DataConfigToLabelTypeMappingCQ) baseQueryAsSuper;
        DataConfigToLabelTypeMappingCQ unionQuery = (DataConfigToLabelTypeMappingCQ) unionQueryAsSuper;
        if (baseQuery.hasConditionQueryDataCrawlingConfig()) {
            unionQuery.queryDataCrawlingConfig().reflectRelationOnUnionQuery(
                    baseQuery.queryDataCrawlingConfig(),
                    unionQuery.queryDataCrawlingConfig());
        }
        if (baseQuery.hasConditionQueryLabelType()) {
            unionQuery.queryLabelType().reflectRelationOnUnionQuery(
                    baseQuery.queryLabelType(), unionQuery.queryLabelType());
        }
    }

    // ===================================================================================
    //                                                                       Foreign Query
    //                                                                       =============
    public DataCrawlingConfigCQ queryDataCrawlingConfig() {
        return getConditionQueryDataCrawlingConfig();
    }

    protected DataCrawlingConfigCQ _conditionQueryDataCrawlingConfig;

    public DataCrawlingConfigCQ getConditionQueryDataCrawlingConfig() {
        if (_conditionQueryDataCrawlingConfig == null) {
            _conditionQueryDataCrawlingConfig = xcreateQueryDataCrawlingConfig();
            xsetupOuterJoinDataCrawlingConfig();
        }
        return _conditionQueryDataCrawlingConfig;
    }

    protected DataCrawlingConfigCQ xcreateQueryDataCrawlingConfig() {
        String nrp = resolveNextRelationPath(
                "DATA_CONFIG_TO_LABEL_TYPE_MAPPING", "dataCrawlingConfig");
        String jan = resolveJoinAliasName(nrp, getNextNestLevel());
        DataCrawlingConfigCQ cq = new DataCrawlingConfigCQ(this,
                getSqlClause(), jan, getNextNestLevel());
        cq.xsetForeignPropertyName("dataCrawlingConfig");
        cq.xsetRelationPath(nrp);
        return cq;
    }

    protected void xsetupOuterJoinDataCrawlingConfig() {
        DataCrawlingConfigCQ cq = getConditionQueryDataCrawlingConfig();
        Map<String, String> joinOnMap = newLinkedHashMap();
        joinOnMap.put(getRealColumnName("DATA_CONFIG_ID"), cq
                .getRealColumnName("ID"));
        registerOuterJoin(cq, joinOnMap);
    }

    public boolean hasConditionQueryDataCrawlingConfig() {
        return _conditionQueryDataCrawlingConfig != null;
    }

    public LabelTypeCQ queryLabelType() {
        return getConditionQueryLabelType();
    }

    protected LabelTypeCQ _conditionQueryLabelType;

    public LabelTypeCQ getConditionQueryLabelType() {
        if (_conditionQueryLabelType == null) {
            _conditionQueryLabelType = xcreateQueryLabelType();
            xsetupOuterJoinLabelType();
        }
        return _conditionQueryLabelType;
    }

    protected LabelTypeCQ xcreateQueryLabelType() {
        String nrp = resolveNextRelationPath(
                "DATA_CONFIG_TO_LABEL_TYPE_MAPPING", "labelType");
        String jan = resolveJoinAliasName(nrp, getNextNestLevel());
        LabelTypeCQ cq = new LabelTypeCQ(this, getSqlClause(), jan,
                getNextNestLevel());
        cq.xsetForeignPropertyName("labelType");
        cq.xsetRelationPath(nrp);
        return cq;
    }

    protected void xsetupOuterJoinLabelType() {
        LabelTypeCQ cq = getConditionQueryLabelType();
        Map<String, String> joinOnMap = newLinkedHashMap();
        joinOnMap.put(getRealColumnName("LABEL_TYPE_ID"), cq
                .getRealColumnName("ID"));
        registerOuterJoin(cq, joinOnMap);
    }

    public boolean hasConditionQueryLabelType() {
        return _conditionQueryLabelType != null;
    }

    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    protected Map<String, DataConfigToLabelTypeMappingCQ> _scalarSubQueryMap;

    public Map<String, DataConfigToLabelTypeMappingCQ> getScalarSubQuery() {
        return _scalarSubQueryMap;
    }

    public String keepScalarSubQuery(DataConfigToLabelTypeMappingCQ subQuery) {
        if (_scalarSubQueryMap == null) {
            _scalarSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_scalarSubQueryMap.size() + 1);
        _scalarSubQueryMap.put(key, subQuery);
        return "scalarSubQuery." + key;
    }

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    protected Map<String, DataConfigToLabelTypeMappingCQ> _myselfInScopeSubQueryMap;

    public Map<String, DataConfigToLabelTypeMappingCQ> getMyselfInScopeSubQuery() {
        return _myselfInScopeSubQueryMap;
    }

    public String keepMyselfInScopeSubQuery(
            DataConfigToLabelTypeMappingCQ subQuery) {
        if (_myselfInScopeSubQueryMap == null) {
            _myselfInScopeSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_myselfInScopeSubQueryMap.size() + 1);
        _myselfInScopeSubQueryMap.put(key, subQuery);
        return "myselfInScopeSubQuery." + key;
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    String xCB() {
        return DataConfigToLabelTypeMappingCB.class.getName();
    }

    String xCQ() {
        return DataConfigToLabelTypeMappingCQ.class.getName();
    }

    String xMap() {
        return Map.class.getName();
    }
}
