/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.helper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import jp.sf.fess.Constants;
import jp.sf.fess.db.exentity.LabelType;
import jp.sf.fess.service.LabelTypeService;

import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.container.annotation.tiger.InitMethod;

public class LabelTypeHelper implements Serializable {

    private static final long serialVersionUID = 1L;

    @Resource
    protected RoleQueryHelper roleQueryHelper;

    private volatile List<LabelTypeItem> labelTypeItems = new ArrayList<LabelTypeItem>();

    protected LabelTypeService getLabelTypeService() {
        return SingletonS2Container.getComponent(LabelTypeService.class);
    }

    @InitMethod
    public void init() {
        List<LabelType> labelTypeList = getLabelTypeService()
                .getLabelTypeListWithRoles();
        buildLabelTypeItems(labelTypeList);
    }

    public void refresh(List<LabelType> labelTypeList) {
        buildLabelTypeItems(labelTypeList);
    }

    private void buildLabelTypeItems(List<LabelType> labelTypeList) {
        List<LabelTypeItem> itemList = new ArrayList<LabelTypeItem>();
        for (LabelType labelType : labelTypeList) {
            LabelTypeItem item = new LabelTypeItem();
            item.setLabel(labelType.getName());
            item.setValue(labelType.getValue());
            item.setRoleValueList(labelType.getRoleValueList());
            itemList.add(item);
        }
        labelTypeItems = itemList;
    }

    public List<Map<String, String>> getLabelTypeItems() {
        if (labelTypeItems == null) {
            init();
        }

        List<Map<String, String>> itemList = new ArrayList<Map<String, String>>();
        List<String> roleList = roleQueryHelper.build();
        if (roleList.isEmpty()) {
            for (LabelTypeItem item : labelTypeItems) {
                Map<String, String> map = new HashMap<String, String>(2);
                map.put(Constants.ITEM_LABEL, item.getLabel());
                map.put(Constants.ITEM_VALUE, item.getValue());
                itemList.add(map);
            }
        } else {
            for (LabelTypeItem item : labelTypeItems) {
                for (String roleValue : roleList) {
                    if (item.getRoleValueList().contains(roleValue)) {
                        Map<String, String> map = new HashMap<String, String>(2);
                        map.put(Constants.ITEM_LABEL, item.getLabel());
                        map.put(Constants.ITEM_VALUE, item.getValue());
                        itemList.add(map);
                        continue;
                    }
                }
            }
        }

        return itemList;
    }

    private static class LabelTypeItem {
        private String label;

        private String value;

        private List<String> roleValueList;

        public String getLabel() {
            return label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public List<String> getRoleValueList() {
            return roleValueList;
        }

        public void setRoleValueList(List<String> roleValueList) {
            this.roleValueList = roleValueList;
        }
    }
}
