/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.cbean.cq.bs;

import java.util.Map;

import jp.sf.fess.db.cbean.RoleTypeCB;
import jp.sf.fess.db.cbean.cq.FileConfigToRoleTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.RoleTypeCQ;
import jp.sf.fess.db.cbean.cq.WebConfigToRoleTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.ciq.RoleTypeCIQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;

/**
 * The base condition-query of ROLE_TYPE.
 * @author DBFlute(AutoGenerator)
 */
public class BsRoleTypeCQ extends AbstractBsRoleTypeCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected RoleTypeCIQ _inlineQuery;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public BsRoleTypeCQ(ConditionQuery childQuery, SqlClause sqlClause,
            String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                              Inline
    //                                                                              ======
    /**
     * Prepare inline query. <br />
     * {select ... from ... left outer join (select * from ROLE_TYPE) where abc = [abc] ...}
     * @return Inline query. (NotNull)
     */
    public RoleTypeCIQ inline() {
        if (_inlineQuery == null) {
            _inlineQuery = new RoleTypeCIQ(getChildQuery(), getSqlClause(),
                    getAliasName(), getNestLevel(), this);
        }
        _inlineQuery.xsetOnClauseInline(false);
        return _inlineQuery;
    }

    /**
     * Prepare on-clause query. <br />
     * {select ... from ... left outer join ROLE_TYPE on ... and abc = [abc] ...}
     * @return On-clause query. (NotNull)
     */
    public RoleTypeCIQ on() {
        if (isBaseQuery(this)) {
            throw new UnsupportedOperationException(
                    "Unsupported on-clause for local table!");
        }
        RoleTypeCIQ inlineQuery = inline();
        inlineQuery.xsetOnClauseInline(true);
        return inlineQuery;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    protected ConditionValue _id;

    public ConditionValue getId() {
        if (_id == null) {
            _id = nCV();
        }
        return _id;
    }

    protected ConditionValue getCValueId() {
        return getId();
    }

    protected Map<String, FileConfigToRoleTypeMappingCQ> _id_InScopeSubQuery_FileConfigToRoleTypeMappingListMap;

    public Map<String, FileConfigToRoleTypeMappingCQ> getId_InScopeSubQuery_FileConfigToRoleTypeMappingList() {
        return _id_InScopeSubQuery_FileConfigToRoleTypeMappingListMap;
    }

    public String keepId_InScopeSubQuery_FileConfigToRoleTypeMappingList(
            FileConfigToRoleTypeMappingCQ subQuery) {
        if (_id_InScopeSubQuery_FileConfigToRoleTypeMappingListMap == null) {
            _id_InScopeSubQuery_FileConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeSubQuery_FileConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_InScopeSubQuery_FileConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_InScopeSubQuery_FileConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, WebConfigToRoleTypeMappingCQ> _id_InScopeSubQuery_WebConfigToRoleTypeMappingListMap;

    public Map<String, WebConfigToRoleTypeMappingCQ> getId_InScopeSubQuery_WebConfigToRoleTypeMappingList() {
        return _id_InScopeSubQuery_WebConfigToRoleTypeMappingListMap;
    }

    public String keepId_InScopeSubQuery_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery) {
        if (_id_InScopeSubQuery_WebConfigToRoleTypeMappingListMap == null) {
            _id_InScopeSubQuery_WebConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeSubQuery_WebConfigToRoleTypeMappingListMap.size() + 1);
        _id_InScopeSubQuery_WebConfigToRoleTypeMappingListMap
                .put(key, subQuery);
        return "id_InScopeSubQuery_WebConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, FileConfigToRoleTypeMappingCQ> _id_NotInScopeSubQuery_FileConfigToRoleTypeMappingListMap;

    public Map<String, FileConfigToRoleTypeMappingCQ> getId_NotInScopeSubQuery_FileConfigToRoleTypeMappingList() {
        return _id_NotInScopeSubQuery_FileConfigToRoleTypeMappingListMap;
    }

    public String keepId_NotInScopeSubQuery_FileConfigToRoleTypeMappingList(
            FileConfigToRoleTypeMappingCQ subQuery) {
        if (_id_NotInScopeSubQuery_FileConfigToRoleTypeMappingListMap == null) {
            _id_NotInScopeSubQuery_FileConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeSubQuery_FileConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_NotInScopeSubQuery_FileConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_NotInScopeSubQuery_FileConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, WebConfigToRoleTypeMappingCQ> _id_NotInScopeSubQuery_WebConfigToRoleTypeMappingListMap;

    public Map<String, WebConfigToRoleTypeMappingCQ> getId_NotInScopeSubQuery_WebConfigToRoleTypeMappingList() {
        return _id_NotInScopeSubQuery_WebConfigToRoleTypeMappingListMap;
    }

    public String keepId_NotInScopeSubQuery_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery) {
        if (_id_NotInScopeSubQuery_WebConfigToRoleTypeMappingListMap == null) {
            _id_NotInScopeSubQuery_WebConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeSubQuery_WebConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_NotInScopeSubQuery_WebConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_NotInScopeSubQuery_WebConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, FileConfigToRoleTypeMappingCQ> _id_ExistsSubQuery_FileConfigToRoleTypeMappingListMap;

    public Map<String, FileConfigToRoleTypeMappingCQ> getId_ExistsSubQuery_FileConfigToRoleTypeMappingList() {
        return _id_ExistsSubQuery_FileConfigToRoleTypeMappingListMap;
    }

    public String keepId_ExistsSubQuery_FileConfigToRoleTypeMappingList(
            FileConfigToRoleTypeMappingCQ subQuery) {
        if (_id_ExistsSubQuery_FileConfigToRoleTypeMappingListMap == null) {
            _id_ExistsSubQuery_FileConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsSubQuery_FileConfigToRoleTypeMappingListMap.size() + 1);
        _id_ExistsSubQuery_FileConfigToRoleTypeMappingListMap
                .put(key, subQuery);
        return "id_ExistsSubQuery_FileConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, WebConfigToRoleTypeMappingCQ> _id_ExistsSubQuery_WebConfigToRoleTypeMappingListMap;

    public Map<String, WebConfigToRoleTypeMappingCQ> getId_ExistsSubQuery_WebConfigToRoleTypeMappingList() {
        return _id_ExistsSubQuery_WebConfigToRoleTypeMappingListMap;
    }

    public String keepId_ExistsSubQuery_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery) {
        if (_id_ExistsSubQuery_WebConfigToRoleTypeMappingListMap == null) {
            _id_ExistsSubQuery_WebConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsSubQuery_WebConfigToRoleTypeMappingListMap.size() + 1);
        _id_ExistsSubQuery_WebConfigToRoleTypeMappingListMap.put(key, subQuery);
        return "id_ExistsSubQuery_WebConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, FileConfigToRoleTypeMappingCQ> _id_NotExistsSubQuery_FileConfigToRoleTypeMappingListMap;

    public Map<String, FileConfigToRoleTypeMappingCQ> getId_NotExistsSubQuery_FileConfigToRoleTypeMappingList() {
        return _id_NotExistsSubQuery_FileConfigToRoleTypeMappingListMap;
    }

    public String keepId_NotExistsSubQuery_FileConfigToRoleTypeMappingList(
            FileConfigToRoleTypeMappingCQ subQuery) {
        if (_id_NotExistsSubQuery_FileConfigToRoleTypeMappingListMap == null) {
            _id_NotExistsSubQuery_FileConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsSubQuery_FileConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_NotExistsSubQuery_FileConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_NotExistsSubQuery_FileConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, WebConfigToRoleTypeMappingCQ> _id_NotExistsSubQuery_WebConfigToRoleTypeMappingListMap;

    public Map<String, WebConfigToRoleTypeMappingCQ> getId_NotExistsSubQuery_WebConfigToRoleTypeMappingList() {
        return _id_NotExistsSubQuery_WebConfigToRoleTypeMappingListMap;
    }

    public String keepId_NotExistsSubQuery_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery) {
        if (_id_NotExistsSubQuery_WebConfigToRoleTypeMappingListMap == null) {
            _id_NotExistsSubQuery_WebConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsSubQuery_WebConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_NotExistsSubQuery_WebConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_NotExistsSubQuery_WebConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, FileConfigToRoleTypeMappingCQ> _id_SpecifyDerivedReferrer_FileConfigToRoleTypeMappingListMap;

    public Map<String, FileConfigToRoleTypeMappingCQ> getId_SpecifyDerivedReferrer_FileConfigToRoleTypeMappingList() {
        return _id_SpecifyDerivedReferrer_FileConfigToRoleTypeMappingListMap;
    }

    public String keepId_SpecifyDerivedReferrer_FileConfigToRoleTypeMappingList(
            FileConfigToRoleTypeMappingCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_FileConfigToRoleTypeMappingListMap == null) {
            _id_SpecifyDerivedReferrer_FileConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_FileConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_SpecifyDerivedReferrer_FileConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_SpecifyDerivedReferrer_FileConfigToRoleTypeMappingList."
                + key;
    }

    protected Map<String, WebConfigToRoleTypeMappingCQ> _id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingListMap;

    public Map<String, WebConfigToRoleTypeMappingCQ> getId_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingList() {
        return _id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingListMap;
    }

    public String keepId_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingListMap == null) {
            _id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingList."
                + key;
    }

    protected Map<String, FileConfigToRoleTypeMappingCQ> _id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListMap;

    public Map<String, FileConfigToRoleTypeMappingCQ> getId_QueryDerivedReferrer_FileConfigToRoleTypeMappingList() {
        return _id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListMap;
    }

    public String keepId_QueryDerivedReferrer_FileConfigToRoleTypeMappingList(
            FileConfigToRoleTypeMappingCQ subQuery) {
        if (_id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListMap == null) {
            _id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_QueryDerivedReferrer_FileConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_FileConfigToRoleTypeMappingListParameter() {
        return _id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_FileConfigToRoleTypeMappingListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListParameterMap == null) {
            _id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListParameterMap
                .put(key, parameterValue);
        return "id_QueryDerivedReferrer_FileConfigToRoleTypeMappingListParameter."
                + key;
    }

    protected Map<String, WebConfigToRoleTypeMappingCQ> _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListMap;

    public Map<String, WebConfigToRoleTypeMappingCQ> getId_QueryDerivedReferrer_WebConfigToRoleTypeMappingList() {
        return _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListMap;
    }

    public String keepId_QueryDerivedReferrer_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery) {
        if (_id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListMap == null) {
            _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListMap
                        .size() + 1);
        _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListMap.put(key,
                subQuery);
        return "id_QueryDerivedReferrer_WebConfigToRoleTypeMappingList." + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameter() {
        return _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameterMap == null) {
            _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameterMap
                .put(key, parameterValue);
        return "id_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameter."
                + key;
    }

    public BsRoleTypeCQ addOrderBy_Id_Asc() {
        regOBA("ID");
        return this;
    }

    public BsRoleTypeCQ addOrderBy_Id_Desc() {
        regOBD("ID");
        return this;
    }

    protected ConditionValue _name;

    public ConditionValue getName() {
        if (_name == null) {
            _name = nCV();
        }
        return _name;
    }

    protected ConditionValue getCValueName() {
        return getName();
    }

    public BsRoleTypeCQ addOrderBy_Name_Asc() {
        regOBA("NAME");
        return this;
    }

    public BsRoleTypeCQ addOrderBy_Name_Desc() {
        regOBD("NAME");
        return this;
    }

    protected ConditionValue _value;

    public ConditionValue getValue() {
        if (_value == null) {
            _value = nCV();
        }
        return _value;
    }

    protected ConditionValue getCValueValue() {
        return getValue();
    }

    public BsRoleTypeCQ addOrderBy_Value_Asc() {
        regOBA("VALUE");
        return this;
    }

    public BsRoleTypeCQ addOrderBy_Value_Desc() {
        regOBD("VALUE");
        return this;
    }

    protected ConditionValue _sortOrder;

    public ConditionValue getSortOrder() {
        if (_sortOrder == null) {
            _sortOrder = nCV();
        }
        return _sortOrder;
    }

    protected ConditionValue getCValueSortOrder() {
        return getSortOrder();
    }

    public BsRoleTypeCQ addOrderBy_SortOrder_Asc() {
        regOBA("SORT_ORDER");
        return this;
    }

    public BsRoleTypeCQ addOrderBy_SortOrder_Desc() {
        regOBD("SORT_ORDER");
        return this;
    }

    protected ConditionValue _createdBy;

    public ConditionValue getCreatedBy() {
        if (_createdBy == null) {
            _createdBy = nCV();
        }
        return _createdBy;
    }

    protected ConditionValue getCValueCreatedBy() {
        return getCreatedBy();
    }

    public BsRoleTypeCQ addOrderBy_CreatedBy_Asc() {
        regOBA("CREATED_BY");
        return this;
    }

    public BsRoleTypeCQ addOrderBy_CreatedBy_Desc() {
        regOBD("CREATED_BY");
        return this;
    }

    protected ConditionValue _createdTime;

    public ConditionValue getCreatedTime() {
        if (_createdTime == null) {
            _createdTime = nCV();
        }
        return _createdTime;
    }

    protected ConditionValue getCValueCreatedTime() {
        return getCreatedTime();
    }

    public BsRoleTypeCQ addOrderBy_CreatedTime_Asc() {
        regOBA("CREATED_TIME");
        return this;
    }

    public BsRoleTypeCQ addOrderBy_CreatedTime_Desc() {
        regOBD("CREATED_TIME");
        return this;
    }

    protected ConditionValue _updatedBy;

    public ConditionValue getUpdatedBy() {
        if (_updatedBy == null) {
            _updatedBy = nCV();
        }
        return _updatedBy;
    }

    protected ConditionValue getCValueUpdatedBy() {
        return getUpdatedBy();
    }

    public BsRoleTypeCQ addOrderBy_UpdatedBy_Asc() {
        regOBA("UPDATED_BY");
        return this;
    }

    public BsRoleTypeCQ addOrderBy_UpdatedBy_Desc() {
        regOBD("UPDATED_BY");
        return this;
    }

    protected ConditionValue _updatedTime;

    public ConditionValue getUpdatedTime() {
        if (_updatedTime == null) {
            _updatedTime = nCV();
        }
        return _updatedTime;
    }

    protected ConditionValue getCValueUpdatedTime() {
        return getUpdatedTime();
    }

    public BsRoleTypeCQ addOrderBy_UpdatedTime_Asc() {
        regOBA("UPDATED_TIME");
        return this;
    }

    public BsRoleTypeCQ addOrderBy_UpdatedTime_Desc() {
        regOBD("UPDATED_TIME");
        return this;
    }

    protected ConditionValue _deletedBy;

    public ConditionValue getDeletedBy() {
        if (_deletedBy == null) {
            _deletedBy = nCV();
        }
        return _deletedBy;
    }

    protected ConditionValue getCValueDeletedBy() {
        return getDeletedBy();
    }

    public BsRoleTypeCQ addOrderBy_DeletedBy_Asc() {
        regOBA("DELETED_BY");
        return this;
    }

    public BsRoleTypeCQ addOrderBy_DeletedBy_Desc() {
        regOBD("DELETED_BY");
        return this;
    }

    protected ConditionValue _deletedTime;

    public ConditionValue getDeletedTime() {
        if (_deletedTime == null) {
            _deletedTime = nCV();
        }
        return _deletedTime;
    }

    protected ConditionValue getCValueDeletedTime() {
        return getDeletedTime();
    }

    public BsRoleTypeCQ addOrderBy_DeletedTime_Asc() {
        regOBA("DELETED_TIME");
        return this;
    }

    public BsRoleTypeCQ addOrderBy_DeletedTime_Desc() {
        regOBD("DELETED_TIME");
        return this;
    }

    protected ConditionValue _versionNo;

    public ConditionValue getVersionNo() {
        if (_versionNo == null) {
            _versionNo = nCV();
        }
        return _versionNo;
    }

    protected ConditionValue getCValueVersionNo() {
        return getVersionNo();
    }

    public BsRoleTypeCQ addOrderBy_VersionNo_Asc() {
        regOBA("VERSION_NO");
        return this;
    }

    public BsRoleTypeCQ addOrderBy_VersionNo_Desc() {
        regOBD("VERSION_NO");
        return this;
    }

    // ===================================================================================
    //                                                           Specified Derived OrderBy
    //                                                           =========================
    public BsRoleTypeCQ addSpecifiedDerivedOrderBy_Asc(String aliasName) {
        registerSpecifiedDerivedOrderBy_Asc(aliasName);
        return this;
    }

    public BsRoleTypeCQ addSpecifiedDerivedOrderBy_Desc(String aliasName) {
        registerSpecifiedDerivedOrderBy_Desc(aliasName);
        return this;
    }

    // ===================================================================================
    //                                                                         Union Query
    //                                                                         ===========
    protected void reflectRelationOnUnionQuery(ConditionQuery baseQueryAsSuper,
            ConditionQuery unionQueryAsSuper) {
    }

    // ===================================================================================
    //                                                                       Foreign Query
    //                                                                       =============
    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    protected Map<String, RoleTypeCQ> _scalarSubQueryMap;

    public Map<String, RoleTypeCQ> getScalarSubQuery() {
        return _scalarSubQueryMap;
    }

    public String keepScalarSubQuery(RoleTypeCQ subQuery) {
        if (_scalarSubQueryMap == null) {
            _scalarSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_scalarSubQueryMap.size() + 1);
        _scalarSubQueryMap.put(key, subQuery);
        return "scalarSubQuery." + key;
    }

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    protected Map<String, RoleTypeCQ> _myselfInScopeSubQueryMap;

    public Map<String, RoleTypeCQ> getMyselfInScopeSubQuery() {
        return _myselfInScopeSubQueryMap;
    }

    public String keepMyselfInScopeSubQuery(RoleTypeCQ subQuery) {
        if (_myselfInScopeSubQueryMap == null) {
            _myselfInScopeSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_myselfInScopeSubQueryMap.size() + 1);
        _myselfInScopeSubQueryMap.put(key, subQuery);
        return "myselfInScopeSubQuery." + key;
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    String xCB() {
        return RoleTypeCB.class.getName();
    }

    String xCQ() {
        return RoleTypeCQ.class.getName();
    }

    String xMap() {
        return Map.class.getName();
    }
}
