/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.bs;

import java.util.Map;

import jp.sf.fess.db.cbean.DataConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.cq.BrowserTypeCQ;
import jp.sf.fess.db.cbean.cq.DataConfigToBrowserTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.DataCrawlingConfigCQ;
import jp.sf.fess.db.cbean.cq.ciq.DataConfigToBrowserTypeMappingCIQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;

/**
 * The base condition-query of DATA_CONFIG_TO_BROWSER_TYPE_MAPPING.
 * @author DBFlute(AutoGenerator)
 */
public class BsDataConfigToBrowserTypeMappingCQ extends
        AbstractBsDataConfigToBrowserTypeMappingCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected DataConfigToBrowserTypeMappingCIQ _inlineQuery;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public BsDataConfigToBrowserTypeMappingCQ(final ConditionQuery childQuery,
            final SqlClause sqlClause, final String aliasName,
            final int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                              Inline
    //                                                                              ======
    /**
     * Prepare InlineView query. <br />
     * {select ... from ... left outer join (select * from DATA_CONFIG_TO_BROWSER_TYPE_MAPPING) where FOO = [value] ...}
     * <pre>
     * cb.query().queryMemberStatus().<span style="color: #FD4747">inline()</span>.setFoo...;
     * </pre>
     * @return The condition-query for InlineView query. (NotNull)
     */
    public DataConfigToBrowserTypeMappingCIQ inline() {
        if (_inlineQuery == null) {
            _inlineQuery = createInlineQuery();
        }
        _inlineQuery.xsetOnClause(false);
        return _inlineQuery;
    }

    protected DataConfigToBrowserTypeMappingCIQ createInlineQuery() {
        return new DataConfigToBrowserTypeMappingCIQ(xgetReferrerQuery(),
                xgetSqlClause(), xgetAliasName(), xgetNestLevel(), this);
    }

    /**
     * Prepare OnClause query. <br />
     * {select ... from ... left outer join DATA_CONFIG_TO_BROWSER_TYPE_MAPPING on ... and FOO = [value] ...}
     * <pre>
     * cb.query().queryMemberStatus().<span style="color: #FD4747">on()</span>.setFoo...;
     * </pre>
     * @return The condition-query for OnClause query. (NotNull)
     * @throws IllegalConditionBeanOperationException When this condition-query is base query.
     */
    public DataConfigToBrowserTypeMappingCIQ on() {
        if (isBaseQuery()) {
            throw new IllegalConditionBeanOperationException(
                    "OnClause for local table is unavailable!");
        }
        final DataConfigToBrowserTypeMappingCIQ inlineQuery = inline();
        inlineQuery.xsetOnClause(true);
        return inlineQuery;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    protected ConditionValue _id;

    public ConditionValue getId() {
        if (_id == null) {
            _id = nCV();
        }
        return _id;
    }

    @Override
    protected ConditionValue getCValueId() {
        return getId();
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsDataConfigToBrowserTypeMappingCQ addOrderBy_Id_Asc() {
        regOBA("ID");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsDataConfigToBrowserTypeMappingCQ addOrderBy_Id_Desc() {
        regOBD("ID");
        return this;
    }

    protected ConditionValue _dataConfigId;

    public ConditionValue getDataConfigId() {
        if (_dataConfigId == null) {
            _dataConfigId = nCV();
        }
        return _dataConfigId;
    }

    @Override
    protected ConditionValue getCValueDataConfigId() {
        return getDataConfigId();
    }

    protected Map<String, DataCrawlingConfigCQ> _dataConfigId_InScopeRelation_DataCrawlingConfigMap;

    public Map<String, DataCrawlingConfigCQ> getDataConfigId_InScopeRelation_DataCrawlingConfig() {
        return _dataConfigId_InScopeRelation_DataCrawlingConfigMap;
    }

    @Override
    public String keepDataConfigId_InScopeRelation_DataCrawlingConfig(
            final DataCrawlingConfigCQ subQuery) {
        if (_dataConfigId_InScopeRelation_DataCrawlingConfigMap == null) {
            _dataConfigId_InScopeRelation_DataCrawlingConfigMap = newLinkedHashMap();
        }
        final String key = "subQueryMapKey"
                + (_dataConfigId_InScopeRelation_DataCrawlingConfigMap.size() + 1);
        _dataConfigId_InScopeRelation_DataCrawlingConfigMap.put(key, subQuery);
        return "dataConfigId_InScopeRelation_DataCrawlingConfig." + key;
    }

    protected Map<String, DataCrawlingConfigCQ> _dataConfigId_NotInScopeRelation_DataCrawlingConfigMap;

    public Map<String, DataCrawlingConfigCQ> getDataConfigId_NotInScopeRelation_DataCrawlingConfig() {
        return _dataConfigId_NotInScopeRelation_DataCrawlingConfigMap;
    }

    @Override
    public String keepDataConfigId_NotInScopeRelation_DataCrawlingConfig(
            final DataCrawlingConfigCQ subQuery) {
        if (_dataConfigId_NotInScopeRelation_DataCrawlingConfigMap == null) {
            _dataConfigId_NotInScopeRelation_DataCrawlingConfigMap = newLinkedHashMap();
        }
        final String key = "subQueryMapKey"
                + (_dataConfigId_NotInScopeRelation_DataCrawlingConfigMap
                        .size() + 1);
        _dataConfigId_NotInScopeRelation_DataCrawlingConfigMap.put(key,
                subQuery);
        return "dataConfigId_NotInScopeRelation_DataCrawlingConfig." + key;
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsDataConfigToBrowserTypeMappingCQ addOrderBy_DataConfigId_Asc() {
        regOBA("DATA_CONFIG_ID");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsDataConfigToBrowserTypeMappingCQ addOrderBy_DataConfigId_Desc() {
        regOBD("DATA_CONFIG_ID");
        return this;
    }

    protected ConditionValue _browserTypeId;

    public ConditionValue getBrowserTypeId() {
        if (_browserTypeId == null) {
            _browserTypeId = nCV();
        }
        return _browserTypeId;
    }

    @Override
    protected ConditionValue getCValueBrowserTypeId() {
        return getBrowserTypeId();
    }

    protected Map<String, BrowserTypeCQ> _browserTypeId_InScopeRelation_BrowserTypeMap;

    public Map<String, BrowserTypeCQ> getBrowserTypeId_InScopeRelation_BrowserType() {
        return _browserTypeId_InScopeRelation_BrowserTypeMap;
    }

    @Override
    public String keepBrowserTypeId_InScopeRelation_BrowserType(
            final BrowserTypeCQ subQuery) {
        if (_browserTypeId_InScopeRelation_BrowserTypeMap == null) {
            _browserTypeId_InScopeRelation_BrowserTypeMap = newLinkedHashMap();
        }
        final String key = "subQueryMapKey"
                + (_browserTypeId_InScopeRelation_BrowserTypeMap.size() + 1);
        _browserTypeId_InScopeRelation_BrowserTypeMap.put(key, subQuery);
        return "browserTypeId_InScopeRelation_BrowserType." + key;
    }

    protected Map<String, BrowserTypeCQ> _browserTypeId_NotInScopeRelation_BrowserTypeMap;

    public Map<String, BrowserTypeCQ> getBrowserTypeId_NotInScopeRelation_BrowserType() {
        return _browserTypeId_NotInScopeRelation_BrowserTypeMap;
    }

    @Override
    public String keepBrowserTypeId_NotInScopeRelation_BrowserType(
            final BrowserTypeCQ subQuery) {
        if (_browserTypeId_NotInScopeRelation_BrowserTypeMap == null) {
            _browserTypeId_NotInScopeRelation_BrowserTypeMap = newLinkedHashMap();
        }
        final String key = "subQueryMapKey"
                + (_browserTypeId_NotInScopeRelation_BrowserTypeMap.size() + 1);
        _browserTypeId_NotInScopeRelation_BrowserTypeMap.put(key, subQuery);
        return "browserTypeId_NotInScopeRelation_BrowserType." + key;
    }

    /** 
     * Add order-by as ascend.
     * @return this. (NotNull)
     */
    public BsDataConfigToBrowserTypeMappingCQ addOrderBy_BrowserTypeId_Asc() {
        regOBA("BROWSER_TYPE_ID");
        return this;
    }

    /**
     * Add order-by as descend.
     * @return this. (NotNull)
     */
    public BsDataConfigToBrowserTypeMappingCQ addOrderBy_BrowserTypeId_Desc() {
        regOBD("BROWSER_TYPE_ID");
        return this;
    }

    // ===================================================================================
    //                                                           Specified Derived OrderBy
    //                                                           =========================
    /**
     * Add order-by for specified derived column as ascend.
     * <pre>
     * cb.specify().derivedPurchaseList().max(new SubQuery&lt;PurchaseCB&gt;() {
     *     public void query(PurchaseCB subCB) {
     *         subCB.specify().columnPurchaseDatetime();
     *     }
     * }, <span style="color: #FD4747">aliasName</span>);
     * <span style="color: #3F7E5E">// order by [alias-name] asc</span>
     * cb.<span style="color: #FD4747">addSpecifiedDerivedOrderBy_Asc</span>(<span style="color: #FD4747">aliasName</span>);
     * </pre>
     * @param aliasName The alias name specified at (Specify)DerivedReferrer. (NotNull)
     * @return this. (NotNull)
     */
    public BsDataConfigToBrowserTypeMappingCQ addSpecifiedDerivedOrderBy_Asc(
            final String aliasName) {
        registerSpecifiedDerivedOrderBy_Asc(aliasName);
        return this;
    }

    /**
     * Add order-by for specified derived column as descend.
     * <pre>
     * cb.specify().derivedPurchaseList().max(new SubQuery&lt;PurchaseCB&gt;() {
     *     public void query(PurchaseCB subCB) {
     *         subCB.specify().columnPurchaseDatetime();
     *     }
     * }, <span style="color: #FD4747">aliasName</span>);
     * <span style="color: #3F7E5E">// order by [alias-name] desc</span>
     * cb.<span style="color: #FD4747">addSpecifiedDerivedOrderBy_Desc</span>(<span style="color: #FD4747">aliasName</span>);
     * </pre>
     * @param aliasName The alias name specified at (Specify)DerivedReferrer. (NotNull)
     * @return this. (NotNull)
     */
    public BsDataConfigToBrowserTypeMappingCQ addSpecifiedDerivedOrderBy_Desc(
            final String aliasName) {
        registerSpecifiedDerivedOrderBy_Desc(aliasName);
        return this;
    }

    // ===================================================================================
    //                                                                         Union Query
    //                                                                         ===========
    @Override
    protected void reflectRelationOnUnionQuery(
            final ConditionQuery baseQueryAsSuper,
            final ConditionQuery unionQueryAsSuper) {
        final DataConfigToBrowserTypeMappingCQ baseQuery = (DataConfigToBrowserTypeMappingCQ) baseQueryAsSuper;
        final DataConfigToBrowserTypeMappingCQ unionQuery = (DataConfigToBrowserTypeMappingCQ) unionQueryAsSuper;
        if (baseQuery.hasConditionQueryBrowserType()) {
            unionQuery.queryBrowserType()
                    .reflectRelationOnUnionQuery(baseQuery.queryBrowserType(),
                            unionQuery.queryBrowserType());
        }
        if (baseQuery.hasConditionQueryDataCrawlingConfig()) {
            unionQuery.queryDataCrawlingConfig().reflectRelationOnUnionQuery(
                    baseQuery.queryDataCrawlingConfig(),
                    unionQuery.queryDataCrawlingConfig());
        }
    }

    // ===================================================================================
    //                                                                       Foreign Query
    //                                                                       =============
    /**
     * Get the condition-query for relation table. <br />
     * BROWSER_TYPE as 'browserType'.
     * @return The instance of condition-query. (NotNull)
     */
    public BrowserTypeCQ queryBrowserType() {
        return getConditionQueryBrowserType();
    }

    protected BrowserTypeCQ _conditionQueryBrowserType;

    public BrowserTypeCQ getConditionQueryBrowserType() {
        if (_conditionQueryBrowserType == null) {
            _conditionQueryBrowserType = xcreateQueryBrowserType();
            xsetupOuterJoinBrowserType();
        }
        return _conditionQueryBrowserType;
    }

    protected BrowserTypeCQ xcreateQueryBrowserType() {
        final String nrp = resolveNextRelationPath(
                "DATA_CONFIG_TO_BROWSER_TYPE_MAPPING", "browserType");
        final String jan = resolveJoinAliasName(nrp, xgetNextNestLevel());
        final BrowserTypeCQ cq = new BrowserTypeCQ(this, xgetSqlClause(), jan,
                xgetNextNestLevel());
        cq.xsetForeignPropertyName("browserType");
        cq.xsetRelationPath(nrp);
        return cq;
    }

    protected void xsetupOuterJoinBrowserType() {
        final BrowserTypeCQ cq = getConditionQueryBrowserType();
        final Map<String, String> joinOnMap = newLinkedHashMap();
        joinOnMap.put("BROWSER_TYPE_ID", "ID");
        registerOuterJoin(cq, joinOnMap);
    }

    public boolean hasConditionQueryBrowserType() {
        return _conditionQueryBrowserType != null;
    }

    /**
     * Get the condition-query for relation table. <br />
     * DATA_CRAWLING_CONFIG as 'dataCrawlingConfig'.
     * @return The instance of condition-query. (NotNull)
     */
    public DataCrawlingConfigCQ queryDataCrawlingConfig() {
        return getConditionQueryDataCrawlingConfig();
    }

    protected DataCrawlingConfigCQ _conditionQueryDataCrawlingConfig;

    public DataCrawlingConfigCQ getConditionQueryDataCrawlingConfig() {
        if (_conditionQueryDataCrawlingConfig == null) {
            _conditionQueryDataCrawlingConfig = xcreateQueryDataCrawlingConfig();
            xsetupOuterJoinDataCrawlingConfig();
        }
        return _conditionQueryDataCrawlingConfig;
    }

    protected DataCrawlingConfigCQ xcreateQueryDataCrawlingConfig() {
        final String nrp = resolveNextRelationPath(
                "DATA_CONFIG_TO_BROWSER_TYPE_MAPPING", "dataCrawlingConfig");
        final String jan = resolveJoinAliasName(nrp, xgetNextNestLevel());
        final DataCrawlingConfigCQ cq = new DataCrawlingConfigCQ(this,
                xgetSqlClause(), jan, xgetNextNestLevel());
        cq.xsetForeignPropertyName("dataCrawlingConfig");
        cq.xsetRelationPath(nrp);
        return cq;
    }

    protected void xsetupOuterJoinDataCrawlingConfig() {
        final DataCrawlingConfigCQ cq = getConditionQueryDataCrawlingConfig();
        final Map<String, String> joinOnMap = newLinkedHashMap();
        joinOnMap.put("DATA_CONFIG_ID", "ID");
        registerOuterJoin(cq, joinOnMap);
    }

    public boolean hasConditionQueryDataCrawlingConfig() {
        return _conditionQueryDataCrawlingConfig != null;
    }

    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    protected Map<String, DataConfigToBrowserTypeMappingCQ> _scalarConditionMap;

    public Map<String, DataConfigToBrowserTypeMappingCQ> getScalarCondition() {
        return _scalarConditionMap;
    }

    @Override
    public String keepScalarCondition(
            final DataConfigToBrowserTypeMappingCQ subQuery) {
        if (_scalarConditionMap == null) {
            _scalarConditionMap = newLinkedHashMap();
        }
        final String key = "subQueryMapKey" + (_scalarConditionMap.size() + 1);
        _scalarConditionMap.put(key, subQuery);
        return "scalarCondition." + key;
    }

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    protected Map<String, DataConfigToBrowserTypeMappingCQ> _myselfInScopeRelationMap;

    public Map<String, DataConfigToBrowserTypeMappingCQ> getMyselfInScopeRelation() {
        return _myselfInScopeRelationMap;
    }

    @Override
    public String keepMyselfInScopeRelation(
            final DataConfigToBrowserTypeMappingCQ subQuery) {
        if (_myselfInScopeRelationMap == null) {
            _myselfInScopeRelationMap = newLinkedHashMap();
        }
        final String key = "subQueryMapKey"
                + (_myselfInScopeRelationMap.size() + 1);
        _myselfInScopeRelationMap.put(key, subQuery);
        return "myselfInScopeRelation." + key;
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // very internal (for suppressing warn about 'Not Use Import')
    protected String xCB() {
        return DataConfigToBrowserTypeMappingCB.class.getName();
    }

    protected String xCQ() {
        return DataConfigToBrowserTypeMappingCQ.class.getName();
    }

    protected String xMap() {
        return Map.class.getName();
    }
}
